/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.rasterize.idw;

import es.unex.sextante.closestpts.Point3D;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterize.interpolationBase.BaseInterpolationAlgorithm;

public class IDWAlgorithm
extends BaseInterpolationAlgorithm {
    public static final String POWER = "POWER";
    public static final String CROSSVALIDATION = "CROSSVALIDATION";
    private double m_dPower;

    @Override
    public void defineCharacteristics() {
        super.defineCharacteristics();
        this.setGroup(Sextante.getText((String)"Rasterization_and_interpolation"));
        this.setName(Sextante.getText((String)"Inverse_Distance_Weighting__IDW"));
        try {
            this.m_Parameters.addNumericalValue(POWER, Sextante.getText((String)"Exponent"), 2, 2.0, 0.0, Double.MAX_VALUE);
            this.addOutputTable(CROSSVALIDATION, Sextante.getText((String)"Cross_validation"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    @Override
    protected void setValues() throws GeoAlgorithmExecutionException {
        super.setValues();
        this.m_dPower = this.m_Parameters.getParameterValueAsDouble(POWER);
    }

    @Override
    protected double interpolate(double x, double y) {
        int iPts = 0;
        double dDistSum = 0.0;
        double dZSum = 0.0;
        try {
            if (this.m_NearestPoints.length != 0) {
                int iSize = this.m_NearestPoints.length;
                for (int i = 0; i < iSize; ++i) {
                    if (this.m_NearestPoints[i] == null) continue;
                    ++iPts;
                    Point3D pt = this.m_NearestPoints[i].getPt();
                    double d = this.m_NearestPoints[i].getDist();
                    if (d <= 0.0) {
                        return pt.getZ();
                    }
                    d = Math.pow(d, -this.m_dPower);
                    dZSum += d * pt.getZ();
                    dDistSum += d;
                }
                if (iPts > 0) {
                    return dZSum / dDistSum;
                }
                return this.NO_DATA;
            }
            return this.NO_DATA;
        }
        catch (Exception e) {
            return this.NO_DATA;
        }
    }
}

