/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.rasterize.kriging;

import Jama.Matrix;
import es.unex.sextante.closestpts.Point3D;
import es.unex.sextante.closestpts.PtAndDistance;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.rasterWrappers.GridCell;
import es.unex.sextante.rasterize.interpolationBase.BaseInterpolationAlgorithm;
import java.awt.geom.Point2D;
import java.util.Arrays;

public class KrigingAlgorithm
extends BaseInterpolationAlgorithm {
    public static final String SILL = "SILL";
    public static final String RANGE = "RANGE";
    public static final String NUGGET = "NUGGET";
    public static final String MODEL = "MODEL";
    public static final String MINPOINTS = "MINPOINTS";
    public static final String MAXPOINTS = "MAXPOINTS";
    public static final String VARIANCE = "VARIANCE";
    public static final String CROSSVALIDATION = "CROSSVALIDATION";
    private double m_dNugget;
    private double m_dScale;
    private double m_dRange;
    private double[] m_dGammas;
    private int m_iMinPoints;
    private int m_iMaxPoints;
    private int m_iModel;
    private boolean m_bCreateVarianceLayer;
    private double[][] m_dWeights;
    private Matrix m_Matrix;
    private IRasterLayer m_Variance;

    @Override
    public void defineCharacteristics() {
        super.defineCharacteristics();
        this.setGroup(Sextante.getText((String)"Rasterization_and_interpolation"));
        this.setName(Sextante.getText((String)"Kriging"));
        String[] sModels = new String[]{Sextante.getText((String)"Spherical"), Sextante.getText((String)"Exponential"), Sextante.getText((String)"Gaussian")};
        try {
            this.m_Parameters.addNumericalValue(MINPOINTS, Sextante.getText((String)"Mino_number_of_points"), 1, 4.0, 1.0, 2.147483647E9);
            this.m_Parameters.addNumericalValue(MAXPOINTS, Sextante.getText((String)"Max_number_of_points"), 1, 25.0, 1.0, 2.147483647E9);
            this.m_Parameters.addSelection(MODEL, Sextante.getText((String)"Model"), sModels);
            this.m_Parameters.addNumericalValue(NUGGET, Sextante.getText((String)"Nugget"), 2, 0.0, 0.0, Double.MAX_VALUE);
            this.m_Parameters.addNumericalValue(SILL, Sextante.getText((String)"Sill"), 2, 10.0, 0.0, Double.MAX_VALUE);
            this.m_Parameters.addNumericalValue(RANGE, Sextante.getText((String)"Range"), 2, 100.0, 0.0, Double.MAX_VALUE);
            this.addOutputTable(CROSSVALIDATION, Sextante.getText((String)"Cross_validation"));
            this.addOutputRasterLayer(VARIANCE, Sextante.getText((String)"Variances"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    @Override
    protected void setValues() throws GeoAlgorithmExecutionException {
        super.setValues();
        this.m_iMaxPoints = this.m_Parameters.getParameterValueAsInt(MAXPOINTS);
        this.m_iMinPoints = this.m_Parameters.getParameterValueAsInt(MINPOINTS);
        this.m_iModel = this.m_Parameters.getParameterValueAsInt(MODEL);
        this.m_dNugget = this.m_Parameters.getParameterValueAsDouble(NUGGET);
        this.m_dScale = this.m_Parameters.getParameterValueAsDouble(SILL) - this.m_dNugget;
        this.m_dRange = this.m_Parameters.getParameterValueAsDouble(RANGE);
        this.m_bCreateVarianceLayer = true;
        this.m_dWeights = new double[this.m_iMaxPoints + 1][this.m_iMaxPoints + 1];
        this.m_Matrix = new Matrix(this.m_dWeights);
        this.m_dGammas = new double[this.m_iMaxPoints + 1];
        if (this.m_bCreateVarianceLayer) {
            this.m_Variance = this.getNewRasterLayer(VARIANCE, this.m_Layer.getName() + Sextante.getText((String)"[variances]"), 5);
        }
    }

    @Override
    protected double getValueAt(int x, int y) {
        Point2D pt = this.m_AnalysisExtent.getWorldCoordsFromGridCoords(new GridCell(x, y, 0.0));
        Object[] nearestPoints = this.m_SearchEngine.getClosestPoints(pt.getX(), pt.getY(), this.m_dDistance);
        Arrays.sort(nearestPoints);
        int n = Math.min(nearestPoints.length, this.m_iMaxPoints);
        this.m_NearestPoints = new PtAndDistance[n];
        System.arraycopy(nearestPoints, 0, this.m_NearestPoints, 0, n);
        double dValue = this.interpolate(pt.getX(), pt.getY());
        return dValue;
    }

    @Override
    protected double getValueAt(double x, double y) {
        try {
            Object[] nearestPoints = this.m_SearchEngine.getClosestPoints(x, y, this.m_dDistance);
            Arrays.sort(nearestPoints);
            int n = Math.min(nearestPoints.length, this.m_iMaxPoints) - 1;
            this.m_NearestPoints = new PtAndDistance[n];
            System.arraycopy(nearestPoints, 1, this.m_NearestPoints, 0, n);
            return this.interpolate(x, y);
        }
        catch (Exception e) {
            return this.NO_DATA;
        }
    }

    @Override
    protected double interpolate(double x, double y) {
        int nPoints = this.getWeights(x, y);
        if (nPoints >= this.m_iMinPoints) {
            int i;
            for (i = 0; i < nPoints; ++i) {
                this.m_dGammas[i] = this.getWeight(this.m_NearestPoints[i].getDist());
            }
            this.m_dGammas[nPoints] = 1.0;
            double dValue = 0.0;
            double dVariance = 0.0;
            for (i = 0; i < nPoints; ++i) {
                Point3D pt = this.m_NearestPoints[i].getPt();
                double dLambda = 0.0;
                for (int j = 0; j <= nPoints; ++j) {
                    dLambda += this.m_dWeights[i][j] * this.m_dGammas[j];
                }
                dValue += dLambda * pt.getZ();
                if (!this.m_bCreateVarianceLayer) continue;
                dVariance += dLambda * this.m_dGammas[i];
            }
            if (this.m_bCreateVarianceLayer) {
                GridCell cell = this.m_AnalysisExtent.getGridCoordsFromWorldCoords(x, y);
                this.m_Variance.setCellValue(cell.getX(), cell.getY(), dVariance);
            }
            return dValue;
        }
        if (this.m_bCreateVarianceLayer) {
            GridCell cell = this.m_AnalysisExtent.getGridCoordsFromWorldCoords(x, y);
            this.m_Variance.setNoData(cell.getX(), cell.getY());
        }
        return this.NO_DATA;
    }

    private double getWeight(double d) {
        if (d == 0.0) {
            d = 1.0E-4;
        }
        switch (this.m_iModel) {
            case 0: {
                if (d >= this.m_dRange) {
                    d = this.m_dNugget + this.m_dScale;
                    break;
                }
                d = this.m_dNugget + this.m_dScale * (3.0 * d / (2.0 * this.m_dRange) - d * d * d / (2.0 * this.m_dRange * this.m_dRange * this.m_dRange));
                break;
            }
            case 1: {
                d = this.m_dNugget + this.m_dScale * (1.0 - Math.exp(-3.0 * d / this.m_dRange));
                break;
            }
            case 2: {
                d = 1.0 - Math.exp(-3.0 * d / (this.m_dRange * this.m_dRange));
                d = this.m_dNugget + this.m_dScale * d * d;
            }
        }
        return d;
    }

    private int getWeights(double x, double y) {
        this.m_dWeights = this.m_Matrix.getArray();
        int n = Math.min(this.m_NearestPoints.length, this.m_iMaxPoints);
        if (n >= this.m_iMinPoints) {
            for (int i = 0; i < n; ++i) {
                Point3D pt = this.m_NearestPoints[i].getPt();
                this.m_dWeights[i][i] = 0.0;
                this.m_dWeights[n][i] = 1.0;
                this.m_dWeights[i][n] = 1.0;
                for (int j = i + 1; j < n; ++j) {
                    Point3D pt2 = this.m_NearestPoints[j].getPt();
                    double dx = pt.getX() - pt2.getX();
                    double dy = pt.getY() - pt2.getY();
                    double d = this.getWeight(Math.sqrt(dx * dx + dy * dy));
                    this.m_dWeights[j][i] = d;
                    this.m_dWeights[i][j] = d;
                }
            }
            this.m_dWeights[n][n] = 0.0;
            Matrix subMatrix = this.m_Matrix.getMatrix(0, n, 0, n);
            try {
                Matrix inverse = subMatrix.inverse();
                this.m_Matrix.setMatrix(0, n, 0, n, inverse);
            }
            catch (RuntimeException e) {
                return 0;
            }
        }
        return n;
    }
}

