/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.statisticalMethods.covarianceMatrix;

import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.ITable;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.util.ArrayList;

public class CovarianceMatrixAlgorithm
extends GeoAlgorithm {
    public static final String COVARIANCES = "COVARIANCES";
    public static final String INPUT = "INPUT";
    private static double NODATA = -9999999.0;
    private ArrayList m_RasterLayers;
    private IRasterLayer[] m_Windows;
    private int m_iNX;
    private int m_iNY;
    private double[] m_dMean;

    public void defineCharacteristics() {
        this.setUserCanDefineAnalysisExtent(true);
        this.setGroup(Sextante.getText((String)"Statistical_methods"));
        this.setName(Sextante.getText((String)"Covariance_matrix"));
        try {
            this.m_Parameters.addMultipleInput(INPUT, Sextante.getText((String)"Input_layers"), 1, true);
            this.addOutputTable(COVARIANCES, Sextante.getText((String)"Covariance_matrix"));
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int j;
        int i;
        this.m_RasterLayers = this.m_Parameters.getParameterValueAsArrayList(INPUT);
        if (this.m_RasterLayers.size() == 0) {
            return false;
        }
        Object[] values = new Object[this.m_RasterLayers.size()];
        String[] sFields = new String[this.m_RasterLayers.size()];
        Class[] iTypes = new Class[this.m_RasterLayers.size()];
        String sTableName = "Matriz de covarianzas";
        double[][] dCovar = new double[this.m_RasterLayers.size()][this.m_RasterLayers.size()];
        this.m_dMean = new double[this.m_RasterLayers.size()];
        this.adjustOutputExtent();
        this.m_Windows = new IRasterLayer[this.m_RasterLayers.size()];
        for (i = 0; i < this.m_RasterLayers.size(); ++i) {
            this.m_Windows[i] = (IRasterLayer)this.m_RasterLayers.get(i);
            this.m_Windows[i].setWindowExtent(this.getAnalysisExtent());
            this.m_Windows[i].setInterpolationMethod(4);
            sFields[i] = this.m_Windows[i].getName();
            iTypes[i] = Double.class;
            this.m_dMean[i] = this.m_Windows[i].getMeanValue();
        }
        ITable table = this.getNewTable(COVARIANCES, "Matriz de covarianzas", iTypes, sFields);
        this.m_iNX = this.getAnalysisExtent().getNX();
        this.m_iNY = this.getAnalysisExtent().getNY();
        int iTotal = (int)((double)(this.m_RasterLayers.size() * this.m_RasterLayers.size()) / 2.0);
        int iCount = 0;
        for (i = 0; i < this.m_RasterLayers.size() - 1 && this.setProgress(iCount, iTotal); ++i) {
            dCovar[i][i] = 1.0;
            ++iCount;
            for (j = i + 1; j < this.m_RasterLayers.size(); ++j) {
                double d = this.getCovar(i, j);
                dCovar[j][i] = d;
                dCovar[i][j] = d;
                ++iCount;
            }
        }
        for (i = 0; i < this.m_RasterLayers.size(); ++i) {
            for (j = 0; j < this.m_RasterLayers.size(); ++j) {
                values[j] = new Double(dCovar[i][j]);
            }
            table.addRecord(values);
        }
        return !this.m_Task.isCanceled();
    }

    private double getCovar(int i, int j) {
        int iValues = 0;
        double dSum = 0.0;
        int y = 0;
        if (y < this.m_iNY && this.setProgress(y, this.m_iNY)) {
            for (int x = 0; x < this.m_iNX; ++x) {
                double dValuei = this.m_Windows[i].getCellValueAsDouble(x, y);
                double dValuej = this.m_Windows[j].getCellValueAsDouble(x, y);
                if (this.m_Windows[i].isNoDataValue(dValuei) || this.m_Windows[j].isNoDataValue(dValuej)) continue;
                dSum += (dValuei - this.m_dMean[i]) * (dValuej - this.m_dMean[j]);
                ++iValues;
            }
            if (iValues > 1) {
                return dSum / (double)(iValues - 1);
            }
            return NODATA;
        }
        return NODATA;
    }
}

