/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.tin.smoothTinBezier;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.index.strtree.STRtree;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRecord;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.tin.smoothTinBezier.Bezier;
import es.unex.sextante.tin.smoothTinBezier.BezierSurface;
import java.util.TreeMap;

public class SmoothTinBezierAlgorithm
extends GeoAlgorithm {
    public static final String TIN = "TIN";
    public static final String TINB = "TINB";
    public static final String LoD = "LoD";
    public static final String Smooth = "Smooth";
    private IVectorLayer m_Triangles;
    private IVectorLayer m_TrianglesOut;
    private int m_LoD;
    private double m_Smooth;
    private STRtree trianglesIndex;
    Coordinate[][] triangles;
    TreeMap breakLines = new TreeMap();
    Bezier[] miniBezierTriangles;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Bezier_surface"));
        this.setGroup(Sextante.getText((String)TIN));
        this.setUserCanDefineAnalysisExtent(false);
        String[] sDistance = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"};
        try {
            this.m_Parameters.addInputVectorLayer(TIN, Sextante.getText((String)TIN), 2, true);
            this.m_Parameters.addSelection(LoD, Sextante.getText((String)"Level_of_detail"), sDistance);
            this.m_Parameters.addNumericalValue(Smooth, Sextante.getText((String)"Smoothing_coef"), 2, 1.0, 0.1, 1.0);
            this.addOutputVectorLayer(TINB, Sextante.getText((String)"Result"), 2);
        }
        catch (Exception e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        double scaleZ = Double.NEGATIVE_INFINITY;
        this.m_Triangles = this.m_Parameters.getParameterValueAsVectorLayer(TIN);
        this.m_LoD = this.m_Parameters.getParameterValueAsInt(LoD);
        this.m_Smooth = this.m_Parameters.getParameterValueAsDouble(Smooth);
        Class[] types = new Class[]{Integer.class, String.class, Integer.class};
        String[] sNames = new String[]{"ID", "HardLines", "type"};
        this.m_TrianglesOut = this.getNewVectorLayer(TINB, this.m_Triangles.getName() + "_bezier", 2, types, sNames);
        int i = 0;
        int iShapeCount = this.m_Triangles.getShapesCount();
        this.triangles = new Coordinate[iShapeCount][3];
        IFeatureIterator iter = this.m_Triangles.iterator();
        try {
            this.trianglesIndex = new STRtree();
            while (iter.hasNext()) {
                IFeature feature = iter.next();
                IRecord record = feature.getRecord();
                if ((String)record.getValue(1) == "Y") {
                    this.breakLines.put(i, record.getValue(2));
                }
                this.triangles[i][0] = (Coordinate)feature.getGeometry().getCoordinates()[0].clone();
                this.triangles[i][1] = (Coordinate)feature.getGeometry().getCoordinates()[1].clone();
                this.triangles[i][2] = (Coordinate)feature.getGeometry().getCoordinates()[2].clone();
                this.trianglesIndex.insert(feature.getGeometry().getEnvelopeInternal(), (Object)new Integer(i));
                System.err.println("TRIANGLE " + i + " = " + this.triangles[i][0] + ", " + this.triangles[i][1] + ", " + this.triangles[i][2]);
                for (int k = 0; k < 2; ++k) {
                    double diffZ = this.triangles[i][k].z - this.triangles[i][k + 1].z;
                    double diffXY = Math.sqrt(Math.pow(this.triangles[i][k].x - this.triangles[i][k + 1].x, 2.0) + Math.pow(this.triangles[i][k].y - this.triangles[i][k + 1].y, 2.0));
                    if (!(scaleZ < Math.abs(diffZ / diffXY))) continue;
                    scaleZ = Math.abs(diffZ / diffXY);
                }
                this.setProgress(i, 2 * iShapeCount);
                ++i;
            }
            iter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.err.println("SCALEZ = " + scaleZ);
        this.m_Triangles = null;
        iter = null;
        BezierSurface bezierSurface = new BezierSurface(this.triangles, this.trianglesIndex, this.breakLines, scaleZ * this.m_Smooth, this.m_LoD + 1);
        int indexOfInterpolatedTriangles = 0;
        while (bezierSurface.hasNext()) {
            this.setProgress(i++, 2 * iShapeCount);
            Coordinate[][] newTin = bezierSurface.nextTrinagle();
            System.err.println("GOT " + newTin.length + " TRIANGLES");
            for (int l = 0; l < newTin.length; ++l) {
                Object[] record = new Object[]{new Integer(indexOfInterpolatedTriangles), "", -1};
                GeometryFactory gf = new GeometryFactory();
                Coordinate[] coords = new Coordinate[4];
                for (int m = 0; m < 3; ++m) {
                    coords[m] = newTin[l][m];
                    if (coords[m] == null) continue;
                    System.err.println(coords[m]);
                }
                coords[3] = newTin[l][0];
                System.err.println(coords[3]);
                LinearRing ring = gf.createLinearRing(coords);
                this.m_TrianglesOut.addFeature((Geometry)gf.createPolygon(ring, null), record);
                ++indexOfInterpolatedTriangles;
            }
        }
        return !this.m_Task.isCanceled();
    }
}

