/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.InPolygonSpatialJoin;

import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.math.simpleStats.SimpleStats;
import es.unex.sextante.vectorTools.InPolygonSpatialJoin.NearestNeighbourFinder;
import java.util.Objects;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.logger.FilteredLogger;

public class InPolygonSpatialJoinAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String POLYGONS = "POLYGONS";
    public static final String POINTS = "POINTS";
    public static final String GROUPING_FUNCTIONS = "GROUPING_FUNCTIONS";
    public static final int SUM = 0;
    public static final int MIN = 1;
    public static final int MAX = 2;
    public static final int AVG = 3;
    public static final int COUNT = 4;
    public static final String[] FUNCTIONS = new String[]{"SUM", "MIN", "MAX", "AVG", "COUNT"};
    private IVectorLayer m_MainLayer;
    private IVectorLayer m_SecondaryLayer;
    private IVectorLayer m_Output;
    private NearestNeighbourFinder m_NNF;
    private Grouping[] m_Groupings;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"InPolygonSpatialJoin"));
        this.setGroup(Sextante.getText((String)"Tools_for_polygon_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(POLYGONS, Sextante.getText((String)"Polygons_layer"), 2, true);
            this.m_Parameters.addInputVectorLayer(POINTS, Sextante.getText((String)"Secondary_layer"), -1, true);
            this.m_Parameters.addString(GROUPING_FUNCTIONS, Sextante.getText((String)"Summary_statistics"));
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"), 2, POLYGONS);
        }
        catch (RepeatedParameterNameException repeatedParameterNameException) {
            // empty catch block
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int i;
        this.m_MainLayer = this.m_Parameters.getParameterValueAsVectorLayer(POLYGONS);
        this.m_SecondaryLayer = this.m_Parameters.getParameterValueAsVectorLayer(POINTS);
        if (!this.m_bIsAutoExtent) {
            this.m_MainLayer.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
            this.m_SecondaryLayer.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        String sGroupings = this.m_Parameters.getParameterValueAsString(GROUPING_FUNCTIONS);
        this.m_Groupings = this.getGroupings(sGroupings);
        String[] sFields = new String[this.m_MainLayer.getFieldCount() + this.m_Groupings.length];
        Class[] types = new Class[this.m_MainLayer.getFieldCount() + this.m_Groupings.length];
        for (i = 0; i < this.m_MainLayer.getFieldCount(); ++i) {
            sFields[i] = this.m_MainLayer.getFieldName(i);
            types[i] = this.m_MainLayer.getFieldType(i);
        }
        for (i = 0; i < this.m_Groupings.length; ++i) {
            sFields[this.m_MainLayer.getFieldCount() + i] = this.m_SecondaryLayer.getFieldName(this.m_Groupings[i].field) + "_" + FUNCTIONS[this.m_Groupings[i].function];
            types[this.m_MainLayer.getFieldCount() + i] = Double.class;
        }
        this.m_Output = this.getNewVectorLayer(RESULT, this.m_MainLayer.getName(), this.m_MainLayer.getShapeType(), types, sFields);
        this.m_NNF = new NearestNeighbourFinder(this.m_SecondaryLayer, this.m_Task);
        int iShapeCount = this.m_MainLayer.getShapesCount();
        i = 0;
        IFeatureIterator iter = this.m_MainLayer.iterator();
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            IFeature feature = iter.next();
            this.performSpatialJoin(feature);
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }

    private void performSpatialJoin(IFeature feature) {
        Geometry polygon = feature.getGeometry();
        IFeature[] pts = this.m_NNF.getClosestPoints(polygon);
        SimpleStats[] stats = new SimpleStats[this.m_SecondaryLayer.getFieldCount()];
        for (int i = 0; i < stats.length; ++i) {
            stats[i] = new SimpleStats();
        }
        FilteredLogger logger = new FilteredLogger(LOGGER, "InPolygonSpatialJoinAlgorithm", 10);
        Coercion toDouble = ToolsLocator.getDataTypesManager().get(7).getCoercion();
        for (IFeature element : pts) {
            if (!polygon.contains(element.getGeometry())) continue;
            for (int j = 0; j < stats.length; ++j) {
                Object value = element.getRecord().getValue(j);
                try {
                    double dValue = (Double)toDouble.coerce(value);
                    stats[j].addValue(dValue);
                    continue;
                }
                catch (Exception e) {
                    stats[j].addValue();
                    logger.warn("Can't convert to double '" + Objects.toString(value) + "'.", (Throwable)e);
                }
            }
        }
        this.m_Output.addFeature(polygon, this.calculateRecord(stats, feature.getRecord().getValues()));
    }

    private Object[] calculateRecord(SimpleStats[] stats, Object[] record) {
        Object[] values = new Object[this.m_Groupings.length + record.length];
        System.arraycopy(record, 0, values, 0, record.length);
        for (int i = 0; i < this.m_Groupings.length; ++i) {
            double dValue;
            int iField = this.m_Groupings[i].field;
            int iFunction = this.m_Groupings[i].function;
            switch (iFunction) {
                case 4: {
                    dValue = stats[iField].getCount();
                    break;
                }
                case 1: {
                    dValue = stats[iField].getMin();
                    break;
                }
                case 2: {
                    dValue = stats[iField].getMax();
                    break;
                }
                case 0: {
                    dValue = stats[iField].getSum();
                    break;
                }
                default: {
                    dValue = stats[iField].getMean();
                }
            }
            values[i + record.length] = stats[iField].getCount() > 0 ? new Double(dValue) : null;
        }
        return values;
    }

    private Grouping[] getGroupings(String sGroupings) throws GeoAlgorithmExecutionException {
        if (sGroupings.trim().equals("")) {
            return new Grouping[0];
        }
        try {
            String[] sTokens = sGroupings.split(",");
            if (sTokens.length % 2 != 0) {
                throw new GeoAlgorithmExecutionException("Wrong groupings");
            }
            Grouping[] groupings = new Grouping[sTokens.length / 2];
            int iGrouping = 0;
            for (int i = 0; i < sTokens.length; ++i) {
                String sToken = sTokens[i];
                groupings[iGrouping] = new Grouping();
                groupings[iGrouping].field = Integer.parseInt(sToken);
                if (groupings[iGrouping].field >= this.m_SecondaryLayer.getFieldCount() || groupings[iGrouping].field < 0) {
                    throw new GeoAlgorithmExecutionException("Wrong groupings");
                }
                sToken = sTokens[++i];
                groupings[iGrouping].function = Integer.parseInt(sToken);
                if (groupings[iGrouping].function > 4 || groupings[iGrouping].function < 0) {
                    throw new GeoAlgorithmExecutionException("Wrong groupings");
                }
                ++iGrouping;
            }
            return groupings;
        }
        catch (Exception e) {
            throw new GeoAlgorithmExecutionException("Wrong groupings");
        }
    }

    private class Grouping {
        public int field;
        public int function;
    }
}

