/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.NNSpatialJoin;

import com.vividsolutions.jts.geom.Coordinate;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IRecord;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.vectorTools.NNSpatialJoin.SextanteRTree;

public class NNSpatialJoinAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String MAIN = "MAIN";
    public static final String SECONDARY = "SECONDARY";
    private IVectorLayer m_MainLayer;
    private IVectorLayer m_SecondaryLayer;
    private IVectorLayer m_Output;
    private SextanteRTree m_SearchEngine;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"NN_Spatial_Join"));
        this.setGroup(Sextante.getText((String)"Tools_for_vector_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(MAIN, Sextante.getText((String)"Main_layer"), -1, true);
            this.m_Parameters.addInputVectorLayer(SECONDARY, Sextante.getText((String)"Additional_layer"), -1, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"), -1);
        }
        catch (RepeatedParameterNameException repeatedParameterNameException) {
            // empty catch block
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        int i;
        this.m_MainLayer = this.m_Parameters.getParameterValueAsVectorLayer(MAIN);
        this.m_SecondaryLayer = this.m_Parameters.getParameterValueAsVectorLayer(SECONDARY);
        if (!this.m_bIsAutoExtent) {
            this.m_MainLayer.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
            this.m_SecondaryLayer.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        this.m_SearchEngine = new SextanteRTree(this.m_SecondaryLayer, this.m_Task);
        Class[] types = new Class[this.m_SecondaryLayer.getFieldCount() + this.m_MainLayer.getFieldCount()];
        String[] sFields = new String[this.m_SecondaryLayer.getFieldCount() + this.m_MainLayer.getFieldCount()];
        for (i = 0; i < this.m_MainLayer.getFieldCount(); ++i) {
            sFields[i] = this.m_MainLayer.getFieldName(i);
            types[i] = this.m_MainLayer.getFieldType(i);
        }
        for (i = 0; i < this.m_SecondaryLayer.getFieldCount(); ++i) {
            types[i + this.m_MainLayer.getFieldCount()] = this.m_SecondaryLayer.getFieldType(i);
            sFields[i + this.m_MainLayer.getFieldCount()] = this.checkAttrName(this.m_SecondaryLayer.getFieldName(i), i + this.m_MainLayer.getFieldCount(), sFields);
        }
        this.m_Output = this.getNewVectorLayer(RESULT, this.m_MainLayer.getName(), this.m_MainLayer.getShapeType(), types, sFields);
        int iShapeCount = this.m_MainLayer.getShapesCount();
        i = 0;
        IFeatureIterator iter = this.m_MainLayer.iterator();
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            IFeature feature = iter.next();
            this.performSpatialJoin(feature);
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }

    private void performSpatialJoin(IFeature feature) {
        Coordinate coord = feature.getGeometry().getCoordinate();
        IFeature closestFeature = this.m_SearchEngine.getClosestFeature(coord.x, coord.y);
        Object[] record = new Object[this.m_SecondaryLayer.getFieldCount() + this.m_MainLayer.getFieldCount()];
        IRecord closestFeatureRecord = closestFeature.getRecord();
        for (int i = 0; i < this.m_SecondaryLayer.getFieldCount(); ++i) {
            record[i + this.m_MainLayer.getFieldCount()] = closestFeatureRecord.getValue(i);
        }
        IRecord mainRecord = feature.getRecord();
        for (int i = 0; i < this.m_MainLayer.getFieldCount(); ++i) {
            record[i] = mainRecord.getValue(i);
        }
        this.m_Output.addFeature(feature.getGeometry(), record);
    }
}

