/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.cleanPointsLayer;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.util.Arrays;
import java.util.BitSet;

public class CleanPointsLayerAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String RESULT = "RESULT";

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Clean_points_layer"));
        this.setGroup(Sextante.getText((String)"Tools_for_point_layers"));
        this.setUserCanDefineAnalysisExtent(false);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Points_layer"), 0, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"), 0);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IVectorLayer layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        IVectorLayer output = this.getNewVectorLayer(RESULT, layer.getName(), layer.getShapeType(), layer.getFieldTypes(), layer.getFieldNames());
        int i = 0;
        int iShapeCount = layer.getShapesCount();
        Object[] coords = new Coordinate[iShapeCount];
        IFeatureIterator iter = layer.iterator();
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            IFeature feature = iter.next();
            Geometry geom = feature.getGeometry();
            Coordinate coord = geom.getCoordinate();
            coords[i] = new Coordinate(coord.x, coord.y, (double)i);
            ++i;
        }
        iter.close();
        Arrays.sort(coords);
        BitSet add = new BitSet(iShapeCount);
        add.set((int)((Coordinate)coords[0]).z);
        for (int j = 1; j < coords.length; ++j) {
            if (coords[j].compareTo(coords[j - 1]) == 0) continue;
            add.set((int)((Coordinate)coords[j]).z);
        }
        i = 0;
        iter = layer.iterator();
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            IFeature feature = iter.next();
            if (add.get(i)) {
                output.addFeature(feature.getGeometry(), feature.getRecord().getValues());
            }
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }
}

