/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.delaunay;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.triangulate.ConformingDelaunayTriangulationBuilder;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.util.ArrayList;

public class DelaunayAlgorithm
extends GeoAlgorithm {
    public static final String POINTS = "POINTS";
    public static final String TRIANGLES = "TRIANGLES";
    private IVectorLayer m_Points;
    private IVectorLayer m_Triangles;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Delaunay_triangulation"));
        this.setGroup(Sextante.getText((String)"Tools_for_point_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(POINTS, Sextante.getText((String)"Points_layer"), 0, true);
            this.addOutputVectorLayer(TRIANGLES, Sextante.getText((String)"Result"), 2);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        GeometryFactory gf = new GeometryFactory();
        this.m_Points = this.m_Parameters.getParameterValueAsVectorLayer(POINTS);
        if (!this.m_bIsAutoExtent) {
            this.m_Points.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        Class[] types = new Class[]{Integer.class};
        String[] sNames = new String[]{"ID"};
        this.m_Triangles = this.getNewVectorLayer(TRIANGLES, this.m_Points.getName() + "[" + Sextante.getText((String)"triangulated") + "]", 2, types, sNames);
        int i = 0;
        ArrayList<Point> list = new ArrayList<Point>();
        int iShapeCount = this.m_Points.getShapesCount();
        IFeatureIterator iter = this.m_Points.iterator();
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            IFeature feature = iter.next();
            Coordinate coord = feature.getGeometry().getCoordinate();
            list.add(gf.createPoint(coord));
            ++i;
        }
        iter.close();
        this.m_Task.setDeterminate(false);
        GeometryCollection geomcol = gf.createGeometryCollection(list.toArray(new Geometry[0]));
        ConformingDelaunayTriangulationBuilder delaunay = new ConformingDelaunayTriangulationBuilder();
        delaunay.setSites((Geometry)geomcol);
        Geometry triangles = delaunay.getTriangles(gf);
        int iTriangles = triangles.getNumGeometries();
        for (int iTriangle = 0; iTriangle < iTriangles; ++iTriangle) {
            Geometry triangle = triangles.getGeometryN(iTriangle);
            Object[] record = new Object[]{new Integer(iTriangle)};
            this.m_Triangles.addFeature(triangle, record);
        }
        return !this.m_Task.isCanceled();
    }
}

