/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.difference;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.TopologyException;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.IteratorException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class DifferenceAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String CLIPLAYER = "CLIPLAYER";
    public static final String RESULT = "RESULT";
    private IVectorLayer m_Output;
    private Geometry m_ClipGeometry;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IVectorLayer layerIn = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        IVectorLayer layerClip = this.m_Parameters.getParameterValueAsVectorLayer(CLIPLAYER);
        if (!this.m_bIsAutoExtent) {
            layerIn.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
            layerClip.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        this.m_ClipGeometry = this.computeJtsClippingPoly(layerClip);
        this.m_Output = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Difference"), layerIn.getShapeType(), layerIn.getFieldTypes(), layerIn.getFieldNames());
        IFeatureIterator iter = layerIn.iterator();
        int i = 0;
        int iShapeCount = layerIn.getShapesCount();
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            IFeature feature = iter.next();
            Geometry g = this.difference(feature.getGeometry());
            if (g != null) {
                this.m_Output.addFeature(g, feature.getRecord().getValues());
            }
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Difference"));
        this.setGroup(Sextante.getText((String)"Tools_for_polygon_layers"));
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Layer_to_clip"), 2, true);
            this.m_Parameters.addInputVectorLayer(CLIPLAYER, Sextante.getText((String)"Clipping_layer"), 2, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Difference"), 2);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public Geometry difference(Geometry g) throws GeoAlgorithmExecutionException {
        block7: {
            if (g == null) {
                return null;
            }
            Geometry env = g.getEnvelope();
            if (env == null) {
                return null;
            }
            if (!env.intersects(this.m_ClipGeometry.getEnvelope())) {
                return null;
            }
            if (g.intersects(this.m_ClipGeometry)) {
                try {
                    Geometry newGeom = g.difference(this.m_ClipGeometry);
                    return newGeom;
                }
                catch (TopologyException e) {
                    if (!g.isValid()) {
                        throw new GeoAlgorithmExecutionException("Wrong input geometry");
                    }
                    if (this.m_ClipGeometry.isValid()) break block7;
                    throw new GeoAlgorithmExecutionException("Wrong clipping geometry");
                }
            }
        }
        return null;
    }

    private Geometry computeJtsClippingPoly(IVectorLayer layer) throws IteratorException {
        Geometry geometry = null;
        GeometryFactory geomFact = new GeometryFactory();
        IFeatureIterator iter = layer.iterator();
        while (iter.hasNext()) {
            IFeature feature = iter.next();
            Geometry currentGeometry = feature.getGeometry();
            if (geometry == null) {
                geometry = currentGeometry;
                continue;
            }
            Geometry[] geoms = new Geometry[]{geometry, currentGeometry};
            GeometryCollection gc = geomFact.createGeometryCollection(geoms);
            geometry = gc.buffer(0.0);
        }
        iter.close();
        return geometry;
    }
}

