/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.polylinesToSingleSegments;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.math.regression.Regression;
import es.unex.sextante.math.simpleStats.SimpleStats;
import java.util.ArrayList;

public class PolylinesToSingleSegmentsAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String LINES = "LINES";
    private IVectorLayer m_Output;
    private ArrayList m_Lines;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Polylines_to_single_segments"));
        this.setGroup(Sextante.getText((String)"Tools_for_line_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LINES, Sextante.getText((String)"Lines"), 1, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Lines"), 1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        IVectorLayer lines = this.m_Parameters.getParameterValueAsVectorLayer(LINES);
        if (!this.m_bIsAutoExtent) {
            lines.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        this.m_Output = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Result"), 1, lines.getFieldTypes(), lines.getFieldNames());
        int i = 0;
        int iShapeCount = lines.getShapesCount();
        IFeatureIterator iter = lines.iterator();
        GeometryFactory gf = new GeometryFactory();
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            IFeature feature = iter.next();
            Geometry geom = feature.getGeometry();
            this.m_Lines = new ArrayList();
            for (int j = 0; j < geom.getNumGeometries(); ++j) {
                Geometry line = geom.getGeometryN(j);
                this.addLine(line);
            }
            LineString[] lineStrings = new LineString[this.m_Lines.size()];
            for (int j = 0; j < lineStrings.length; ++j) {
                lineStrings[j] = (LineString)this.m_Lines.get(j);
            }
            this.m_Output.addFeature((Geometry)gf.createMultiLineString(lineStrings), feature.getRecord().getValues());
            ++i;
        }
        iter.close();
        return !this.m_Task.isCanceled();
    }

    private void addLine(Geometry line) {
        Coordinate[] coords = line.getCoordinates();
        Regression regression = new Regression();
        SimpleStats stats = new SimpleStats();
        for (Coordinate element : coords) {
            regression.addValue(element.x, element.y);
            stats.addValue(element.x);
        }
        regression.calculate();
        double dCoeff = regression.getCoeff();
        double dConst = regression.getConstant();
        double x = stats.getMin();
        double x2 = stats.getMax();
        double y = dConst + dCoeff * x;
        double y2 = dConst + dCoeff * x2;
        GeometryFactory gf = new GeometryFactory();
        Coordinate[] segmentCoords = new Coordinate[]{new Coordinate(x, y), new Coordinate(x2, y2)};
        this.m_Lines.add(gf.createLineString(segmentCoords));
    }
}

