/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.splitMultipart;

import com.vividsolutions.jts.geom.Geometry;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class SplitMultipartAlgorithm
extends GeoAlgorithm {
    public static final String INPUT = "INPUT";
    public static final String RESULT = "RESULT";
    private IVectorLayer m_Output;
    private IVectorLayer m_Input;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Separate_multi-part_features"));
        this.setGroup(Sextante.getText((String)"Tools_for_vector_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(INPUT, Sextante.getText((String)"Layer"), -1, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"), -1, INPUT);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Input = this.m_Parameters.getParameterValueAsVectorLayer(INPUT);
        if (!this.m_bIsAutoExtent) {
            this.m_Input.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        this.m_Output = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Result"), this.m_Input.getShapeType(), this.m_Input.getFieldTypes(), this.m_Input.getFieldNames());
        if (this.m_Input.getShapesCount() == 0) {
            return false;
        }
        int i = 0;
        int iShapeCount = this.m_Input.getShapesCount();
        IFeatureIterator iter = this.m_Input.iterator();
        while (iter.hasNext() && this.setProgress(i, iShapeCount)) {
            IFeature feature = iter.next();
            Geometry geom = feature.getGeometry();
            Object[] values = feature.getRecord().getValues();
            for (int j = 0; j < geom.getNumGeometries(); ++j) {
                Geometry subgeom = geom.getGeometryN(j);
                this.m_Output.addFeature(subgeom, values);
            }
        }
        return !this.m_Task.isCanceled();
    }
}

