/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.symDifference;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.TopologyException;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.IteratorException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class SymDifferenceAlgorithm
extends GeoAlgorithm {
    public static final String LAYER1 = "LAYER1";
    public static final String LAYER2 = "LAYER2";
    public static final String RESULT = "RESULT";
    private IVectorLayer m_Output;
    private Geometry m_ClipGeometry1;
    private Geometry m_ClipGeometry2;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        Class fieldType;
        int i;
        IVectorLayer layer1 = this.m_Parameters.getParameterValueAsVectorLayer(LAYER1);
        IVectorLayer layer2 = this.m_Parameters.getParameterValueAsVectorLayer(LAYER2);
        if (!this.m_bIsAutoExtent) {
            layer1.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
            layer2.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        Class[] fieldTypes = new Class[layer1.getFieldCount() + layer2.getFieldCount()];
        String[] sFieldNames = new String[fieldTypes.length];
        for (i = 0; i < layer1.getFieldCount(); ++i) {
            fieldTypes[i] = fieldType = layer1.getFieldType(i);
            sFieldNames[i] = layer1.getFieldName(i);
        }
        for (i = 0; i < layer2.getFieldCount(); ++i) {
            fieldType = layer2.getFieldType(i);
            int targetIndex = i + layer1.getFieldCount();
            fieldTypes[targetIndex] = fieldType;
            sFieldNames[targetIndex] = this.checkAttrName(layer2.getFieldName(i), targetIndex, sFieldNames);
        }
        this.m_Output = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Symmetric_difference"), layer1.getShapeType(), fieldTypes, sFieldNames);
        Object[] resultValues = new Object[fieldTypes.length];
        this.m_ClipGeometry1 = this.computeJtsClippingPoly(layer2);
        IFeatureIterator iter1 = layer1.iterator();
        int i2 = 0;
        int iShapeCount1 = layer1.getShapesCount();
        while (iter1.hasNext() && this.setProgress(i2, iShapeCount1)) {
            IFeature feature1 = iter1.next();
            Geometry g = this.symDifference(feature1.getGeometry(), this.m_ClipGeometry1);
            if (g != null) {
                this.initializeDefaultValues(fieldTypes, resultValues);
                Object[] values1 = feature1.getRecord().getValues();
                System.arraycopy(values1, 0, resultValues, 0, layer1.getFieldCount());
                this.m_Output.addFeature(g, resultValues);
            }
            ++i2;
        }
        iter1.close();
        this.m_ClipGeometry2 = this.computeJtsClippingPoly(layer1);
        IFeatureIterator iter2 = layer2.iterator();
        int j = 0;
        int iShapeCount2 = layer2.getShapesCount();
        while (iter2.hasNext() && this.setProgress(j, iShapeCount2)) {
            IFeature feature2 = iter2.next();
            Geometry g = this.symDifference(feature2.getGeometry(), this.m_ClipGeometry2);
            if (g != null) {
                this.initializeDefaultValues(fieldTypes, resultValues);
                Object[] values2 = feature2.getRecord().getValues();
                System.arraycopy(values2, 0, resultValues, layer1.getFieldCount(), layer2.getFieldCount());
                this.m_Output.addFeature(g, resultValues);
            }
            ++j;
        }
        iter2.close();
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Symmetric_difference"));
        this.setGroup(Sextante.getText((String)"Tools_for_polygon_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER1, Sextante.getText((String)"Primera_capa"), 2, true);
            this.m_Parameters.addInputVectorLayer(LAYER2, Sextante.getText((String)"Segunda_capa"), 2, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Symmetric_difference"), 2);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public Geometry symDifference(Geometry g, Geometry m_ClipGeometry) throws GeoAlgorithmExecutionException {
        if (g == null) {
            return null;
        }
        Geometry env = g.getEnvelope();
        if (env == null) {
            return null;
        }
        if (!env.intersects(m_ClipGeometry.getEnvelope())) {
            return g;
        }
        if (g.intersects(m_ClipGeometry)) {
            try {
                Geometry newGeom = g.difference(m_ClipGeometry);
                return newGeom;
            }
            catch (TopologyException e) {
                if (!g.isValid()) {
                    throw new GeoAlgorithmExecutionException("Wrong input geometry");
                }
                if (!m_ClipGeometry.isValid()) {
                    throw new GeoAlgorithmExecutionException("Wrong clipping geometry");
                }
            }
        } else {
            return g;
        }
        return null;
    }

    private Geometry computeJtsClippingPoly(IVectorLayer layer) throws IteratorException {
        Geometry geometry = null;
        GeometryFactory geomFact = new GeometryFactory();
        IFeatureIterator iter = layer.iterator();
        while (iter.hasNext()) {
            IFeature feature = iter.next();
            Geometry currentGeometry = feature.getGeometry();
            if (geometry == null) {
                geometry = currentGeometry;
                continue;
            }
            Geometry[] geoms = new Geometry[]{geometry, currentGeometry};
            GeometryCollection gc = geomFact.createGeometryCollection(geoms);
            geometry = gc.buffer(0.0);
        }
        iter.close();
        return geometry;
    }
}

