/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.vectorMean;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;

public class VectorMeanAlgorithm
extends GeoAlgorithm {
    public static final String LINES = "LINES";
    public static final String RESULT = "RESULT";
    private IVectorLayer m_Driver;
    private double m_dSumX = 0.0;
    private double m_dSumY = 0.0;
    private double m_dSumDifX = 0.0;
    private double m_dSumDifY = 0.0;
    private double m_dAbsSumDifX = 0.0;
    private double m_dAbsSumDifY = 0.0;
    private int m_iCount = 0;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        String[] sFields = new String[]{Sextante.getText((String)"Mean_distance"), Sextante.getText((String)"Angle"), Sextante.getText((String)"Circular_variance")};
        Class[] types = new Class[]{Double.class, Double.class, Double.class};
        IVectorLayer lines = this.m_Parameters.getParameterValueAsVectorLayer(LINES);
        if (!this.m_bIsAutoExtent) {
            lines.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        this.m_Driver = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Vector_mean"), 1, types, sFields);
        int i = 0;
        int iCount = lines.getShapesCount();
        IFeatureIterator iter = lines.iterator();
        while (iter.hasNext() && this.setProgress(i, iCount)) {
            IFeature feature = iter.next();
            Geometry geom = feature.getGeometry();
            for (int j = 0; j < geom.getNumGeometries(); ++j) {
                Geometry subgeom = geom.getGeometryN(j);
                this.processLine(subgeom.getCoordinates());
            }
            ++i;
        }
        double x = this.m_dSumX / (2.0 * (double)this.m_iCount);
        double y = this.m_dSumY / (2.0 * (double)this.m_iCount);
        double x2 = x + this.m_dSumDifX / (double)this.m_iCount;
        double y2 = y + this.m_dSumDifY / (double)this.m_iCount;
        Coordinate[] coords = new Coordinate[]{new Coordinate(x, y), new Coordinate(x2, y2)};
        double dLength = Math.sqrt(Math.pow(x2 - x, 2.0) + Math.pow(y2 - y, 2.0));
        double dTotalLength = Math.sqrt(Math.pow(this.m_dAbsSumDifX / (double)this.m_iCount, 2.0) + Math.pow(this.m_dAbsSumDifY / (double)this.m_iCount, 2.0));
        double dAngle = Math.atan2(y2 - y, x2 - x) / Math.PI * 180.0;
        Object[] value = new Object[]{new Double(dLength), new Double(dAngle), new Double(1.0 - dLength / dTotalLength)};
        GeometryFactory gf = new GeometryFactory();
        this.m_Driver.addFeature((Geometry)gf.createLineString(coords), value);
        return !this.m_Task.isCanceled();
    }

    private void processLine(Coordinate[] coords) {
        if (coords.length == 0) {
            return;
        }
        double x = coords[0].x;
        double y = coords[0].y;
        this.m_dSumX += x;
        this.m_dSumY += y;
        double x2 = coords[coords.length - 1].x;
        double y2 = coords[coords.length - 1].y;
        this.m_dSumX += x2;
        this.m_dSumY += y2;
        this.m_dSumDifX += x2 - x;
        this.m_dSumDifY += y2 - y;
        this.m_dAbsSumDifX += Math.abs(x2 - x);
        this.m_dAbsSumDifY += Math.abs(y2 - y);
        ++this.m_iCount;
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Directional_mean"));
        this.setGroup(Sextante.getText((String)"Tools_for_line_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LINES, Sextante.getText((String)"Lines"), 1, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Directional_mean"), 1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }
}

