/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorTools.vectorSpatialCluster;

import com.vividsolutions.jts.geom.Coordinate;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.OutputFactory;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.outputs.IOutputChannel;
import es.unex.sextante.outputs.Output;
import es.unex.sextante.outputs.OutputVectorLayer;
import es.unex.sextante.shapesTools.ShapesTools;
import java.util.Arrays;

public class VectorSpatialClusterAlgorithm
extends GeoAlgorithm {
    public static final String RESULT = "RESULT";
    public static final String NUMCLASS = "NUMCLASS";
    public static final String LAYER = "LAYER";
    private ValueAndClass[] m_Classes;
    private double[][] m_dMean;
    private int m_iClasses;
    private int m_iThreshold;
    private IVectorLayer m_LayerIn;
    private static double NO_DATA = Double.NEGATIVE_INFINITY;
    private static int NO_DATA_CLASS = Integer.MAX_VALUE;

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        Class[] types = new Class[]{Integer.class};
        String[] sFields = new String[]{Sextante.getText((String)"Class")};
        this.m_iClasses = this.m_Parameters.getParameterValueAsInt(NUMCLASS);
        this.m_LayerIn = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        if (!this.m_bIsAutoExtent) {
            this.m_LayerIn.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        this.m_Classes = new ValueAndClass[this.m_LayerIn.getShapesCount()];
        IFeatureIterator iter = this.m_LayerIn.iterator();
        int i = 0;
        while (iter.hasNext()) {
            IFeature feature = iter.next();
            Coordinate coord = feature.getGeometry().getCoordinate();
            this.m_Classes[i] = new ValueAndClass(2);
            this.m_Classes[i].dValue[0] = coord.x;
            this.m_Classes[i].dValue[1] = coord.y;
            ++i;
        }
        this.classify();
        Object[][] values = new Object[1][this.m_LayerIn.getShapesCount()];
        for (i = 0; i < this.m_Classes.length; ++i) {
            values[0][i] = new Integer(this.m_Classes[i].iClass);
        }
        IOutputChannel channel = this.getOutputChannel(RESULT);
        OutputVectorLayer out = new OutputVectorLayer();
        out.setDescription(Sextante.getText((String)"Result"));
        out.setName(RESULT);
        out.setOutputChannel(channel);
        out.setOutputObject((Object)ShapesTools.addFields((OutputFactory)this.m_OutputFactory, (IVectorLayer)this.m_LayerIn, (IOutputChannel)channel, (String[])sFields, (Object[][])values, (Class[])types));
        this.addOutputObject((Output)out);
        return !this.m_Task.isCanceled();
    }

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Spatial_cluster"));
        this.setGroup(Sextante.getText((String)"Tools_for_point_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Layer"), 0, true);
            this.m_Parameters.addNumericalValue(NUMCLASS, Sextante.getText((String)"Number_of_classes"), 1, 3.0, 2.0, 2.147483647E9);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"), 0);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    private void initValues() {
        int j;
        int i;
        int iValues = 0;
        double[] dMin = new double[2];
        double[] dMax = new double[2];
        for (i = 0; i < 2; ++i) {
            dMin[i] = Double.MAX_VALUE;
            dMax[i] = Double.NEGATIVE_INFINITY;
        }
        for (i = 0; i < this.m_Classes.length; ++i) {
            boolean bNoData = false;
            for (j = 0; j < this.m_Classes[i].dValue.length; ++j) {
                double dValue = this.m_Classes[i].dValue[j];
                if (dValue != NO_DATA) {
                    dMin[j] = Math.min(dMin[j], dValue);
                    dMax[j] = Math.max(dMax[j], dValue);
                    continue;
                }
                bNoData = true;
            }
            if (bNoData) {
                this.m_Classes[i].iClass = NO_DATA_CLASS;
                continue;
            }
            ++iValues;
            this.m_Classes[i].iClass = 0;
        }
        this.m_dMean = new double[this.m_iClasses][2];
        for (i = 0; i < 2; ++i) {
            double dStep = (dMax[i] - dMin[i]) / (double)(this.m_iClasses + 1);
            for (j = 0; j < this.m_iClasses; ++j) {
                this.m_dMean[j][i] = dMin[i] + dStep * (double)(j + 1);
            }
        }
        this.m_iThreshold = (int)((double)iValues * 0.02);
    }

    private boolean classify() {
        int iChangedCells;
        int[] iCells = new int[this.m_iClasses];
        this.initValues();
        double[][] dNewMean = new double[this.m_iClasses][2];
        do {
            int j;
            int i;
            Arrays.fill(iCells, 0);
            iChangedCells = 0;
            for (i = 0; i < this.m_iClasses; ++i) {
                Arrays.fill(dNewMean[i], 0.0);
            }
            for (i = 0; i < this.m_Classes.length; ++i) {
                int iClass;
                int iPrevClass = this.m_Classes[i].iClass;
                if (iPrevClass == NO_DATA_CLASS) continue;
                this.m_Classes[i].iClass = iClass = this.getClass(this.m_Classes[i].dValue);
                for (j = 0; j < 2; ++j) {
                    double[] dArray = dNewMean[iClass];
                    int n = j;
                    dArray[n] = dArray[n] + this.m_Classes[i].dValue[j];
                }
                int n = iClass;
                iCells[n] = iCells[n] + 1;
                if (iClass == iPrevClass) continue;
                ++iChangedCells;
            }
            for (i = 0; i < 2; ++i) {
                for (j = 0; j < this.m_iClasses; ++j) {
                    double[] dArray = dNewMean[j];
                    int n = i;
                    dArray[n] = dArray[n] / (double)iCells[j];
                }
            }
            double[][] swap = this.m_dMean;
            this.m_dMean = dNewMean;
            dNewMean = swap;
            this.setProgressText(Sextante.getText((String)"Modified_classes") + Integer.toString(iChangedCells));
            if (!this.m_Task.isCanceled()) continue;
            return false;
        } while (iChangedCells > this.m_iThreshold);
        return true;
    }

    private int getClass(double[] dValues) {
        int iClass = 0;
        double dMinDist = Double.MAX_VALUE;
        for (int i = 0; i < this.m_iClasses; ++i) {
            double dDist = 0.0;
            for (int j = 0; j < dValues.length; ++j) {
                double dDif = this.m_dMean[i][j] - dValues[j];
                dDist += dDif * dDif;
            }
            if (!(dDist < dMinDist)) continue;
            dMinDist = dDist;
            iClass = i;
        }
        return iClass;
    }

    private class ValueAndClass {
        public double[] dValue;
        public int iClass;

        public ValueAndClass(int i) {
            this.dValue = new double[i];
        }
    }
}

