/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.vectorize.vectorizeB;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UnsupportedOutputChannelException;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class VectorizeBAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String RESULT = "RESULT";
    private IRasterLayer m_Input;
    private IRasterLayer m_Edge;
    private IVectorLayer m_Polygons;
    private int m_iNX;
    private int m_iNY;
    private char[][] m_Lock;
    private ArrayList<Coordinate> m_Coords;
    private ArrayList<Geometry> m_Polyg;
    private static final int[] m_IX = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private static final int[] m_IY = new int[]{-1, -1, 0, 1, 1, 1, 0, -1};

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Vectorize_raster_layer__polygons") + "(B)");
        this.setGroup(Sextante.getText((String)"Vectorization"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputRasterLayer(LAYER, Sextante.getText((String)"Input_layer"), true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Result"), 2);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        String[] sFields = new String[2];
        Class[] types = new Class[]{Integer.class, Double.class};
        this.m_Input = this.m_Parameters.getParameterValueAsRasterLayer(LAYER);
        this.m_Input.setWindowExtent(this.m_AnalysisExtent);
        sFields[0] = "ID";
        sFields[1] = this.m_Input.getName();
        this.m_Polygons = this.getNewVectorLayer(RESULT, Sextante.getText((String)"Result"), 2, types, sFields);
        this.createPolygons();
        return !this.m_Task.isCanceled();
    }

    private void createPolygons() throws UnsupportedOutputChannelException {
        this.m_iNX = this.m_Input.getNX();
        this.m_iNY = this.m_Input.getNY();
        this.m_Coords = new ArrayList();
        this.m_Polyg = new ArrayList();
        this.m_Lock = new char[this.m_iNY][this.m_iNX];
        AnalysisExtent ge = new AnalysisExtent();
        AnalysisExtent wge = this.m_Input.getWindowGridExtent();
        ge.setCellSize(wge.getCellSize() * 0.5);
        ge.setXRange(wge.getXMin() - wge.getCellSize() * 0.5, wge.getXMax() + wge.getCellSize() * 0.5, true);
        ge.setYRange(wge.getYMin() - wge.getCellSize() * 0.5, wge.getYMax() + wge.getCellSize() * 0.5, true);
        this.m_Edge = this.getTempRasterLayer(0, ge);
        int ID = 1;
        for (int y = 0; y < this.m_iNY && this.setProgress(y, this.m_iNY); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                double dValue = this.m_Input.getCellValueAsDouble(x, y);
                if (this.m_Input.isNoDataValue(dValue) || this.m_Lock[y][x] != '\u0000') continue;
                this.Get_Class(dValue);
                Object[] values = new Object[]{new Integer(ID++), new Double(dValue)};
                GeometryFactory gf = new GeometryFactory();
                this.m_Polygons.addFeature((Geometry)gf.createMultiPolygon(this.m_Polyg.toArray(new Polygon[0])), values);
            }
        }
    }

    private void Get_Class(double dClassValue) {
        this.m_Polyg.clear();
        int nEdgeCells = 0;
        for (int y = 0; y < this.m_iNY && !this.m_Task.isCanceled(); ++y) {
            for (int x = 0; x < this.m_iNX; ++x) {
                double dValue = this.m_Input.getCellValueAsDouble(x, y);
                if (this.m_Lock[y][x] != '\u0000' || dValue != dClassValue) continue;
                this.m_Lock[y][x] = '\u0001';
                int n = 0;
                for (int i = 0; i < 8; i += 2) {
                    int iy;
                    int ix = this.Get_xTo(i, x);
                    dValue = this.m_Input.getCellValueAsDouble(ix, iy = this.Get_yTo(i, y));
                    if (dValue == dClassValue) continue;
                    ix = this.Get_xTo(i, 1 + 2 * x);
                    iy = this.Get_yTo(i, 1 + 2 * y);
                    this.m_Edge.setCellValue(ix, iy, (double)(i + 2));
                    ix = this.Get_xTo(i - 1, 1 + 2 * x);
                    iy = this.Get_yTo(i - 1, 1 + 2 * y);
                    this.m_Edge.setCellValue(ix, iy, this.m_Edge.getCellValueAsInt(ix, iy) != 0 ? -1.0 : (double)(i + 2));
                    ++n;
                }
                if (n == 4) {
                    this.Get_Square(1 + 2 * x, 1 + 2 * y);
                    continue;
                }
                ++nEdgeCells;
            }
        }
        if (nEdgeCells > 0) {
            this.Get_Polygons();
        }
    }

    private void Get_Square(int x, int y) {
        double dCellSize = this.m_Edge.getWindowCellSize() * 0.5;
        for (int i = 0; i < 8; ++i) {
            int iy;
            int ix;
            this.m_Edge.setCellValue(ix, iy, this.m_Edge.getCellValueAsInt(ix = this.Get_xTo(i, x), iy = this.Get_yTo(i, y)) > 0 ? 0.0 : (double)(i > 1 ? i - 1 : i + 7));
            if (i % 2 == 0) continue;
            Point2D pt = this.m_Edge.getWindowGridExtent().getWorldCoordsFromGridCoords(ix, iy);
            this.m_Coords.add(new Coordinate(pt.getX() + dCellSize, pt.getY() - dCellSize));
        }
    }

    private void Get_Polygons() {
        for (int y = 0; y < this.m_Edge.getNY() && !this.m_Task.isCanceled(); ++y) {
            for (int x = 0; x < this.m_Edge.getNX(); ++x) {
                if (this.m_Edge.getCellValueAsInt(x, y) <= 0) continue;
                this.m_Coords.clear();
                this.Get_Polygon(x, y);
                Coordinate coord = this.m_Coords.get(0);
                this.m_Coords.add(new Coordinate(coord.x, coord.y));
                Coordinate[] coords = this.m_Coords.toArray(new Coordinate[0]);
                GeometryFactory gf = new GeometryFactory();
                try {
                    LinearRing ring = gf.createLinearRing(coords);
                    this.m_Polyg.add((Geometry)gf.createPolygon(ring, null));
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void Get_Polygon(int x, int y) {
        int i;
        int iLast = -1;
        double dCellSize = this.m_Edge.getWindowCellSize() * 0.5;
        while ((i = this.m_Edge.getCellValueAsInt(x, y)) != 0) {
            if (i < 0) {
                i = iLast + 2;
                this.m_Edge.setCellValue(x, y, (double)(iLast == 2 ? 8 : iLast - 2));
            } else {
                this.m_Edge.setCellValue(x, y, 0.0);
            }
            if (i != iLast) {
                Point2D pt = this.m_Edge.getWindowGridExtent().getWorldCoordsFromGridCoords(x, y);
                iLast = i;
                this.m_Coords.add(new Coordinate(pt.getX() + dCellSize, pt.getY() - dCellSize));
            }
            x = this.Get_xTo(i, x);
            y = this.Get_yTo(i, y);
        }
    }

    private int Get_xTo(int Direction, int x) {
        if ((Direction %= 8) < 0) {
            Direction += 8;
        }
        return x + m_IX[Direction];
    }

    private int Get_yTo(int Direction, int x) {
        if ((Direction %= 8) < 0) {
            Direction += 8;
        }
        return x + m_IY[Direction];
    }
}

