/*
 * Decompiled with CFR 0.152.
 */
package it.falciano.sextante.polygonize;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.operation.polygonize.Polygonizer;
import com.vividsolutions.jts.precision.EnhancedPrecisionOp;
import es.unex.sextante.core.GeoAlgorithm;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IFeature;
import es.unex.sextante.dataObjects.IFeatureIterator;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.dataObjects.vectorFilters.BoundingBoxFilter;
import es.unex.sextante.dataObjects.vectorFilters.IVectorLayerFilter;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.util.ArrayList;
import java.util.Collection;

public class PolygonizeAlgorithm
extends GeoAlgorithm {
    public static final String LAYER = "LAYER";
    public static final String RESULT = "RESULT";
    private IVectorLayer m_Layer;
    private IVectorLayer m_Output;

    public void defineCharacteristics() {
        this.setName(Sextante.getText((String)"Polygonize"));
        this.setGroup(Sextante.getText((String)"Tools_for_line_layers"));
        this.setUserCanDefineAnalysisExtent(true);
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, Sextante.getText((String)"Polylines"), 1, true);
            this.addOutputVectorLayer(RESULT, Sextante.getText((String)"Polygons"), 2);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        this.m_Layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        if (!this.m_bIsAutoExtent) {
            this.m_Layer.addFilter((IVectorLayerFilter)new BoundingBoxFilter(this.m_AnalysisExtent));
        }
        IFeatureIterator iter = this.m_Layer.iterator();
        int i = 0;
        int k = 0;
        ArrayList<LineString> cLineStrings = new ArrayList<LineString>();
        int errorcount = 0;
        while (iter.hasNext()) {
            IFeature feature = iter.next();
            Geometry geom = feature.getGeometry();
            if (MultiLineString.class.isAssignableFrom(geom.getClass())) {
                MultiLineString mls = (MultiLineString)geom;
                int N = mls.getNumGeometries();
                for (int j = 0; j < N; ++j) {
                    cLineStrings.add((LineString)mls.getGeometryN(j));
                    ++k;
                }
            } else if (geom instanceof LineString) {
                cLineStrings.add((LineString)geom);
            } else if (errorcount < 10) {
                Sextante.addWarningToLog((String)("Polygonize Algorithm require a LineString, found at " + i + " a " + geom.getClass().getName()));
                ++errorcount;
            }
            ++i;
        }
        try {
            GeometryFactory factory = new GeometryFactory();
            GeometryCollection geometryCollection = (GeometryCollection)factory.buildGeometry(cLineStrings);
            Geometry nodedLineStrings = geometryCollection.getGeometryN(0);
            for (int j = 1; j < cLineStrings.size(); ++j) {
                LineString newLineString = (LineString)cLineStrings.get(j);
                nodedLineStrings = EnhancedPrecisionOp.union((Geometry)nodedLineStrings, (Geometry)newLineString);
                this.setProgress(j, cLineStrings.size());
            }
            Polygonizer polygonizer = new Polygonizer();
            polygonizer.add(nodedLineStrings);
            Collection cPolygons = polygonizer.getPolygons();
            Class[] outputFieldTypes = new Class[1];
            String[] outputFieldNames = new String[1];
            outputFieldTypes[0] = Integer.class;
            outputFieldNames[0] = "ID";
            this.m_Output = this.getNewVectorLayer(RESULT, this.m_Layer.getName(), 2, outputFieldTypes, outputFieldNames);
            Polygon[] aPolygons = cPolygons.toArray(new Polygon[cPolygons.size()]);
            Object[] outputValues = new Integer[1];
            for (int k1 = 0; k1 < aPolygons.length; ++k1) {
                outputValues[0] = k1;
                this.m_Output.addFeature(aPolygons[k1].getGeometryN(0), outputValues);
            }
        }
        catch (TopologyException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        return !this.m_Task.isCanceled();
    }
}

