/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.downloader.swing.impl.configController;

import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import org.gvsig.downloader.DownloaderAuthenticationConfig;
import org.gvsig.downloader.DownloaderLocator;
import org.gvsig.downloader.DownloaderManager;
import org.gvsig.downloader.swing.DownloaderConfigController;
import org.gvsig.downloader.swing.DownloaderConfigPanel;
import org.gvsig.downloader.swing.DownloaderConfigServicePanel;
import org.gvsig.downloader.swing.DownloaderSwingLocator;
import org.gvsig.downloader.swing.DownloaderSwingManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;

public class DownloaderConfigControllerImpl
implements DownloaderConfigController {
    private final Supplier<String> serviceUrl;
    private final JButton btnAddService;
    private final JButton btnShowConfig;

    public DownloaderConfigControllerImpl(Supplier<String> serviceUrl, JButton btnAddService, JButton btnShowConfig) {
        this.btnAddService = btnAddService == null ? new JButton() : btnAddService;
        this.btnShowConfig = btnShowConfig == null ? new JButton() : btnShowConfig;
        this.serviceUrl = serviceUrl;
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingUtils.configurePickersButton((AbstractButton)this.btnAddService, (String)"_Add_configuration_for_service_authentication", (String)"downloader-addservice", e -> this.doAddService(), null);
        ToolsSwingUtils.configurePickersButton((AbstractButton)this.btnShowConfig, (String)"_Edit_settings_for_service_authentication", (String)"downloader-admin", e -> this.doShowConfig(), null);
    }

    public void setEnabledAddService(boolean enable) {
        this.btnAddService.setEnabled(enable);
    }

    private void doAddService() {
        WindowManager_v2 winmgr = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        DownloaderManager manager = DownloaderLocator.getDownloaderManager();
        DownloaderSwingManager swingManager = DownloaderSwingLocator.getDownloaderSwingManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        String theServiceUrl = null;
        if (this.serviceUrl != null) {
            theServiceUrl = this.serviceUrl.get();
        }
        DownloaderConfigServicePanel panel = swingManager.createDownloaderConfigServicePanel(theServiceUrl);
        Dialog dialog = winmgr.createDialog(panel.asJComponent(), i18n.getTranslation("_Add_service"), null, 3);
        dialog.addActionListener(e -> {
            if (dialog.getAction() == 1) {
                DownloaderAuthenticationConfig x = panel.fetch();
                manager.registerAuthenticationConfigurationService(x);
            }
        });
        dialog.show(WindowManager.MODE.DIALOG);
    }

    private void doShowConfig() {
        WindowManager_v2 winmgr = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        DownloaderSwingManager manager = DownloaderSwingLocator.getDownloaderSwingManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        DownloaderConfigPanel panel = manager.createDownloaderConfigPanel();
        Dialog dialog = winmgr.createDialog(panel.asJComponent(), i18n.getTranslation("_Download_manager"), null, 1);
        dialog.setButtonLabel(1, i18n.getTranslation("_Close"));
        dialog.addActionListener(e -> dialog.hideDialog());
        dialog.show(WindowManager.MODE.DIALOG);
    }

    public static void selfRegister() {
        ToolsSwingUtils.registerIcons(DownloaderConfigServicePanel.class, (String)"/org/gvsig/downloader/swing/impl/images", (String)"downloader", (String[][])new String[][]{{"downloader", "downloader-admin"}, {"downloader", "downloader-addservice"}});
    }
}

