/*
 * Decompiled with CFR 0.152.
 */
package gishur.awt;

import gishur.awt.SymbolButton;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

public class SymbolImageButton
extends SymbolButton {
    public static final byte SCALE_BITMAP = 8;
    public static final byte PAINT_LABEL = 16;
    public Font font = new Font("SansSerif", 0, 12);
    public Color fontcolor = Color.black;
    public Color fontdiscolor = Color.gray;
    private Image _image = null;
    private Rectangle _img_area;
    private Image _gray_image = null;
    private Rectangle _gray_img_area;

    public void setDisabledImage(Image image, Rectangle rectangle) {
        this._gray_image = image;
        this._gray_img_area = rectangle;
    }

    public void paintEnabled(Graphics graphics, int n) {
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        if (this._image != null && this._img_area != null) {
            Rectangle rectangle = this.getPaintArea(n, this._img_area, !this.testMode((byte)8), fontMetrics);
            graphics.drawImage(this._image, rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1, this._img_area.x, this._img_area.y, this._img_area.x + this._img_area.width - 1, this._img_area.y + this._img_area.height - 1, null);
        }
        if (this.testMode((byte)16)) {
            graphics.setFont(this.font);
            graphics.setColor(this.fontcolor);
            if (this.buttonDown()) {
                graphics.drawString(this.label, 2 + (this.width - 3 - fontMetrics.stringWidth(this.label)) / 2, n - 4);
                return;
            }
            graphics.drawString(this.label, 1 + (this.width - 3 - fontMetrics.stringWidth(this.label)) / 2, n - 5);
        }
    }

    public SymbolImageButton(String string, String string2, Image image, Rectangle rectangle, Image image2, Rectangle rectangle2, boolean bl) {
        this(string, bl);
        this.setImage(image, rectangle, image2, rectangle2);
        this.command = string2;
    }

    public SymbolImageButton(String string, String string2, Image image, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        this(string, bl);
        this.setImage(image, rectangle, image, rectangle2);
        this.command = string2;
    }

    public SymbolImageButton(String string, String string2, Rectangle rectangle, Image image, Image image2, boolean bl) {
        this(string, bl);
        this.setImage(image, rectangle, image2, rectangle);
        this.command = string2;
    }

    public SymbolImageButton(String string, Image image, Rectangle rectangle, Image image2, Rectangle rectangle2, boolean bl) {
        this(string, bl);
        this.setImage(image, rectangle, image2, rectangle2);
        this.command = string;
    }

    public SymbolImageButton(String string, boolean bl) {
        super(string, bl);
        this.width = 24;
        this.preferredHeight = this.testMode((byte)16) ? 40 : this.width;
    }

    public void paintDisabled(Graphics graphics, int n) {
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        if (this._gray_image != null && this._gray_img_area != null) {
            Rectangle rectangle = this.getPaintArea(n, this._gray_img_area, !this.testMode((byte)8), fontMetrics);
            graphics.drawImage(this._gray_image, rectangle.x, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1, this._gray_img_area.x, this._gray_img_area.y, this._gray_img_area.x + this._gray_img_area.width - 1, this._gray_img_area.y + this._gray_img_area.height - 1, null);
        }
        if (this.testMode((byte)16)) {
            graphics.setFont(this.font);
            graphics.setColor(this.fontdiscolor);
            if (this.buttonDown()) {
                graphics.drawString(this.label, 2 + (this.width - 3 - fontMetrics.stringWidth(this.label)) / 2, n - 4);
                return;
            }
            graphics.drawString(this.label, 1 + (this.width - 3 - fontMetrics.stringWidth(this.label)) / 2, n - 5);
        }
    }

    public void setImageArea(Rectangle rectangle, Rectangle rectangle2) {
        this._img_area = rectangle;
        this._gray_img_area = rectangle2;
    }

    public void setGrayArea(Rectangle rectangle) {
        this._gray_img_area = rectangle;
    }

    public void setImage(Image image, Image image2) {
        this._image = image;
        this._gray_image = image2;
    }

    public void setNormalArea(Rectangle rectangle) {
        this._img_area = rectangle;
    }

    public void setImage(Image image, Rectangle rectangle, Image image2, Rectangle rectangle2) {
        this._image = image;
        this._img_area = rectangle;
        this._gray_image = image2;
        this._gray_img_area = rectangle2;
    }

    public void setImage(Image image, Rectangle rectangle) {
        this.setImage(image, rectangle, image, rectangle);
    }

    public void setEnabledImage(Image image, Rectangle rectangle) {
        this._image = image;
        this._img_area = rectangle;
    }

    private Rectangle getPaintArea(int n, Rectangle rectangle, boolean bl, FontMetrics fontMetrics) {
        double d;
        Rectangle rectangle2 = new Rectangle(1, 1, this.width - 3, n - 3);
        if (this.testMode((byte)16)) {
            rectangle2.height -= fontMetrics.getHeight();
        }
        if (!bl) {
            d = (double)rectangle2.width / (double)rectangle.width;
            if (d > (double)rectangle2.height / (double)rectangle.height) {
                d = (double)rectangle2.height / (double)rectangle.height;
            }
        } else {
            d = 1.0;
        }
        int n2 = (int)(d * (double)rectangle.width);
        int n3 = (int)(d * (double)rectangle.height);
        if (n2 < rectangle2.width) {
            rectangle2.x += (rectangle2.width - n2) / 2;
            rectangle2.width = n2;
        }
        if (n3 < rectangle2.height) {
            rectangle2.y += (rectangle2.height - n3) / 2;
            rectangle2.height = n3;
        }
        if (this.buttonDown()) {
            ++rectangle2.x;
            ++rectangle2.y;
        }
        return rectangle2;
    }
}

