/*
 * Decompiled with CFR 0.152.
 */
package gishur.core;

import gishur.core.Cloneable;
import gishur.core.ControlledCloneable;
import gishur.core.ListItem;
import gishur.core.Owner;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class BasicListItem
implements ListItem,
ControlledCloneable,
Serializable {
    private Owner _owningList = null;
    private ListItem _prev = null;
    private ListItem _next = null;

    public synchronized boolean answerConnect(ListItem listItem, boolean bl) {
        if (listItem == null || listItem.getOwningList() != this.getOwningList()) {
            return false;
        }
        if (bl) {
            if (listItem.next() != this) {
                return false;
            }
            this._prev = listItem;
        } else {
            if (listItem.prev() != this) {
                return false;
            }
            this._next = listItem;
        }
        return true;
    }

    public boolean setValue(Object object) {
        return false;
    }

    public String toString() {
        return this.getClass().getName() + "[]";
    }

    public synchronized boolean clearConnections() {
        if (!this.requestListAccess(3, null)) {
            return false;
        }
        this._next = null;
        this._prev = null;
        return true;
    }

    public ListItem findLast() {
        if (this._next == null) {
            return this;
        }
        ListItem listItem = this._next;
        while (listItem.next() != null && listItem.next() != this) {
            listItem = listItem.next();
        }
        return listItem;
    }

    public Object key() {
        return null;
    }

    public synchronized boolean setOwningList(Owner owner) {
        if (owner == this._owningList) {
            return true;
        }
        if (!this.requestListAccess(1, owner)) {
            return false;
        }
        Owner owner2 = this._owningList;
        this._owningList = owner;
        if (!this.requestListAccess(1, owner)) {
            this._owningList = owner2;
            return false;
        }
        return true;
    }

    public Owner getOwningList() {
        return this._owningList;
    }

    public ListItem findFirst() {
        if (this._prev == null) {
            return this;
        }
        ListItem listItem = this._prev;
        while (listItem.prev() != null && listItem.prev() != this) {
            listItem = listItem.prev();
        }
        return listItem;
    }

    public boolean isLast() {
        return this._next == null;
    }

    public Object value() {
        return null;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.key() == object) {
            return true;
        }
        if (object.equals(this.key())) {
            return true;
        }
        if (object instanceof ListItem) {
            ListItem listItem = (ListItem)object;
            if (this.key() == listItem.key()) {
                return true;
            }
            if (this.key() == null || listItem.key() == null) {
                return false;
            }
            return this.key().equals(listItem.key());
        }
        return false;
    }

    public int getIndex(boolean bl) {
        int n = -1;
        ListItem listItem = this;
        while (listItem != null) {
            ++n;
            listItem = bl ? listItem.prev() : listItem.next();
        }
        return n;
    }

    protected boolean requestListAccess(int n, Object object) {
        if (this._owningList == null) {
            return true;
        }
        return this._owningList.requestAccess(n, this, object);
    }

    public ListItem next() {
        return this._next;
    }

    private static final Object cloneObject(Object object, Hashtable hashtable, int n) {
        if (object == null) {
            return null;
        }
        if (hashtable.containsKey(object)) {
            return hashtable.get(object);
        }
        if (!(object instanceof java.lang.Cloneable)) {
            return object;
        }
        if (object instanceof ControlledCloneable) {
            Object object2 = ((ControlledCloneable)object).clone(hashtable, n);
            hashtable.put(object, object2);
            return object2;
        }
        if (object instanceof Cloneable) {
            Object object3 = ((Cloneable)object).clone();
            hashtable.put(object, object3);
            return object3;
        }
        try {
            Method method = object.getClass().getDeclaredMethod("clone", new Class[0]);
            Object object4 = method.invoke(object, new Object[0]);
            hashtable.put(object, object4);
            return object4;
        }
        catch (Exception exception) {
            if (exception instanceof IllegalAccessException) {
                return object;
            }
            throw new InternalError("Error while cloning");
        }
    }

    public boolean isFirst() {
        return this._prev == null;
    }

    public boolean setKey(Object object) {
        return false;
    }

    public Object clone() {
        return this.clone(null, -1);
    }

    public Object clone(Hashtable hashtable, int n) {
        BasicListItem basicListItem;
        if (n == 0) {
            return this;
        }
        if (hashtable == null) {
            hashtable = new Hashtable<BasicListItem, BasicListItem>();
        }
        if (hashtable.containsKey(this)) {
            return hashtable.get(this);
        }
        try {
            basicListItem = (BasicListItem)super.clone();
            hashtable.put(this, basicListItem);
            basicListItem._prev = null;
            basicListItem._next = null;
            basicListItem._owningList = null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Error while cloning");
        }
        if (n == 1) {
            basicListItem.setKey(this.key());
            basicListItem.setValue(this.value());
        } else {
            if (n > 1) {
                --n;
            }
            Object object = this.value();
            Object object2 = this.key();
            boolean bl = object2 != object;
            object2 = BasicListItem.cloneObject(object2, hashtable, n);
            basicListItem.setKey(object2);
            basicListItem.setValue(bl ? BasicListItem.cloneObject(object, hashtable, n) : object2);
        }
        return basicListItem;
    }

    public ListItem prev() {
        return this._prev;
    }

    public ListItem find(Object object) {
        if (this.equals(object)) {
            return this;
        }
        ListItem listItem = this._next;
        while (listItem != null && !listItem.equals(object)) {
            listItem = listItem.next();
        }
        if (listItem != null) {
            return listItem;
        }
        listItem = this._prev;
        while (listItem != null && !listItem.equals(object)) {
            listItem = listItem.prev();
        }
        return listItem;
    }

    public synchronized boolean remove() {
        if (!this.requestListAccess(2, null)) {
            return false;
        }
        if (this._prev != null) {
            this._prev.connect(this._next, true);
        }
        if (this._next != null) {
            this._next.connect(this._prev, false);
        }
        this._next = null;
        this._prev = null;
        this._owningList = null;
        return true;
    }

    public synchronized boolean connect(ListItem listItem, boolean bl) {
        if (listItem != null && listItem.getOwningList() != this.getOwningList()) {
            return false;
        }
        if (bl) {
            if (!this.requestListAccess(4, listItem)) {
                return false;
            }
            ListItem listItem2 = this._next;
            this._next = listItem;
            if (listItem != null && !listItem.answerConnect(this, true)) {
                this._next = listItem2;
                return false;
            }
        } else {
            if (!this.requestListAccess(5, listItem)) {
                return false;
            }
            ListItem listItem3 = this._prev;
            this._prev = listItem;
            if (listItem != null && !listItem.answerConnect(this, false)) {
                this._prev = listItem3;
                return false;
            }
        }
        return true;
    }
}

