/*
 * Decompiled with CFR 0.152.
 */
package gishur.core.math;

import gishur.core.math.MathNumberException;

public abstract class MathNumber
extends Number {
    public static MathNumber ZERO;
    public static MathNumber ONE;
    public static MathNumber MINUS_ONE;

    public abstract int sign();

    public MathNumber log() {
        throw new MathNumberException(1002, this);
    }

    public abstract double doubleValue();

    public int intValue() {
        return (int)this.doubleValue();
    }

    public String toString() {
        return "" + this.doubleValue();
    }

    public abstract MathNumber negate();

    public abstract MathNumber add(MathNumber var1);

    public abstract MathNumber multiply(MathNumber var1);

    public static MathNumber max(MathNumber mathNumber, MathNumber mathNumber2) {
        if (mathNumber == null && mathNumber2 == null) {
            return null;
        }
        if (mathNumber == null) {
            return mathNumber2;
        }
        if (mathNumber2 == null) {
            return mathNumber;
        }
        if (mathNumber.compareTo(mathNumber2) >= 0) {
            return mathNumber;
        }
        return mathNumber2;
    }

    public MathNumber sqrt() {
        throw new MathNumberException(1002, this);
    }

    public MathNumber pow(long l) {
        throw new MathNumberException(1002, this);
    }

    public int compareTo(MathNumber mathNumber) {
        return this.subtract(mathNumber).sign();
    }

    public float floatValue() {
        return (float)this.doubleValue();
    }

    public long longValue() {
        return (long)this.doubleValue();
    }

    static {
        MINUS_ONE = null;
        ONE = null;
        ZERO = null;
    }

    public abstract MathNumber invert();

    public abstract MathNumber abs();

    public static MathNumber min(MathNumber mathNumber, MathNumber mathNumber2) {
        if (mathNumber == null && mathNumber2 == null) {
            return null;
        }
        if (mathNumber == null) {
            return mathNumber2;
        }
        if (mathNumber2 == null) {
            return mathNumber;
        }
        if (mathNumber.compareTo(mathNumber2) <= 0) {
            return mathNumber;
        }
        return mathNumber2;
    }

    public byte byteValue() {
        return (byte)this.doubleValue();
    }

    public short shortValue() {
        return (short)this.doubleValue();
    }

    public abstract MathNumber divide(MathNumber var1);

    public abstract MathNumber subtract(MathNumber var1);
}

