/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.coverage.dataset;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.cresques.cts.ICoordTrans;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.dataset.BufferParam;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.NoData;
import org.gvsig.fmap.dal.coverage.exception.BufferCreationException;
import org.gvsig.fmap.dal.coverage.exception.WarpException;

public abstract class AbstractBuffer
implements Buffer {
    @Override
    public Buffer project(ICoordTrans coordTrans, Extent extent, int width, int height) throws WarpException {
        if (this.getDataExtent() == null) {
            throw new IllegalArgumentException("Soruce buffer has to have data extent to be projected");
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Width or heigth of result buffer can not be 0 or negative");
        }
        Rectangle2D dataExtentRect = this.getDataExtent();
        Extent sourceExtent = RasterLocator.getManager().getDataStructFactory().createExtent(dataExtentRect);
        AffineTransform atSourceBuffer = new AffineTransform(sourceExtent.width() / (double)this.getWidth(), 0.0, 0.0, -sourceExtent.height() / (double)this.getHeight(), sourceExtent.getMin().getX(), sourceExtent.getMax().getY());
        BufferParam bufParam = RasterLocator.getManager().getBufferFactory().createBufferParams(width, height, this.getBandCount(), this.getDataType(), true);
        Buffer bufReprojected = null;
        try {
            bufReprojected = RasterLocator.getManager().getBufferFactory().createBuffer(bufParam);
        }
        catch (BufferCreationException e) {
            String msg = String.format("Can not create buffer. [parameters width %1s height: %2s bands number %3s data type %4s malloc %5s]", this.getWidth(), this.getHeight(), this.getBandCount(), this.getDataType(), true);
            throw new WarpException(msg, (Throwable)((Object)e));
        }
        AffineTransform atReprojectedBuffer = new AffineTransform(extent.width() / (double)width, 0.0, 0.0, -extent.height() / (double)height, extent.getMin().getX(), extent.getMax().getY());
        try {
            NoData noData = this.getNoDataValue();
            if (noData == null) {
                noData = RasterLocator.getManager().getDataStructFactory().createDefaultNoData(this.getBandCount(), this.getDataType());
            }
            for (int row = 0; row < bufReprojected.getHeight(); ++row) {
                for (int col = 0; col < bufReprojected.getWidth(); ++col) {
                    Point2D.Double worldPoint = new Point2D.Double();
                    atReprojectedBuffer.transform(new Point2D.Double(col, row), worldPoint);
                    Point2D reprojectedWorldPoint = worldPoint;
                    if (coordTrans != null) {
                        reprojectedWorldPoint = coordTrans.convert((Point2D)worldPoint, null);
                    }
                    Point2D.Double sourceBufferPoint = new Point2D.Double();
                    atSourceBuffer.inverseTransform(reprojectedWorldPoint, sourceBufferPoint);
                    this.writePixel(bufReprojected.getDataType(), this, bufReprojected, bufReprojected.getBandCount(), sourceBufferPoint, col, row, noData);
                }
            }
        }
        catch (NoninvertibleTransformException e) {
            throw new WarpException(String.format("Can not invert transformation %1s", atSourceBuffer), e);
        }
        return bufReprojected;
    }

    private void writePixel(int type, Buffer sourceBuffer, Buffer buf, int bandCount, Point2D p, int col, int row, NoData nd) {
        if (p.getX() >= 0.0 && p.getX() < (double)sourceBuffer.getWidth() && p.getY() >= 0.0 && p.getY() < (double)sourceBuffer.getHeight()) {
            block14: for (int iBand = 0; iBand < bandCount; ++iBand) {
                switch (type) {
                    case 0: {
                        buf.setElem(row, col, iBand, sourceBuffer.getElemByte((int)p.getY(), (int)p.getX(), iBand));
                        continue block14;
                    }
                    case 2: {
                        buf.setElem(row, col, iBand, sourceBuffer.getElemShort((int)p.getY(), (int)p.getX(), iBand));
                        continue block14;
                    }
                    case 3: {
                        buf.setElem(row, col, iBand, sourceBuffer.getElemInt((int)p.getY(), (int)p.getX(), iBand));
                        continue block14;
                    }
                    case 4: {
                        buf.setElem(row, col, iBand, sourceBuffer.getElemFloat((int)p.getY(), (int)p.getX(), iBand));
                        continue block14;
                    }
                    case 5: {
                        buf.setElem(row, col, iBand, sourceBuffer.getElemDouble((int)p.getY(), (int)p.getX(), iBand));
                    }
                }
            }
        } else {
            block15: for (int iBand = 0; iBand < bandCount; ++iBand) {
                switch (type) {
                    case 0: {
                        buf.setElem(row, col, iBand, nd.getValue().byteValue());
                        continue block15;
                    }
                    case 2: {
                        buf.setElem(row, col, iBand, nd.getValue().shortValue());
                        continue block15;
                    }
                    case 3: {
                        buf.setElem(row, col, iBand, nd.getValue().intValue());
                        continue block15;
                    }
                    case 4: {
                        buf.setElem(row, col, iBand, nd.getValue().floatValue());
                        continue block15;
                    }
                    case 5: {
                        buf.setElem(row, col, iBand, nd.getValue().doubleValue());
                    }
                }
            }
        }
    }
}

