/*
 * Decompiled with CFR 0.152.
 */
package es.unex.sextante.math.regression;

import Jama.Matrix;
import es.unex.sextante.math.regression.Regression;
import java.util.ArrayList;

public class MultipleRegression {
    private final ArrayList m_Y = new ArrayList();
    private final ArrayList[] m_X;
    private final double[] m_dDCoeff;
    private final double[] m_dRCoeff;
    private final int[] m_iOrder;

    public MultipleRegression(int iVariables) {
        this.m_X = new ArrayList[iVariables];
        for (int i = 0; i < this.m_X.length; ++i) {
            this.m_X[i] = new ArrayList();
        }
        this.m_dRCoeff = new double[iVariables + 1];
        this.m_dDCoeff = new double[iVariables + 1];
        this.m_iOrder = new int[iVariables + 1];
    }

    public void addValue(double[] dX, double dY) {
        if (dX.length == this.m_X.length) {
            this.m_Y.add(new Double(dY));
            for (int i = 0; i < dX.length; ++i) {
                this.m_X[i].add(new Double(dX[i]));
            }
        }
    }

    public boolean calculate() {
        if (this.m_Y.size() > this.m_iOrder.length - 1 && this.m_iOrder.length > 0) {
            this.getRegression();
            this.getCorrelation();
            return true;
        }
        return false;
    }

    private boolean eliminate(double[] X, double[] Y) {
        Regression regression = new Regression();
        if (regression.calculate(X, Y)) {
            for (int i = 0; i < Y.length; ++i) {
                int n = i;
                Y[n] = Y[n] - (regression.getConstant() + regression.getCoeff() * X[i]);
            }
            return true;
        }
        return false;
    }

    public double getCoeff(int iVariable) {
        if (++iVariable > 0 && iVariable < this.m_dDCoeff.length) {
            return this.m_dRCoeff[iVariable];
        }
        return 0.0;
    }

    public double getConstant() {
        if (this.m_dRCoeff.length > 1) {
            return this.m_dRCoeff[0];
        }
        return 0.0;
    }

    boolean getCorrelation() {
        MaxValues maxValues = new MaxValues();
        int nVariables = this.m_iOrder.length;
        int nValues = this.m_Y.size();
        if (nValues >= nVariables && nVariables > 1) {
            int i;
            int k;
            double[][] Values = new double[nVariables][nValues];
            for (k = 0; k < nValues; ++k) {
                Values[0][k] = (Double)this.m_Y.get(k);
            }
            for (i = 1; i < nVariables; ++i) {
                for (k = 0; k < nValues; ++k) {
                    Values[i][k] = (Double)this.m_X[i - 1].get(k);
                }
            }
            this.m_iOrder[0] = -1;
            this.m_dDCoeff[0] = -1.0;
            i = 0;
            double r2_sum = 0.0;
            while (i < nVariables - 1) {
                this.getCorrelation(Values, Values[0], maxValues);
                r2_sum += (1.0 - r2_sum) * maxValues.dRMax;
                this.m_iOrder[maxValues.iMax] = i++;
                this.m_dDCoeff[maxValues.iMax] = r2_sum;
            }
            return true;
        }
        return false;
    }

    boolean getCorrelation(double[][] X, double[] Y, MaxValues maxValues) {
        int i;
        Regression regression = new Regression();
        int n = 0;
        maxValues.iMax = -1;
        maxValues.dRMax = 0.0;
        for (i = 1; i < X.length; ++i) {
            if (X[i] == null || !regression.calculate(X[i], Y)) continue;
            ++n;
            if (maxValues.iMax >= 0 && !(maxValues.dRMax < regression.getR2())) continue;
            maxValues.iMax = i;
            maxValues.dRMax = regression.getR2();
        }
        if (n > 1) {
            double[] XMax = X[maxValues.iMax];
            X[maxValues.iMax] = null;
            for (i = 0; i < X.length; ++i) {
                if (X[i] == null) continue;
                this.eliminate(XMax, X[i]);
            }
            this.eliminate(XMax, Y);
        }
        return maxValues.iMax >= 1;
    }

    public int getOrder(int iVariable) {
        if (++iVariable > 0 && iVariable < this.m_iOrder.length) {
            return this.m_iOrder[iVariable];
        }
        return -1;
    }

    public int getOrdered(int iOrder) {
        for (int i = 0; i < this.m_iOrder.length; ++i) {
            if (iOrder != this.m_iOrder[i]) continue;
            return i - 1;
        }
        return -1;
    }

    public double getR2(int iVariable) {
        if (++iVariable > 0 && iVariable < this.m_dDCoeff.length) {
            return this.m_dDCoeff[iVariable];
        }
        return 0.0;
    }

    public double getR2Change(int iVariable) {
        int iOrder = this.getOrder(iVariable);
        if (iOrder > 0) {
            return this.getR2(iVariable) - this.getR2(this.getOrdered(iOrder - 1));
        }
        if (iOrder == 0) {
            return this.getR2(iVariable);
        }
        return 0.0;
    }

    private boolean getRegression() {
        Matrix inverse;
        int j;
        double sum;
        int i;
        int k;
        int nVariables = this.m_iOrder.length;
        int nValues = this.m_Y.size();
        double[] B = new double[nVariables];
        double[][] P = new double[nVariables][nVariables];
        double[] Y = new double[nValues];
        double[][] X = new double[nVariables][nValues];
        for (k = 0; k < nValues; ++k) {
            Y[k] = (Double)this.m_Y.get(k);
            X[0][k] = 1.0;
        }
        for (i = 1; i < nVariables; ++i) {
            for (k = 0; k < nValues; ++k) {
                X[i][k] = (Double)this.m_X[i - 1].get(k);
            }
        }
        for (i = 0; i < nVariables; ++i) {
            sum = 0.0;
            for (k = 0; k < nValues; ++k) {
                sum += X[i][k] * Y[k];
            }
            B[i] = sum;
            for (j = 0; j < nVariables; ++j) {
                sum = 0.0;
                for (k = 0; k < nValues; ++k) {
                    sum += X[i][k] * X[j][k];
                }
                P[i][j] = sum;
            }
        }
        Matrix m = new Matrix(P);
        try {
            inverse = m.inverse();
        }
        catch (Exception e) {
            return false;
        }
        for (i = 0; i < nVariables; ++i) {
            sum = 0.0;
            for (j = 0; j < nVariables; ++j) {
                sum += inverse.get(i, j) * B[j];
            }
            this.m_dRCoeff[i] = sum;
        }
        return true;
    }

    private class MaxValues {
        public int iMax;
        public double dRMax;

        private MaxValues() {
        }
    }
}

