/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.border.Border;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.color.ColorSchemeEnum;

public class SubstanceBorder
implements Border {
    public static Insets INSETS = new Insets(2, 2, 2, 2);
    private static Map<String, BufferedImage> borders = new HashMap<String, BufferedImage>();

    static synchronized void reset() {
        borders.clear();
    }

    private static synchronized BufferedImage getBorder(Component c, int width, int height, boolean isEnabled, boolean hasFocus, boolean isRound) {
        String key = width + ":" + height + ":" + isEnabled + ":" + hasFocus + ":" + isRound + ":" + c.getClass().getName();
        if (!borders.containsKey(key)) {
            HashSet<SubstanceImageCreator.Corner> corners = new HashSet<SubstanceImageCreator.Corner>();
            if (isRound) {
                corners.add(SubstanceImageCreator.Corner.TOP_LEFT);
                corners.add(SubstanceImageCreator.Corner.TOP_RIGHT);
            }
            BufferedImage newBorder = isEnabled ? SubstanceImageCreator.getBorder(width, height, SubstanceLookAndFeel.getColorScheme(), corners, false) : SubstanceImageCreator.getBorder(width, height, ColorSchemeEnum.LIGHT_GRAY, corners, false);
            borders.put(key, newBorder);
        }
        return borders.get(key);
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        boolean isRound = false;
        if (c instanceof JComboBox) {
            isRound = true;
        }
        BufferedImage border = SubstanceBorder.getBorder(c, width, height, c.isEnabled(), c.hasFocus(), isRound);
        g.drawImage(border, x, y, null);
    }

    public Insets getBorderInsets(Component c) {
        return INSETS;
    }

    public boolean isBorderOpaque() {
        return false;
    }
}

