/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl.creation.wizard;

import java.io.File;
import javax.swing.JPanel;
import org.gvsig.gui.beans.wizard.panel.OptionPanel;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.lib.api.creation.MakePluginPackageService;
import org.gvsig.installer.lib.api.creation.MakePluginPackageServiceException;
import org.gvsig.installer.swing.api.SwingInstallerLocator;
import org.gvsig.installer.swing.impl.DefaultSwingInstallerManager;
import org.gvsig.installer.swing.impl.creation.DefaultMakePluginPackageWizard;
import org.gvsig.installer.swing.impl.panel.DefaultProgressPanel;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;

public class ProgressWizard
extends DefaultProgressPanel
implements OptionPanel {
    private static final long serialVersionUID = -2940454513497249659L;
    private DefaultMakePluginPackageWizard installerCreationWizard;
    private DefaultSwingInstallerManager swingInstallerManager;

    public ProgressWizard(DefaultMakePluginPackageWizard installerCreationWizard) {
        this.installerCreationWizard = installerCreationWizard;
        this.swingInstallerManager = (DefaultSwingInstallerManager)SwingInstallerLocator.getSwingInstallerManager();
    }

    public JPanel getJPanel() {
        return this;
    }

    public String getPanelTitle() {
        return this.swingInstallerManager.getText("_installer_progress");
    }

    public void lastPanel() {
        this.installerCreationWizard.setFinishButtonEnabled(false);
        this.installerCreationWizard.setCancelButtonEnabled(true);
    }

    public void nextPanel() {
    }

    public void updatePanel() {
        MakePluginPackageService installerCreationService = this.installerCreationWizard.getInstallerCreationService();
        PackageInfo selectedPackageInfo = this.installerCreationWizard.getSelectedPackageInfo();
        File originalPackageFolder = this.installerCreationWizard.getOriginalPluginFolder();
        SimpleTaskStatus taskStatus = ToolsLocator.getTaskStatusManager().createDefaultSimpleTaskStatus(selectedPackageInfo.getName());
        this.bind((TaskStatus)taskStatus);
        try {
            taskStatus.message(this.swingInstallerManager.getText("_Compressing"));
            installerCreationService.preparePackage(selectedPackageInfo, originalPackageFolder);
            installerCreationService.createPackage(selectedPackageInfo, this.installerCreationWizard.getOutputStream());
            if (this.installerCreationWizard.getIndexOutputStream() != null) {
                taskStatus.message(this.swingInstallerManager.getText("_Creating_index"));
                PackageInfo info = this.installerCreationWizard.getSelectedPackageInfo();
                File pluginFolder = this.installerCreationWizard.getMakePluginPackageService().getPluginFolder(info);
                PackageInfo infoIndex = (PackageInfo)info.clone();
                infoIndex.setDownloadURL(this.installerCreationWizard.getDownloadURL());
                installerCreationService.writePackageInfoForIndex(infoIndex, pluginFolder);
                installerCreationService.createPackageIndex(info, this.installerCreationWizard.getIndexOutputStream());
            }
            taskStatus.terminate();
            taskStatus.message(this.swingInstallerManager.getText("_Finished"));
        }
        catch (MakePluginPackageServiceException e) {
            this.showErrorMessage(this.swingInstallerManager.getText("_Cant_create_package"), e);
        }
        catch (CloneNotSupportedException e) {
            this.showErrorMessage(this.swingInstallerManager.getText("_Cant_create_package"), e);
        }
        this.installerCreationWizard.setFinishButtonEnabled(true);
        this.installerCreationWizard.setCancelButtonEnabled(false);
    }
}

