/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wcs.app.wcsclient.gui.toc;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.geom.Point2D;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.Events.PointEvent;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.gvsig.raster.wcs.app.wcsclient.layer.FLyrWCS;

public class WCSZoomPixelCursorListener
implements PointListener {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private final Image img = IconThemeHelper.getImageIcon((String)"view-previsualize-area").getImage();
    private Cursor cur = Toolkit.getDefaultToolkit().createCustomCursor(this.img, new Point(16, 16), "");
    private MapControl mapCtrl;

    public WCSZoomPixelCursorListener(MapControl mc) {
        this.mapCtrl = mc;
    }

    public void point(PointEvent event) throws BehaviorException {
        Point2D pReal = this.mapCtrl.getMapContext().getViewPort().toMapPoint(event.getPoint());
        ViewPort v = this.mapCtrl.getMapContext().getViewPort();
        FLayer[] actives = this.mapCtrl.getMapContext().getLayers().getActives();
        Envelope ext = null;
        try {
            ext = actives[0].getFullEnvelope();
        }
        catch (ReadException e) {
            throw new BehaviorException(e.getMessage());
        }
        if (ext != null) {
            Envelope rect;
            double w2 = (double)v.getImageWidth() / 2.0;
            double h2 = (double)v.getImageHeight() / 2.0;
            double wcOriginX = pReal.getX();
            double wcOriginY = pReal.getY();
            Point2D maxRes = ((FLyrWCS)actives[0]).getMaxResolution();
            double wcDstMinX = wcOriginX - w2 * maxRes.getX();
            double wcDstMinY = wcOriginY - h2 * maxRes.getY();
            double wcDstWidth = w2 * maxRes.getX() * 2.0;
            double wcDstHeight = h2 * maxRes.getY() * 2.0;
            try {
                rect = geomManager.createEnvelope(wcDstMinX, wcDstMinY, wcDstMinX + wcDstWidth, wcDstMinY - wcDstHeight, 0);
            }
            catch (CreateEnvelopeException e) {
                throw new BehaviorException(e.getMessage());
            }
            this.mapCtrl.getMapContext().getViewPort().setEnvelope(rect);
        }
    }

    public Cursor getCursor() {
        return this.cur;
    }

    public boolean cancelDrawing() {
        return false;
    }

    public void pointDoubleClick(PointEvent event) throws BehaviorException {
    }

    public Image getImageCursor() {
        return this.img;
    }
}

