/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wcs.app.wcsclient.gui.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.commons.io.IOUtils;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.persistence.serverData.ServerDataPersistence;
import org.gvsig.app.gui.WizardPanel;
import org.gvsig.app.gui.wizards.WizardListener;
import org.gvsig.app.gui.wizards.WizardListenerSupport;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.exception.ConnectException;
import org.gvsig.fmap.dal.coverage.exception.RemoteServiceException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.mapcontext.exceptions.ProjectionLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.gui.beans.Messages;
import org.gvsig.raster.cache.tile.TileCacheLibrary;
import org.gvsig.raster.util.CancelTaskImpl;
import org.gvsig.raster.wcs.app.wcsclient.WCSClientExtension;
import org.gvsig.raster.wcs.app.wcsclient.gui.panel.WCSParamsPanel;
import org.gvsig.raster.wcs.io.WCSProvider;
import org.gvsig.raster.wcs.io.WCSServerExplorer;
import org.gvsig.raster.wcs.io.WCSServerExplorerParameters;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.utils.swing.jcomboServer.JComboServer;
import org.gvsig.utils.swing.jcomboServer.ServerData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WCSWizard
extends WizardPanel
implements ActionListener {
    private static final Logger logger = LoggerFactory.getLogger(WCSWizard.class);
    private static final long serialVersionUID = 1L;
    private String serversPropsFilename = "servers.properties";
    protected int page = 0;
    protected boolean connected = false;
    private JComboServer cmbHost = null;
    private JButton btnConnect = null;
    private JButton btnCancel = null;
    private JPanel jPanel = null;
    private JLabel jLabel1 = null;
    private JLabel lblTitle = null;
    private JScrollPane jScrollPane = null;
    private JTextArea txtAbstract = null;
    private JPanel panelPage1 = null;
    private JButton btnSiguiente = null;
    private JButton btnAnterior = null;
    private JPanel jPanel1 = null;
    protected WizardListenerSupport listenerSupport = new WizardListenerSupport();
    protected WCSParamsPanel wcsParamsPanel = null;
    protected JLabel lblServerType = null;
    protected JLabel lblServerTypeValue = null;
    private JCheckBox chkCaching = null;
    private static Preferences fPrefs = Preferences.userRoot().node("gvsig.wcs-wizard");
    private boolean usingTileCache = fPrefs.getBoolean("tile_cache", false);
    private JCheckBox chkTileCache = null;
    private boolean refreshing = fPrefs.getBoolean("refresh_capabilities", false);
    protected int firstPage = 0;
    private JPanel pnlName = null;
    private ICancellable cancel = null;
    private WCSServerExplorer explorer = null;
    private PluginServices plugin = null;

    public WCSWizard(WCSParamsPanel params) {
        this.page = this.firstPage = 1;
        this.wcsParamsPanel = params;
        this.explorer = this.wcsParamsPanel.getExplorer();
        this.setTabName("WCS");
        this.lblServerType = new JLabel();
        this.lblServerType.setBounds(20, 444, 100, 20);
        this.lblServerType.setHorizontalAlignment(4);
        this.lblServerType.setHorizontalTextPosition(4);
        this.lblServerType.setFont(new Font("Arial", 0, 11));
        this.lblServerType.setText(PluginServices.getText((Object)this, (String)"server_type") + ":");
        this.lblServerTypeValue = new JLabel();
        this.lblServerTypeValue.setBounds(128, 444, 148, 20);
        this.lblServerTypeValue.setFont(new Font("Arial", 1, 11));
        this.lblServerTypeValue.setText("-");
        this.setSize(510, 468);
        this.setLayout(null);
        this.setPreferredSize(new Dimension(750, 420));
        this.setVisible(true);
        this.wcsParamsPanel.setListenerSupport(this.listenerSupport);
        this.wcsParamsPanel.setBounds(0, 5, 510, 428);
        this.wcsParamsPanel.getJTabbedPane().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                WCSWizard.this.page = WCSWizard.this.wcsParamsPanel.currentPage() + 1;
                WCSWizard.this.activarVisualizarBotones();
            }
        });
        this.add((Component)((Object)this.wcsParamsPanel), null);
        this.add(this.lblServerType, null);
        this.add(this.lblServerTypeValue, null);
        this.getWCSParamsPanel().setVisible(true);
        this.connected = true;
    }

    public WCSWizard() {
        this.page = this.firstPage = 0;
        this.initialize();
        this.cancel = new CancelTaskImpl();
    }

    private void initialize() {
        PluginsManager pluginsManager = PluginsLocator.getManager();
        this.plugin = pluginsManager.getPlugin(WCSClientExtension.class);
        this.setTabName("WCS");
        this.lblServerType = new JLabel();
        this.lblServerType.setBounds(20, 444, 100, 20);
        this.lblServerType.setHorizontalAlignment(4);
        this.lblServerType.setHorizontalTextPosition(4);
        this.lblServerType.setFont(new Font("Arial", 0, 11));
        this.lblServerType.setText(PluginServices.getText((Object)this, (String)"server_type") + ":");
        this.lblServerTypeValue = new JLabel();
        this.lblServerTypeValue.setBounds(128, 444, 148, 20);
        this.lblServerTypeValue.setFont(new Font("Arial", 1, 11));
        this.lblServerTypeValue.setText("-");
        this.setSize(510, 468);
        this.setLayout(null);
        this.setPreferredSize(new Dimension(750, 420));
        this.setVisible(true);
        this.add(this.getPanelPage1(), null);
        this.add(this.getWCSParamsPanel(), null);
        this.add(this.getBtnAnterior(), null);
        this.add(this.getBtnSiguiente(), null);
        this.add(this.lblServerType, null);
        this.add(this.lblServerTypeValue, null);
        this.activarVisualizarBotones();
    }

    protected JPanel getWCSParamsPanel() {
        if (this.wcsParamsPanel == null) {
            this.wcsParamsPanel = new WCSParamsPanel();
            this.wcsParamsPanel.setListenerSupport(this.listenerSupport);
            this.wcsParamsPanel.setBounds(0, 5, 510, 428);
            this.wcsParamsPanel.getJTabbedPane().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    WCSWizard.this.page = WCSWizard.this.wcsParamsPanel.currentPage() + 1;
                    WCSWizard.this.activarVisualizarBotones();
                }
            });
        }
        return this.wcsParamsPanel;
    }

    public boolean areSettingsValid() {
        return this.wcsParamsPanel.isCorrectlyConfigured();
    }

    private boolean checkHostAndNetwork() {
        if (!this.explorer.isHostReachable()) {
            JOptionPane.showMessageDialog(null, Messages.getText((String)"host_unreachable"), Messages.getText((String)"Error"), 0);
            logger.info(Messages.getText((String)"host_unreachable"));
            return false;
        }
        return true;
    }

    private void rellenarControles() {
        try {
            this.lblTitle.setText(this.explorer.getTitle());
            this.lblServerTypeValue.setText(this.explorer.getServerType());
            this.txtAbstract.setText(this.explorer.getAbstract());
            this.wcsParamsPanel.setWizardData(this.explorer);
            this.connected = true;
            this.activarVisualizarBotones();
        }
        catch (Exception e) {
            if (e.getMessage() == null) {
                this.txtAbstract.setText(PluginServices.getText((Object)this, (String)"error"));
            } else {
                this.txtAbstract.setText(e.getMessage());
            }
            this.listenerSupport.callError(e);
            this.getBtnSiguiente().setEnabled(false);
            this.getBtnAnterior().setEnabled(true);
        }
        finally {
            this.getBtnCancel().setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getBtnConnect()) {
            this.getBtnCancel().setEnabled(true);
            this.getTxtAbstract().setText("Trying to connect...");
            String host = this.cmbHost.getModel().getSelectedItem().toString();
            try {
                DataManager datamanager = DALLocator.getDataManager();
                WCSServerExplorerParameters explorerParams = (WCSServerExplorerParameters)datamanager.createServerExplorerParameters(WCSProvider.NAME);
                explorerParams.setHost(host);
                this.explorer = (WCSServerExplorer)datamanager.createServerExplorer((DataServerExplorerParameters)explorerParams);
                ((CancelTaskImpl)this.cancel).setCanceled(false);
                new ConnectThread(this.cancel, this.explorer, this).start();
            }
            catch (InitializeException e1) {
                this.getTxtAbstract().setText("Error creating WCS layer");
            }
            catch (ProviderNotRegisteredException e1) {
                this.getTxtAbstract().setText("Provider not registered. I cannot connect.");
            }
            catch (ValidateDataParametersException e1) {
                this.getTxtAbstract().setText("Parameters not valid. I cannot connect.");
            }
        }
        if (e.getSource() == this.getBtnCancel()) {
            this.getTxtAbstract().setText("Cancelled...");
            ((CancelTaskImpl)this.cancel).setCanceled(true);
            this.getBtnCancel().setEnabled(false);
        }
    }

    protected void activarVisualizarBotones() {
        if (this.page == this.firstPage) {
            this.getBtnAnterior().setEnabled(false);
            this.getBtnSiguiente().setVisible(true);
            if (this.connected) {
                this.getBtnSiguiente().setEnabled(true);
            } else {
                this.getBtnSiguiente().setEnabled(false);
            }
        } else if (this.page < this.wcsParamsPanel.getNumTabs()) {
            this.getBtnSiguiente().setEnabled(true);
            this.getBtnSiguiente().setVisible(true);
            this.getBtnAnterior().setEnabled(true);
            this.getBtnAnterior().setVisible(true);
            if (this.wcsParamsPanel.nextEnabledPage() == -1) {
                this.getBtnSiguiente().setEnabled(false);
            }
            this.listenerSupport.callStateChanged(this.wcsParamsPanel.isCorrectlyConfigured());
        } else if (this.page == this.wcsParamsPanel.getNumTabs()) {
            this.getBtnSiguiente().setVisible(false);
            this.getBtnSiguiente().setEnabled(false);
            this.listenerSupport.callStateChanged(this.wcsParamsPanel.isCorrectlyConfigured());
        }
    }

    private JComboBox getTxtHost() {
        if (this.cmbHost == null) {
            this.cmbHost = new JComboServer();
            this.cmbHost.setModel(new DefaultComboBoxModel());
            this.cmbHost.setPreferredSize(new Dimension(350, 20));
            this.cmbHost.setBounds(11, 26, 454, 20);
            this.cmbHost.setEditable(true);
            this.cmbHost.setServerList(this.getServerDataPersistence().getArrayOfServerData());
        }
        return this.cmbHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ServerDataPersistence getServerDataPersistence() {
        ServerDataPersistence servers;
        block8: {
            DynObject pluginProperties = this.plugin.getPluginProperties();
            servers = (ServerDataPersistence)pluginProperties.getDynValue("servers");
            if (servers != null && !servers.isEmpty()) break block8;
            if (servers == null) {
                servers = new ServerDataPersistence("WCS");
                pluginProperties.setDynValue("servers", (Object)servers);
            }
            Properties prop = new Properties();
            File propFile = new File(this.plugin.getPluginDirectory(), this.serversPropsFilename);
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(propFile);
                prop.load(fis);
            }
            catch (FileNotFoundException e) {
                logger.info("Properties file '" + propFile.getAbsolutePath() + "' not found", (Throwable)e);
                IOUtils.closeQuietly((InputStream)fis);
            }
            catch (IOException e2) {
                logger.info("Error reading properties file '" + propFile.getAbsolutePath() + "'.", (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fis);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)fis);
            }
            IOUtils.closeQuietly((InputStream)fis);
            for (int i = 0; i < prop.size(); ++i) {
                Object value = prop.get("server[" + i + "]");
                servers.addServerData(new ServerData(value.toString(), "WCS"));
            }
        }
        return servers;
    }

    private void saveServerListFromComboBox() {
        ServerDataPersistence persistence = this.getServerDataPersistence();
        String urlSelected = this.getTxtHost().getModel().getSelectedItem().toString();
        boolean isSelectedInModel = false;
        for (int i = 0; i < this.getTxtHost().getItemCount(); ++i) {
            String url = this.getTxtHost().getItemAt(i).toString();
            persistence.addServerData(new ServerData(url, "WCS"));
            if (!url.equals(urlSelected)) continue;
            isSelectedInModel = true;
        }
        if (!isSelectedInModel) {
            persistence.addServerData(new ServerData(urlSelected, "WCS"));
        }
    }

    private JButton getBtnConnect() {
        if (this.btnConnect == null) {
            this.btnConnect = new JButton();
            this.btnConnect.setPreferredSize(new Dimension(100, 20));
            this.btnConnect.setBounds(262, 50, 100, 20);
            this.btnConnect.setText(PluginServices.getText((Object)this, (String)"conectar"));
            this.btnConnect.addActionListener(this);
        }
        return this.btnConnect;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setEnabled(false);
            this.btnCancel.setPreferredSize(new Dimension(100, 20));
            this.btnCancel.setBounds(366, 50, 100, 20);
            this.btnCancel.setText(PluginServices.getText((Object)this, (String)"cancel"));
            this.btnCancel.addActionListener(this);
        }
        return this.btnCancel;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(null);
            this.jPanel.setPreferredSize(new Dimension(470, 130));
            this.jPanel.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"description"), 0, 0, null, null));
            this.jPanel.setBounds(2, 116, 477, 304);
            this.jPanel.add((Component)this.getJScrollPane(), null);
            this.jPanel.add((Component)this.getPnlName(), null);
        }
        return this.jPanel;
    }

    private JLabel getJLabel1() {
        if (this.jLabel1 == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setText(PluginServices.getText((Object)this, (String)"name") + ":");
        }
        return this.jLabel1;
    }

    private JLabel getLblTitle() {
        if (this.lblTitle == null) {
            this.lblTitle = new JLabel();
            this.lblTitle.setText("-");
        }
        return this.lblTitle;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getTxtAbstract());
            this.jScrollPane.setPreferredSize(new Dimension(450, 60));
            this.jScrollPane.setBounds(10, 47, 457, 247);
        }
        return this.jScrollPane;
    }

    private JTextArea getTxtAbstract() {
        if (this.txtAbstract == null) {
            this.txtAbstract = new JTextArea();
            this.txtAbstract.setWrapStyleWord(true);
            this.txtAbstract.setColumns(30);
            this.txtAbstract.setLineWrap(true);
        }
        return this.txtAbstract;
    }

    private JPanel getPanelPage1() {
        if (this.panelPage1 == null) {
            this.panelPage1 = new JPanel();
            this.panelPage1.setLayout(null);
            this.panelPage1.setPreferredSize(new Dimension(480, 220));
            this.panelPage1.setVisible(true);
            this.panelPage1.setBounds(15, 5, 480, 427);
            this.panelPage1.add((Component)this.getJPanel1(), null);
            this.panelPage1.add((Component)this.getJPanel(), null);
        }
        return this.panelPage1;
    }

    private JButton getBtnSiguiente() {
        if (this.btnSiguiente == null) {
            this.btnSiguiente = new JButton();
            this.btnSiguiente.setPreferredSize(new Dimension(100, 30));
            this.btnSiguiente.setBounds(395, 444, 100, 20);
            this.btnSiguiente.setText(PluginServices.getText((Object)this, (String)"siguiente"));
            this.btnSiguiente.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (WCSWizard.this.page == WCSWizard.this.firstPage && WCSWizard.this.getChkTileCache().isSelected()) {
                        WCSWizard.messageBoxInfo("remote_service_tiled", TileCacheLibrary.ALTERNATIVE_TILESIZE + "", this);
                    }
                    if (WCSWizard.this.page > WCSWizard.this.firstPage) {
                        WCSWizard.this.wcsParamsPanel.avanzaTab();
                        WCSWizard.this.page = WCSWizard.this.wcsParamsPanel.currentPage();
                    }
                    ++WCSWizard.this.page;
                    WCSWizard.this.getPanelPage1().setVisible(false);
                    WCSWizard.this.getWCSParamsPanel().setVisible(true);
                    WCSWizard.this.activarVisualizarBotones();
                }
            });
        }
        return this.btnSiguiente;
    }

    public static void messageBoxInfo(String msg, String fixedText, Object parentWindow) {
        String string = PluginServices.getText((Object)parentWindow, (String)"accept");
        Object[] options = new Object[]{string};
        JOptionPane.showOptionDialog((Component)PluginServices.getMainFrame(), "<html>" + PluginServices.getText((Object)parentWindow, (String)msg).replaceAll("\n", "<br>") + " " + fixedText + "</html>", PluginServices.getText((Object)parentWindow, (String)"confirmacion"), 0, 1, null, options, string);
    }

    private JButton getBtnAnterior() {
        if (this.btnAnterior == null) {
            this.btnAnterior = new JButton();
            this.btnAnterior.setBounds(292, 444, 100, 20);
            this.btnAnterior.setPreferredSize(new Dimension(100, 30));
            this.btnAnterior.setText(PluginServices.getText((Object)this, (String)"anterior"));
            this.btnAnterior.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    --WCSWizard.this.page;
                    if (WCSWizard.this.page > WCSWizard.this.firstPage) {
                        WCSWizard.this.wcsParamsPanel.retrocedeTab();
                        WCSWizard.this.page = WCSWizard.this.wcsParamsPanel.currentPage() + 1;
                        WCSWizard.this.activarVisualizarBotones();
                    } else if (WCSWizard.this.page == WCSWizard.this.firstPage) {
                        WCSWizard.this.activarVisualizarBotones();
                        WCSWizard.this.page = WCSWizard.this.firstPage + 1;
                        WCSWizard.this.getLblTitle().setText("-");
                        WCSWizard.this.getTxtAbstract().setText("");
                        WCSWizard.this.wcsParamsPanel.retrocedeTab();
                        WCSWizard.this.getPanelPage1().setVisible(true);
                        WCSWizard.this.getWCSParamsPanel().setVisible(false);
                        WCSWizard.this.getBtnSiguiente().setEnabled(false);
                        WCSWizard.this.connected = false;
                    }
                    WCSWizard.this.listenerSupport.callStateChanged(WCSWizard.this.wcsParamsPanel.isCorrectlyConfigured());
                }
            });
        }
        return this.btnAnterior;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(null);
            this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"server"), 0, 0, null, null));
            this.jPanel1.setBounds(2, 5, 477, 105);
            this.jPanel1.add((Component)this.getTxtHost(), null);
            this.jPanel1.add((Component)this.getBtnConnect(), null);
            this.jPanel1.add((Component)this.getBtnCancel(), null);
            this.jPanel1.add((Component)this.getChkCaching(), null);
            this.jPanel1.add((Component)this.getChkTileCache(), null);
        }
        return this.jPanel1;
    }

    public void addWizardListener(WizardListener listener) {
        this.listenerSupport.addWizardListener(listener);
    }

    public void removeWizardListener(WizardListener listener) {
        this.listenerSupport.removeWizardListener(listener);
    }

    public Rectangle2D getLayersRectangle() throws ProjectionLayerException {
        return null;
    }

    public URL getHost() {
        try {
            if (this.cmbHost == null || this.cmbHost.getModel().getSelectedItem() == null) {
                return new URL(this.explorer.getHost());
            }
            return new URL(this.cmbHost.getModel().getSelectedItem().toString());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public String getLayerName() {
        return this.wcsParamsPanel.getLayerName();
    }

    public void initWizard() {
    }

    public void execute() {
        try {
            FLayer layer = this.wcsParamsPanel.getLayer(this.getChkTileCache().isSelected());
            if (layer == null) {
                return;
            }
            this.getMapCtrl().getMapContext().getLayers().addLayer(layer);
        }
        catch (InitializeException e) {
            logger.info("The layer cannot be added", (Throwable)e);
        }
    }

    private JCheckBox getChkCaching() {
        if (this.chkCaching == null) {
            this.chkCaching = new JCheckBox();
            this.chkCaching.setBounds(7, 51, 249, 20);
            this.chkCaching.setText(PluginServices.getText((Object)this, (String)"refresh_capabilities"));
            this.chkCaching.setToolTipText(PluginServices.getText((Object)this, (String)"refresh_capabilities_tooltip"));
            this.chkCaching.setSelected(this.refreshing);
            this.chkCaching.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    WCSWizard.this.refreshing = WCSWizard.this.chkCaching.isSelected();
                }
            });
            this.chkCaching.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    fPrefs.putBoolean("refresh_capabilities", WCSWizard.this.chkCaching.isSelected());
                }
            });
        }
        return this.chkCaching;
    }

    private JCheckBox getChkTileCache() {
        if (this.chkTileCache == null) {
            this.chkTileCache = new JCheckBox();
            this.chkTileCache.setBounds(7, 72, 249, 20);
            this.chkTileCache.setText(PluginServices.getText((Object)this, (String)"tile_cache"));
            this.chkTileCache.setToolTipText(PluginServices.getText((Object)this, (String)"tile_cache_tooltip"));
            this.chkTileCache.setSelected(this.usingTileCache);
            this.chkTileCache.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    WCSWizard.this.usingTileCache = WCSWizard.this.chkTileCache.isSelected();
                }
            });
            this.chkTileCache.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    fPrefs.putBoolean("tile_cache", WCSWizard.this.chkTileCache.isSelected());
                }
            });
        }
        return this.chkTileCache;
    }

    private JPanel getPnlName() {
        if (this.pnlName == null) {
            this.pnlName = new JPanel(new FlowLayout(0, 10, 0));
            this.pnlName.setBounds(new Rectangle(9, 19, 452, 24));
            this.pnlName.add((Component)this.getJLabel1(), null);
            this.pnlName.add((Component)this.getLblTitle(), null);
        }
        return this.pnlName;
    }

    public DataStoreParameters[] getParameters() {
        return null;
    }

    public void close() {
    }

    public class ConnectThread
    extends Thread {
        private ICancellable cancel = null;
        private WCSServerExplorer explorer = null;
        private WCSWizard wizard = null;

        public ConnectThread(ICancellable cancel, WCSServerExplorer explorer, WCSWizard wizard) {
            this.cancel = cancel;
            this.explorer = explorer;
            this.wizard = wizard;
        }

        @Override
        public void run() {
            if (!WCSWizard.this.checkHostAndNetwork()) {
                return;
            }
            try {
                this.explorer.connect(this.cancel);
                WCSWizard.this.saveServerListFromComboBox();
            }
            catch (ConnectException e) {
                String msg = e.getMessage() + " : " + this.getIOExceptionMessage((Exception)((Object)e));
                logger.info(msg, (Throwable)e);
                JOptionPane.showMessageDialog(WCSWizard.this.getWCSParamsPanel(), msg, Messages.getText((String)"Error"), 0);
                return;
            }
            finally {
                ((CancelTaskImpl)this.cancel).setCanceled(false);
            }
            this.wizard.rellenarControles();
        }

        private String getIOExceptionMessage(Exception e) {
            Throwable ex = e;
            int MAX_DEEP = 10;
            for (int deep = 0; deep < 10; ++deep) {
                Throwable t = null;
                if (ex instanceof IOException) {
                    return ex.getMessage();
                }
                if (ex instanceof RemoteServiceException) {
                    t = ex.getCause();
                }
                if (t == null) {
                    return null;
                }
                ex = t;
            }
            return null;
        }
    }
}

