/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wcs.app.wcsclient.layer;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.print.attribute.PrintRequestAttributeSet;
import org.cresques.cts.IProjection;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.RasterManager;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.datastruct.ViewPortData;
import org.gvsig.fmap.dal.coverage.exception.FilePaletteException;
import org.gvsig.fmap.dal.coverage.exception.InfoByPointException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.QueryException;
import org.gvsig.fmap.dal.coverage.exception.RemoteServiceException;
import org.gvsig.fmap.dal.coverage.store.RasterDataServerExplorer;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.TileDataParameters;
import org.gvsig.fmap.dal.coverage.store.props.Transparency;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.Tiling;
import org.gvsig.raster.fmap.layers.DefaultFLyrRaster;
import org.gvsig.raster.fmap.layers.NotAvailableStateException;
import org.gvsig.raster.util.CancelTaskImpl;
import org.gvsig.raster.wcs.app.wcsclient.layer.DynObjectSetWCSInfo;
import org.gvsig.raster.wcs.io.WCSDataParameters;
import org.gvsig.raster.wcs.io.WCSProvider;
import org.gvsig.raster.wcs.io.WCSServerExplorer;
import org.gvsig.raster.wcs.io.WCSServerExplorerParameters;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObjectSet;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.task.Cancellable;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatus;
import org.gvsig.tools.task.TaskStatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLyrWCS
extends DefaultFLyrRaster {
    private static final int MAX_RETRY_TIMES = 5;
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(FLyrWCS.class);
    private boolean isPrinting = false;
    private boolean mustTileDraw = false;
    private int maxTileDrawWidth = 1023;
    private int maxTileDrawHeight = 1023;
    private final int maxTilePrintWidth = 1023;
    private final int maxTilePrintHeight = 1023;
    private boolean firstLoad = false;
    private Envelope fullEnvelope = null;
    private int callCount;
    private RasterManager rManager = RasterLocator.getManager();
    private boolean deleteCache = false;

    public FLyrWCS() {
        this.updateDrawVersion();
        try {
            this.enableAwake();
        }
        catch (NotAvailableStateException e) {
            logger.error("Fallo el estado de open. Closed=" + this.isClosed() + " Awake=" + this.isAwake(), (Object)this, (Object)e);
        }
    }

    public FLyrWCS(DataStoreParameters dataStoreParameters) throws Exception {
        this();
        DataManager dataManager = DALLocator.getDataManager();
        WCSServerExplorerParameters explorerParams = (WCSServerExplorerParameters)dataManager.createServerExplorerParameters(WCSProvider.NAME);
        explorerParams.setHost((String)dataStoreParameters.getDynValue("uri"));
        WCSServerExplorer wmsServerExplorer = (WCSServerExplorer)dataManager.openServerExplorer(WCSProvider.NAME, (DataServerExplorerParameters)explorerParams);
        wmsServerExplorer.connect(null);
        wmsServerExplorer.getCoverageList();
        this.setParameters((DataStoreParameters)((WCSDataParameters)dataStoreParameters));
        this.setExplorer(wmsServerExplorer);
    }

    public static DataStore createDataStore(String host, IProjection srs) throws InitializeException {
        URI uriHost;
        DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
        RasterDataParameters params = null;
        try {
            params = (RasterDataParameters)dataman.createServerExplorerParameters(WCSProvider.NAME);
        }
        catch (InitializeException e) {
            return null;
        }
        catch (ProviderNotRegisteredException e) {
            return null;
        }
        try {
            uriHost = new URI(host);
        }
        catch (URISyntaxException e1) {
            throw new InitializeException((Throwable)e1);
        }
        params.setURI(uriHost);
        params.setSRS(srs);
        try {
            return dataman.openStore(params.getDataStoreName(), (DataStoreParameters)params);
        }
        catch (ValidateDataParametersException e) {
            throw new InitializeException((Throwable)e);
        }
        catch (ProviderNotRegisteredException e) {
            throw new InitializeException((Throwable)e);
        }
    }

    public void setDataStore(DataStore dataStore) throws LoadLayerException {
        this.dataStore = (RasterDataStore)dataStore;
        try {
            if (this.dataStore.isOpen()) {
                this.enableOpen();
            }
        }
        catch (NotAvailableStateException e) {
            logger.error("Fallo el estado de open. Closed=" + this.isClosed() + " Awake=" + this.isAwake(), (Object)this, (Object)e);
        }
        this.setProjection(this.dataStore.getProjection());
    }

    public void draw(BufferedImage image, Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale) throws ReadException {
        TaskStatusManager manager = ToolsLocator.getTaskStatusManager();
        DefaultFLyrRaster.RasterTaskStatus taskStatus = new DefaultFLyrRaster.RasterTaskStatus((DefaultFLyrRaster)this, "Drawing " + this.getName() + "...", cancel);
        manager.add((TaskStatus)taskStatus);
        taskStatus.setAutoremove(true);
        if (!this.firstLoad) {
            try {
                this.initFilters();
                try {
                    if (!this.isOpen()) {
                        this.enableOpen();
                    }
                }
                catch (NotAvailableStateException e) {
                    throw new ReadException("Fallo el estado de open. Closed=" + this.isClosed() + " Awake=" + this.isAwake(), (Throwable)e);
                }
            }
            catch (FilePaletteException e) {
                logger.error(e.getMessage(), (Object)this, (Object)e);
            }
            this.firstLoad = true;
        }
        this.callCount = 0;
        this.enableStopped();
        if (this.recalcLevel) {
            double pixelSize = viewPort.getEnvelope().getLength(0) / (double)viewPort.getImageWidth();
            this.zoomLevel = this.dataStore.getNearestLevel(pixelSize);
        }
        this.recalcLevel = true;
        if (this.isWithinScale(scale)) {
            if (this.mustTileDraw) {
                Point2D p = viewPort.getOffset();
                Rectangle r = new Rectangle((int)p.getX(), (int)p.getY(), viewPort.getImageWidth(), viewPort.getImageHeight());
                Tiling tiles = new Tiling(this.maxTileDrawWidth, this.maxTileDrawHeight, (Rectangle2D)r);
                tiles.setAffineTransform((AffineTransform)viewPort.getAffineTransform().clone());
                for (int tileNr = 0; tileNr < tiles.getNumTiles(); ++tileNr) {
                    try {
                        ViewPort vp = tiles.getTileViewPort(viewPort, tileNr);
                        this.drawTile(g, vp, (SimpleTaskStatus)taskStatus, scale);
                        continue;
                    }
                    catch (LoadLayerException e) {
                        throw new ReadException(e.getMessage(), (Throwable)e);
                    }
                    catch (NoninvertibleTransformException e) {
                        throw new ReadException(e.getMessage(), (Throwable)e);
                    }
                }
            } else {
                try {
                    this.drawTile(g, viewPort, (SimpleTaskStatus)taskStatus, scale);
                }
                catch (LoadLayerException e) {
                    throw new ReadException(e.getMessage(), (Throwable)e);
                }
            }
        }
        this.disableStopped();
    }

    private void drawTile(Graphics2D g, ViewPort vp, SimpleTaskStatus taskStatus, double scale) throws LoadLayerException, ReadException {
        block15: {
            ++this.callCount;
            Envelope envelope = this.getFullEnvelope();
            Envelope vpEnv = vp.getAdjustedExtent();
            if (!vpEnv.intersects(envelope)) {
                return;
            }
            Rectangle2D.Double bBox = new Rectangle2D.Double();
            Rectangle2D.intersect(this.getRectable2DFromEnvelope(vpEnv), this.getRectable2DFromEnvelope(envelope), bBox);
            double scalex = vp.getAffineTransform().getScaleX();
            double scaley = vp.getAffineTransform().getScaleY();
            int wImg = (int)Math.ceil(Math.abs(((RectangularShape)bBox).getWidth() * scalex) + 1.0);
            int hImg = (int)Math.ceil(Math.abs(((RectangularShape)bBox).getHeight() * scaley) + 1.0);
            Dimension sz = new Dimension(wImg, hImg);
            if (wImg <= 0 || hImg <= 0) {
                return;
            }
            try {
                Envelope vpAdjustedEnvelope = vp.getAdjustedEnvelope();
                Extent ex = this.rManager.getDataStructFactory().createExtent(vpAdjustedEnvelope.getMinimum(0), vpAdjustedEnvelope.getMaximum(1), vpAdjustedEnvelope.getMaximum(0), vpAdjustedEnvelope.getMinimum(1));
                ViewPortData vpData = this.rManager.getDataStructFactory().createViewPortData(vp.getProjection(), ex, (Dimension2D)sz);
                vpData.setMat(vp.getAffineTransform());
                vpData.setDPI((int)vp.getDPI());
                try {
                    this.getParameters().setExtent((Rectangle2D)bBox);
                    this.getParameters().setWidth(wImg);
                    this.getParameters().setHeight(hImg);
                    if (this.getDataStore().getParameters() instanceof WCSDataParameters) {
                        this.getRender().draw(g, vpData, (TaskStatus)taskStatus);
                    } else {
                        Envelope adjustedExtent = vp.getAdjustedExtent();
                        Extent e = this.rManager.getDataStructFactory().createExtent(adjustedExtent.getLowerCorner().getX(), adjustedExtent.getUpperCorner().getY(), adjustedExtent.getUpperCorner().getX(), adjustedExtent.getLowerCorner().getY());
                        ViewPortData vp2 = this.rManager.getDataStructFactory().createViewPortData(vp.getProjection(), e, (Dimension2D)vp.getImageSize());
                        vp2.setMat(vp.getAffineTransform());
                        vp2.setDPI((int)vp.getDPI());
                        this.getParameters().setExtent(ex.toRectangle2D());
                        this.getRender().drawTiledService(g, vp2, (Dimension2D)vp.getImageSize(), (TaskStatus)taskStatus);
                    }
                }
                catch (ProcessInterruptedException adjustedExtent) {
                }
                catch (QueryException e) {
                    throw new RemoteServiceException("Problems drawing this layer: " + e.getMessage(), (Throwable)e);
                }
                finally {
                    taskStatus.terminate();
                }
            }
            catch (RemoteServiceException e) {
                if (taskStatus.isCancellationRequested()) break block15;
                if (this.callCount < 5) {
                    logger.warn("\n[ FLyrWCS.drawFixedSize() ]  Failed in trying " + this.callCount + "/" + 5 + ")\n");
                    this.drawTile(g, vp, taskStatus, scale);
                }
                if (!this.isPrinting) {
                    this.setVisible(false);
                }
                throw new LoadLayerException(this.getName(), (Throwable)e);
            }
        }
        --this.callCount;
    }

    public Point2D getMaxResolution() {
        return this.getExplorer().getMaxResolution(this.getName());
    }

    private Rectangle2D.Double getRectable2DFromEnvelope(Envelope env) {
        return new Rectangle2D.Double(env.getMinimum(0), env.getMinimum(1), env.getLength(0), env.getLength(1));
    }

    public WCSServerExplorer getExplorer() {
        try {
            return (WCSServerExplorer)this.getDataStore().getExplorer();
        }
        catch (ValidateDataParametersException e) {
            logger.debug("Error getting the explorer", (Throwable)e);
        }
        catch (DataException e) {
            logger.debug("Error getting the explorer", (Throwable)e);
        }
        return null;
    }

    public String getDataWorldFile(Rectangle2D bBox, Dimension sz) throws IOException {
        StringBuffer data = new StringBuffer();
        data.append((bBox.getMaxX() - bBox.getMinX()) / (sz.getWidth() - 1.0) + "\n");
        data.append("0.0\n");
        data.append("0.0\n");
        data.append("-" + (bBox.getMaxY() - bBox.getMinY()) / (sz.getHeight() - 1.0) + "\n");
        data.append("" + bBox.getMinX() + "\n");
        data.append("" + bBox.getMaxY() + "\n");
        return data.toString();
    }

    public FLayer cloneLayer() throws Exception {
        FLyrWCS layer = (FLyrWCS)this.cloneLayer0();
        layer.fullEnvelope = this.fullEnvelope;
        return this.cloneLayer1(layer);
    }

    public Transparency getRenderTransparency() {
        return this.getRender().getRenderingTransparency();
    }

    public void print(Graphics2D g, ViewPort viewPort, Cancellable cancel, double scale, PrintRequestAttributeSet properties) throws ReadException {
        if (this.isVisible() && this.isWithinScale(scale)) {
            this.draw(null, g, viewPort, cancel, scale);
        }
    }

    public void setFullEnvelope(Envelope envelope) {
        Envelope cur = this.getFullEnvelope();
        if (cur == envelope) {
            return;
        }
        if (cur != null && cur.equals(envelope)) {
            return;
        }
        this.fullEnvelope = envelope;
        this.updateDrawVersion();
    }

    public void setFullExtent(Rectangle2D fullExtent) {
        this.setFullEnvelope(this.getEnvelopeFromRectable2D(fullExtent));
    }

    private Envelope getEnvelopeFromRectable2D(Rectangle2D rect) {
        try {
            return geomManager.createEnvelope(rect.getMinX(), rect.getMinY(), rect.getMaxX(), rect.getMaxY(), 0);
        }
        catch (CreateEnvelopeException e) {
            logger.error("Error creating the envelope", (Throwable)e);
            return null;
        }
    }

    public HashMap<String, Object> getProperties() {
        HashMap<String, Object> info = new HashMap<String, Object>();
        try {
            info.put("name", this.getName());
            info.put("selectedLayers", this.getParameters().getCoverageName());
            info.put("host", this.getParameters().getURI());
            info.put("crs", this.getParameters().getSRSCode());
            info.put("format", this.getParameters().getFormat());
            info.put("time", this.getParameters().getTime());
            return info;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int[] getTileSize() {
        int[] size = new int[]{this.maxTileDrawWidth, this.maxTileDrawHeight};
        return size;
    }

    public String getTocImageIcon() {
        return "ico-WCS-Layer";
    }

    public boolean isTiled() {
        return this.mustTileDraw;
    }

    public boolean isRemote() {
        return true;
    }

    public DynObjectSet getInfo(Point p, double tolerance, Cancellable cancel, boolean fast) throws LoadLayerException, DataException {
        String fInfo;
        ViewPort viewPort = this.getMapContext().getViewPort();
        Point tiledPoint = new Point((int)p.getX() % 1023, (int)p.getY() % 1023);
        Rectangle rect = new Rectangle(0, 0, viewPort.getImageWidth() - 1, viewPort.getImageHeight() - 1);
        Tiling tiles = new Tiling(1023, 1023, (Rectangle2D)rect);
        tiles.setAffineTransform((AffineTransform)viewPort.getAffineTransform().clone());
        int nCols = tiles.getNumCols();
        int col = (int)p.getX() / 1023;
        int row = (int)p.getY() / 1023;
        int tileIndex = row * nCols + col;
        ViewPort vp = null;
        try {
            vp = tiles.getTileViewPort(viewPort, tileIndex);
        }
        catch (NoninvertibleTransformException e1) {
            throw new LoadLayerException("", (Throwable)e1);
        }
        this.getParameters().setExtent((Rectangle2D)this.getRectable2DFromEnvelope(vp.getAdjustedExtent()));
        this.getParameters().setWidth(vp.getImageWidth());
        this.getParameters().setHeight(vp.getImageHeight());
        CancelTaskImpl cancellable = new CancelTaskImpl(cancel);
        this.getParameters().setCancellable((ICancellable)cancellable);
        try {
            fInfo = this.getDataStore().getInfoByPoint(tiledPoint.getX(), tiledPoint.getY(), (ICancellable)cancellable);
        }
        catch (InfoByPointException e) {
            throw new LoadLayerException("Error in getInfoByPoint", (Throwable)e);
        }
        return new DynObjectSetWCSInfo(fInfo, 0);
    }

    public String getFileFormat() {
        return "WCS";
    }

    public boolean isActionEnabled(int action) {
        switch (action) {
            case 0: 
            case 7: 
            case 8: 
            case 14: 
            case 15: 
            case 19: {
                return false;
            }
            case 6: 
            case 9: 
            case 20: {
                return true;
            }
        }
        return super.isActionEnabled(action);
    }

    public boolean overviewsSupport() {
        return false;
    }

    public Extent getFullRasterExtent() {
        Envelope env = this.getFullEnvelope();
        double minx = env.getMinimum(0);
        double miny = env.getMinimum(1);
        double maxx = env.getMaximum(0);
        double maxy = env.getMaximum(1);
        Point2D.Double ul = new Point2D.Double(minx, maxy);
        Point2D.Double ur = new Point2D.Double(maxx, maxy);
        Point2D.Double ll = new Point2D.Double(minx, miny);
        Point2D.Double lr = new Point2D.Double(maxx, miny);
        return this.rManager.getDataStructFactory().createExtent((Point2D)ul, (Point2D)lr, (Point2D)ur, (Point2D)ll);
    }

    public WCSDataParameters getParameters() {
        return this.getWCSParameters(this.getDataStore().getParameters());
    }

    private WCSDataParameters getWCSParameters(DataStoreParameters parameters) {
        DataParameters p;
        WCSDataParameters params = null;
        if (parameters instanceof WCSDataParameters) {
            params = (WCSDataParameters)parameters;
        }
        if (parameters instanceof TileDataParameters && (p = ((TileDataParameters)parameters).getDataParameters()) instanceof WCSDataParameters) {
            params = (WCSDataParameters)p;
        }
        return params;
    }

    public void setExplorer(WCSServerExplorer explorer) {
        if (this.getDataStore() != null) {
            this.getDataStore().setExplorer((RasterDataServerExplorer)explorer);
        }
    }

    public void deleteCache(boolean deleteCache) {
        this.deleteCache = deleteCache;
    }

    public void setParameters(DataStoreParameters params) throws InitializeException {
        if (params instanceof TileDataParameters) {
            ((TileDataParameters)params).deleteCache(this.deleteCache);
        }
        DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
        try {
            DataParameters p;
            DataStore dStore = dataman.openStore(params.getDataStoreName(), params);
            this.setDataStore(dStore);
            if (params instanceof WCSDataParameters) {
                this.setName(((WCSDataParameters)params).getURI().getPath());
            }
            if (params instanceof TileDataParameters && (p = ((TileDataParameters)params).getDataParameters()) instanceof WCSDataParameters) {
                this.setName(((WCSDataParameters)p).getURI().getPath());
            }
        }
        catch (ValidateDataParametersException e) {
            throw new InitializeException((Throwable)e);
        }
        catch (ProviderNotRegisteredException e) {
            throw new InitializeException((Throwable)e);
        }
        catch (LoadLayerException e) {
            throw new InitializeException((Throwable)e);
        }
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition("FLyrWCS_Persistent");
        if (definition == null) {
            if (manager.getDefinition(DefaultFLyrRaster.class) == null) {
                DefaultFLyrRaster.registerPersistence();
            }
            definition = manager.addDefinition(FLyrWCS.class, "FLyrWCS_Persistent", "FLyrWCS Persistent Definition", null, null);
            definition.extend("Persistence", "FLyrRasterSE_Persistent");
        }
        DefaultFLyrRaster.registerPersistence((DynStruct)definition);
    }

    private class MyCancellable
    implements ICancellable {
        private Cancellable original;

        public MyCancellable(Cancellable cancelOriginal) {
            this.original = cancelOriginal;
        }

        public boolean isCanceled() {
            return this.original.isCanceled();
        }

        public Object getID() {
            return this;
        }
    }
}

