/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl;

import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.CodeBuilder;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionEvaluatorManager;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.Function;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.impl.DefaultCodeBuilder;
import org.gvsig.expressionevaluator.impl.DefaultSymbolTable;
import org.gvsig.expressionevaluator.impl.I18N;
import org.gvsig.expressionevaluator.impl.function.operator.BinaryOperator;
import org.gvsig.expressionevaluator.impl.function.operator.UnaryOperator;
import org.gvsig.expressionevaluator.impl.function.programming.ReturnFunction;
import org.gvsig.expressionevaluator.spi.AbstractSymbolTable;
import org.gvsig.expressionevaluator.spi.UndefinedSymbolException;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;

public class DefaultInterpreter
implements Interpreter {
    public static int DEFAULT_MAX_RECURSION_LIMIT = 20;
    private SymbolTable symbolTable = null;
    private Double accuracy;
    private Code currentCode;
    private Interpreter.Cache cache = new DefaultCache();
    private int maxRecursionLimit = DEFAULT_MAX_RECURSION_LIMIT;
    private boolean sqlCompatible = false;
    private Writer writer = new OutputStreamWriter(System.out);
    private ResourcesStorage resourcesStorage = ResourcesStorage.EMPTY_RESOURCESSTORAGE;
    private CodeBuilder codeBuilder;

    public Interpreter clone() throws CloneNotSupportedException {
        DefaultInterpreter other = (DefaultInterpreter)super.clone();
        other.cache = new DefaultCache();
        if (this.symbolTable != null) {
            other.symbolTable = this.symbolTable.clone();
        }
        return other;
    }

    public CodeBuilder getCodeBuilder() {
        if (this.codeBuilder == null) {
            ExpressionEvaluatorManager manager = ExpressionEvaluatorLocator.getExpressionEvaluatorManager();
            this.codeBuilder = manager.createCodeBuilder();
        }
        return this.codeBuilder;
    }

    public ResourcesStorage getResourcesStorage() {
        return this.resourcesStorage;
    }

    public void setResourcesStorage(ResourcesStorage resourcesStorage) {
        this.resourcesStorage = resourcesStorage == null ? ResourcesStorage.EMPTY_RESOURCESSTORAGE : resourcesStorage;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        if (writer == null) {
            writer = new OutputStreamWriter(System.out);
        }
        this.writer = writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call(SymbolTable symbolTable, String funcname, Object ... args) throws Exception {
        if (this.symbolTable == null) {
            try {
                this.symbolTable = symbolTable;
                Object object = this.call(funcname, args);
                return object;
            }
            finally {
                this.symbolTable = null;
            }
        }
        SymbolTable savedSymbolTable = this.symbolTable;
        try {
            symbolTable.addSymbolTable(this.symbolTable);
            this.symbolTable = symbolTable;
            Object object = this.call(funcname, args);
            return object;
        }
        finally {
            this.symbolTable = savedSymbolTable;
            symbolTable.removeSymbolTable(this.symbolTable);
        }
    }

    public Object call(String function, Object ... args) throws Exception {
        Function fn = this.symbolTable.function(function);
        Object value = fn.call((Interpreter)this, args);
        return value;
    }

    public boolean hasFunction(String function) {
        Function fn = this.getSymbolTable().function(function);
        return fn != null;
    }

    public int getMaxRecursionLimit() {
        return this.maxRecursionLimit;
    }

    public void setMaxRecursionLimit(int limit) {
        this.maxRecursionLimit = limit;
    }

    public Interpreter.Cache getCache() {
        return this.cache;
    }

    public void setSymbolTable(SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
    }

    public SymbolTable getSymbolTable() {
        if (this.symbolTable == null) {
            this.symbolTable = new DefaultSymbolTable();
        }
        return this.symbolTable;
    }

    public Double getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(Double accuracy) {
        this.accuracy = accuracy;
    }

    public void setSQLCompatible(boolean sqlCompatible) {
        this.sqlCompatible = sqlCompatible;
    }

    public boolean isSQLCompatible() {
        return this.sqlCompatible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(MutableSymbolTable symbolTable, Code code) {
        if (this.symbolTable == null) {
            try {
                this.symbolTable = symbolTable;
                this.run(code);
            }
            finally {
                this.symbolTable = null;
            }
        }
        SymbolTable savedSymbolTable = this.symbolTable;
        try {
            symbolTable.addSymbolTable(this.symbolTable);
            this.symbolTable = symbolTable;
            this.run(code);
        }
        finally {
            this.symbolTable = savedSymbolTable;
            symbolTable.removeSymbolTable(this.symbolTable);
        }
    }

    public Object run(Code code) {
        try {
            return this.runCode(code);
        }
        catch (ReturnFunction.ReturnException ex) {
            return ex.getValue();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExpressionRuntimeException(code, "", (Throwable)ex);
        }
    }

    public void link(Code code) {
        code.link(this.getSymbolTable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object runCode(Code code) throws Exception {
        if (code == null) {
            return null;
        }
        DefaultCodeBuilder.RecursionControlSupport recursionControl = null;
        if (code instanceof DefaultCodeBuilder.RecursionControlSupport && !(recursionControl = (DefaultCodeBuilder.RecursionControlSupport)code).enterCode(this.maxRecursionLimit)) {
            recursionControl.resetRecursionState();
            throw new ExpressionRuntimeException(code, I18N.Maximum_recursion_limit_exceeded());
        }
        Object value = null;
        this.currentCode = code;
        try {
            if (code.code() == 0) {
                value = ((Code.Constant)code).value();
                return value;
            }
            SymbolTable theSymbolTable = this.getSymbolTable();
            if (theSymbolTable instanceof AbstractSymbolTable) {
                ((AbstractSymbolTable)theSymbolTable).fixSymbolTables();
            }
            switch (code.code()) {
                case 1: {
                    String name = ((Code.Identifier)code).name();
                    if (!this.getSymbolTable().exists(name)) {
                        throw new UndefinedSymbolException(code, I18N.Undefined_variable_XIdentifierX(name), I18N.Use_single_quotes_to_enter_literal_strings());
                    }
                    value = this.getSymbolTable().value(name);
                    return value;
                }
                case 3: {
                    Code.Method method = (Code.Method)code;
                    Codes args = method.parameters();
                    int argc = args == null ? 0 : args.size();
                    Object[] argvalues = new Object[argc];
                    if (args != null) {
                        int i = 0;
                        for (Code arg : args) {
                            argvalues[i++] = this.runCode(arg);
                        }
                    }
                    value = method.call((Interpreter)this, argvalues);
                    return value;
                }
                case 2: {
                    Code.Callable caller = (Code.Callable)code;
                    Function function = caller.function();
                    if (function == null) {
                        function = this.getSymbolTable().function(caller.name());
                        if (function == null) {
                            try {
                                function = (Function)this.getSymbolTable().value(caller.name());
                            }
                            catch (Exception argc) {
                                // empty catch block
                            }
                            if (function == null) {
                                throw new ExpressionRuntimeException(code, I18N.Undefined_function_XIdentifierX(caller.name()));
                            }
                        }
                        caller.function(function);
                    }
                    Codes args = caller.parameters();
                    try {
                        switch (caller.type()) {
                            case 2: {
                                if (args == null || args.size() != 1) {
                                    int n;
                                    String string = function.name();
                                    if (args == null) {
                                        n = 0;
                                        throw new ExpressionRuntimeException(code, I18N.Number_of_argument_mistmatch_in_operator_XIdentifierX_expected_1_got_XargcX(string, n));
                                    }
                                    n = args.size();
                                    throw new ExpressionRuntimeException(code, I18N.Number_of_argument_mistmatch_in_operator_XIdentifierX_expected_1_got_XargcX(string, n));
                                }
                                if (function.useArgumentsInsteadObjects()) {
                                    value = function.call((Interpreter)this, args);
                                    return value;
                                }
                                value = ((UnaryOperator)function).call(this, this.runCode((Code)args.get(0)));
                                return value;
                            }
                            case 1: {
                                if (args == null || args.size() != 2) {
                                    int n;
                                    String string = function.name();
                                    if (args == null) {
                                        n = 0;
                                        throw new ExpressionRuntimeException(code, I18N.Number_of_argument_mistmatch_in_operator_XIdentifierX_expected_2_got_XargcX(string, n));
                                    }
                                    n = args.size();
                                    throw new ExpressionRuntimeException(code, I18N.Number_of_argument_mistmatch_in_operator_XIdentifierX_expected_2_got_XargcX(string, n));
                                }
                                if (function.useArgumentsInsteadObjects()) {
                                    value = function.call((Interpreter)this, args);
                                    return value;
                                }
                                value = ((BinaryOperator)function).call(this, this.runCode((Code)args.get(0)), this.runCode((Code)args.get(1)));
                                return value;
                            }
                            case 0: {
                                int argc;
                                int n = argc = args == null ? 0 : args.size();
                                if (!function.argc().contains((Object)argc)) {
                                    throw new ExpressionRuntimeException(code, I18N.Number_of_argument_mistmatch_in_function_XIdentifierX_expected_XexpectedX_got_XfoundX(function.name(), function.argc(), argc));
                                }
                                if (function.useArgumentsInsteadObjects()) {
                                    value = function.call((Interpreter)this, args);
                                    return value;
                                }
                                Object[] argvalues = new Object[argc];
                                if (args != null) {
                                    int i = 0;
                                    for (Code arg : args) {
                                        argvalues[i++] = this.runCode(arg);
                                    }
                                }
                                value = function.call((Interpreter)this, argvalues);
                                return value;
                            }
                        }
                        return value;
                    }
                    catch (RuntimeException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        String argsstr = "???";
                        try {
                            argsstr = Objects.toString(args);
                            throw new ExpressionRuntimeException(code, I18N.Problems_calling_function_XIdentifierX_with_args_XargsX(function.name(), argsstr), (Throwable)ex);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw new ExpressionRuntimeException(code, I18N.Problems_calling_function_XIdentifierX_with_args_XargsX(function.name(), argsstr), (Throwable)ex);
                    }
                }
            }
            return value;
        }
        finally {
            this.currentCode = null;
            if (recursionControl != null) {
                recursionControl.exitCode();
            }
        }
    }

    public Code getCurrentCode() {
        return this.currentCode;
    }

    private class DefaultCache
    implements Interpreter.Cache {
        private Map<Pair<Object, Object>, Pair<Object, Long>> data = new HashMap<Pair<Object, Object>, Pair<Object, Long>>();

        public Object get(Object context, Object key) {
            Pair<Object, Long> v = this.data.get(Pair.of((Object)context, (Object)key));
            if (v == null) {
                return null;
            }
            return v.getLeft();
        }

        public void put(Object context, Object key, Object value) {
            if (this.data.size() > this.getMaxElements()) {
                this.reduce();
            }
            this.data.put((Pair<Object, Object>)Pair.of((Object)context, (Object)key), (Pair<Object, Long>)Pair.of((Object)value, (Object)new Date().getTime()));
        }

        public void remove(Object context, Object key) {
            this.data.remove(Pair.of((Object)context, (Object)key));
        }

        public void removeAll() {
            this.data = new HashMap<Pair<Object, Object>, Pair<Object, Long>>();
        }

        private int getMaxElements() {
            return 100;
        }

        private void reduce() {
            ArrayList<Map.Entry<Pair<Object, Object>, Pair<Object, Long>>> entries = new ArrayList<Map.Entry<Pair<Object, Object>, Pair<Object, Long>>>(this.data.entrySet());
            entries.sort((o1, o2) -> ((Long)((Pair)o1.getValue()).getRight()).compareTo((Long)((Pair)o2.getValue()).getRight()));
            for (int i = 0; i < this.getMaxElements() / 2; ++i) {
                this.data.remove(((Map.Entry)entries.get(i)).getKey());
            }
        }
    }
}

