/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.typeconversion;

import java.util.Iterator;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.util.GetItem;
import org.gvsig.tools.util.Size;

public class ToStrFunction
extends AbstractFunction {
    public ToStrFunction() {
        super("Conversion", "TOSTR", Range.is((Comparable)Integer.valueOf(1)));
        this.addAlias("STR");
        this.addAlias("toString");
    }

    public boolean allowConstantFolding() {
        return true;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        Object obj = this.getObject(args, 0);
        StringBuilder builder = new StringBuilder();
        this.join(builder, obj, ", ");
        return builder.toString();
    }

    private void join(StringBuilder builder, final Object obj, String separator) {
        Coercion toStr = ToolsLocator.getDataTypesManager().getCoercion(8);
        if (obj instanceof Iterable) {
            builder.append("[");
            this.join(builder, ((Iterable)obj).iterator(), separator);
            builder.append("]");
        } else if (obj instanceof GetItem && obj instanceof Size) {
            Iterator it = new Iterator(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < ((Size)obj).size();
                }

                public Object next() {
                    return ((GetItem)obj).get(this.i++);
                }
            };
            builder.append("[");
            this.join(builder, ((Iterable)obj).iterator(), separator);
            builder.append("]");
        } else {
            try {
                Object value = toStr.coerce(obj);
                builder.append(value);
            }
            catch (CoercionException ex) {
                builder.append(obj);
            }
        }
    }

    private void join(StringBuilder builder, Iterator it, String separator) {
        boolean needseparator = false;
        while (it.hasNext()) {
            if (needseparator) {
                builder.append(separator);
            } else {
                needseparator = true;
            }
            Object item = it.next();
            this.join(builder, item, separator);
        }
    }
}

