/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.duplicate;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.collections4.CollectionUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.Aggregate;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiSurface;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.EditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class PasteFromClipboardEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    private final EditingServiceParameter clipboard;
    private final EditingServiceParameter location;
    private final EditingServiceParameter copyAlphanumericAttributes;
    private final FeatureStore featureStore;
    private Map<EditingServiceParameter, Object> values;
    private Point firstPoint;
    private final Observer clipboardObserver;

    public PasteFromClipboardEditingProvider(DynObject parameters, ProviderServices services) {
        super(services);
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        EditingProviderServices editingProviderServices = this.getProviderServices();
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.clipboard = new DefaultEditingServiceParameter("clipboard", "_Clipboard", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.CLIPBOARD});
        String locationMsg = "_Press_[ENTER]_to_place_the_geometries_in_the_original_position_or_provide_a_new_location";
        this.location = new DefaultEditingServiceParameter("location", i18nManager.getTranslation(locationMsg), new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        DefaultEditingServiceParameterOptions copyAlphanumericAttributesOptions = new DefaultEditingServiceParameterOptions().add("_Copy_alphanumeric_attributes", (Object)true, i18nManager.getTranslation("_yes")).add("_Dont_copy_alphanumeric_attributes", (Object)false, i18nManager.getTranslation("_no"));
        String copyAlphanumericAttributesConsoleMsg = editingProviderServices.makeConsoleMessage("_Copy_alphanumeric_attributes", (EditingServiceParameterOptions)copyAlphanumericAttributesOptions);
        this.copyAlphanumericAttributes = new DefaultEditingServiceParameter("copyAlphanumericAttributes", copyAlphanumericAttributesConsoleMsg, (EditingServiceParameterOptions)copyAlphanumericAttributesOptions, (Object)i18nManager.getTranslation("_yes"), true, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.OPTION}).setDataType(1);
        this.clipboardObserver = (o, arg) -> this.doClipboardChanged();
    }

    public boolean isEnabled(EditingServiceParameter parameter) {
        return true;
    }

    private void doClipboardChanged() {
        EditingProviderManager manager = EditingProviderLocator.getProviderManager();
        List featuresFromClipBoard = manager.getFeaturesFromClipboard(this.getProviderServices(), this.featureStore);
        if (CollectionUtils.isNotEmpty((Collection)featuresFromClipBoard)) {
            try {
                this.setValue(this.clipboard, featuresFromClipBoard);
            }
            catch (InvalidEntryException invalidEntryException) {
                // empty catch block
            }
        }
    }

    public EditingServiceParameter next() {
        if (this.values.get(this.clipboard) == null) {
            return this.clipboard;
        }
        if (this.values.get(this.location) == null) {
            return this.location;
        }
        return null;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        List features;
        DefaultDrawingStatus drawingStatus = new DefaultDrawingStatus();
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        EditingProviderServices editingProviderServices = this.getProviderServices();
        try {
            int subtype = editingProviderServices.getSubType(this.featureStore);
        }
        catch (DataException e2) {
            throw new DrawServiceException((Throwable)e2);
        }
        ISymbol lineSymbolEditing = editingProviderManager.getSymbol("line-symbol-editing");
        ISymbol polygonSymbolEditing = editingProviderManager.getSymbol("polygon-symbol-editing");
        ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
        ISymbol previewSymbol = this.getPreviewSymbol();
        if (this.values != null && (features = (List)this.values.get(this.clipboard)) != null && this.firstPoint != null) {
            try {
                AffineTransform at = this.getMoveAffineTransform(this.firstPoint, mousePosition);
                for (Feature feature : features) {
                    Geometry geometry = feature.getDefaultGeometry().cloneGeometry();
                    ISymbol featurePreviewSymbol = this.getPreviewSymbol(feature);
                    if (featurePreviewSymbol == null) {
                        featurePreviewSymbol = previewSymbol;
                    }
                    geometry.transform(at);
                    ISymbol symbol = null;
                    if (geometry instanceof Curve || geometry instanceof MultiCurve) {
                        symbol = lineSymbolEditing;
                    } else if (geometry instanceof Surface || geometry instanceof MultiSurface) {
                        symbol = polygonSymbolEditing;
                    } else if (geometry instanceof Point || geometry instanceof MultiPoint) {
                        symbol = auxiliaryPointSymbolEditing;
                    }
                    if (geometry instanceof Aggregate) {
                        int primitivesNumber = ((Aggregate)geometry).getPrimitivesNumber();
                        for (int i = 0; i < primitivesNumber; ++i) {
                            drawingStatus.addStatus((Geometry)((Aggregate)geometry).getPrimitiveAt(i), symbol, "");
                            drawingStatus.addStatus((Geometry)((Aggregate)geometry).getPrimitiveAt(i), featurePreviewSymbol, "");
                        }
                        continue;
                    }
                    drawingStatus.addStatus(geometry, symbol, "");
                    drawingStatus.addStatus(geometry, featurePreviewSymbol, "");
                }
            }
            catch (Exception ex) {
                Logger.getLogger(PasteFromClipboardEditingProvider.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return drawingStatus;
    }

    private AffineTransform getMoveAffineTransform(Point p1, Point p2) throws GeometryOperationNotSupportedException, GeometryOperationException {
        AffineTransform translate = AffineTransform.getTranslateInstance(p2.getX() - p1.getX(), p2.getY() - p1.getY());
        return translate;
    }

    public void stop() throws StopServiceException {
        if (this.values != null) {
            this.values.clear();
        }
        ToolsSwingLocator.getToolsSwingManager().deleteClipboardObserver(this.clipboardObserver);
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.clipboard);
        parameters.add(this.location);
        parameters.add(this.copyAlphanumericAttributes);
        return parameters;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter parameter = this.next();
        this.validateAndInsertValue(parameter, value);
    }

    private void validateAndInsertValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        if (parameter == this.clipboard) {
            List features;
            if (value instanceof List && CollectionUtils.isNotEmpty((Collection)(features = (List)value))) {
                Iterator it = features.iterator();
                this.values.put(this.clipboard, features);
                try {
                    Envelope envelope = this.getEnvelope(features);
                    this.firstPoint = null;
                    if (envelope != null) {
                        this.firstPoint = envelope.getLowerCorner();
                    }
                }
                catch (CreateEnvelopeException createEnvelopeException) {
                    // empty catch block
                }
            }
            if (this.values.get(this.clipboard) == null && value instanceof FeatureSelection && ((FeatureSelection)value).getSelectedCount() > 0L) {
                this.values.put(this.clipboard, value);
            }
        } else if (parameter == this.location) {
            if (value == null) {
                this.values.put(parameter, this.firstPoint);
            }
            if (value instanceof Point) {
                this.values.put(parameter, value);
            }
        } else if (parameter == this.copyAlphanumericAttributes) {
            this.values.put(parameter, parameter.getOptions2().getValue(value, parameter.getDefaultValue()));
        }
    }

    public Geometry finish() throws FinishServiceException {
        return null;
    }

    public void finishAndStore() throws FinishServiceException {
        if (this.values != null) {
            Point p2 = (Point)this.values.get(this.location);
            List features = (List)this.values.get(this.clipboard);
            Boolean copyAttributes = (Boolean)this.values.get(this.copyAlphanumericAttributes);
            try {
                Iterator it = features.iterator();
                EditingProviderServices editingProviderServices = this.getProviderServices();
                AffineTransform at = this.getMoveAffineTransform(this.firstPoint, p2);
                while (it.hasNext()) {
                    EditableFeature editableFeature = (EditableFeature)it.next();
                    Geometry geometry = editableFeature.getDefaultGeometry().cloneGeometry();
                    geometry.transform(at);
                    EditableFeature targetEditableFeature = copyAttributes == null || copyAttributes != false ? this.getProviderServices().getFeatureCopyWithoutUniqueIndex(this.featureStore, (Feature)editableFeature) : this.getProviderServices().createNewFeature(this.featureStore);
                    targetEditableFeature.setDefaultGeometry(geometry);
                    EditableFeature defaultValues = this.getProviderServices().getDefaultFeatureValues();
                    targetEditableFeature.copyFrom((Feature)defaultValues, t -> editableFeature.isNull(t.getName()));
                    editingProviderServices.insertFeatureIntoFeatureStore((Feature)targetEditableFeature, this.featureStore);
                }
                this.featureStore.getFeatureSelection().deselectAll();
            }
            catch (Exception e) {
                throw new FinishServiceException((Throwable)e);
            }
        }
    }

    public void start() throws StartServiceException, InvalidEntryException {
        this.values = new HashMap<EditingServiceParameter, Object>();
        EditingProviderManager manager = EditingProviderLocator.getProviderManager();
        List featuresFromClipBoard = manager.getFeaturesFromClipboard(this.getProviderServices(), this.featureStore);
        if (CollectionUtils.isNotEmpty((Collection)featuresFromClipBoard)) {
            try {
                this.setValue(featuresFromClipBoard);
            }
            catch (InvalidEntryException invalidEntryException) {
                // empty catch block
            }
        }
        if (this.getValue(this.copyAlphanumericAttributes) == null) {
            this.setValue(this.copyAlphanumericAttributes, "true");
        }
        ToolsSwingLocator.getToolsSwingManager().addClipboardObserver(this.clipboardObserver);
    }

    public String getName() {
        return "modify-paste-from-clipboard";
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }

    private Envelope getEnvelope(List<Feature> features) throws CreateEnvelopeException {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        Envelope envelope = geomManager.createEnvelope(0);
        for (Feature feature : features) {
            envelope.add(feature.getDefaultGeometry());
        }
        return envelope;
    }
}

