/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.open.i18n;

import com.jeta.forms.components.panel.FormPanel;
import com.jeta.forms.gui.form.FormComponent;
import com.jeta.forms.gui.form.GridComponent;
import com.jeta.forms.gui.form.GridView;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.FormSpec;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.ComponentOrientation;
import java.awt.Insets;
import java.util.Iterator;
import java.util.LinkedList;

public class I18NUtils {
    public static FormPanel applyComponentOrientation(FormPanel form, ComponentOrientation orientation) {
        if (!orientation.isLeftToRight()) {
            I18NUtils.flip((GridView)form.getFormAccessor());
        }
        return form;
    }

    private static void flip(GridView view) {
        FormLayout layout = view.getFormLayout();
        int columnCount = layout.getColumnCount();
        int rowCount = layout.getRowCount();
        ColumnSpec[] colSpecs = new ColumnSpec[columnCount];
        RowSpec[] rowSpecs = new RowSpec[rowCount];
        LinkedList<GridView> views = new LinkedList<GridView>();
        GridComponent[][] components = new GridComponent[columnCount][rowCount];
        for (int column = 1; column <= columnCount; ++column) {
            colSpecs[column - 1] = layout.getColumnSpec(column);
            for (int row = 1; row <= rowCount; ++row) {
                GridComponent gc;
                rowSpecs[row - 1] = layout.getRowSpec(row);
                components[column - 1][row - 1] = gc = view.getGridComponent(column, row);
                if (gc == null || !(gc instanceof FormComponent)) continue;
                views.add((GridView)gc.getBeanDelegate());
            }
        }
        ColumnSpec[] flippedColSpecs = I18NUtils.flipped(colSpecs);
        for (int column = 1; column <= columnCount; ++column) {
            layout.setColumnSpec(column, flippedColSpecs[column - 1]);
        }
        Iterator i = views.iterator();
        while (i.hasNext()) {
            GridView gridView = (GridView)i.next();
            I18NUtils.flip(gridView);
        }
        for (int row = 1; row <= rowCount; ++row) {
            for (int column = 1; column <= columnCount; ++column) {
                GridComponent component = components[column - 1][row - 1];
                if (component == null) continue;
                try {
                    CellConstraints cc = view.getConstraints(component);
                    if (cc == null) continue;
                    CellConstraints flippedCC = I18NUtils.flipHorizontally(cc, columnCount);
                    view.setConstraints(component, flippedCC);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    private static ColumnSpec flipped(ColumnSpec spec) {
        FormSpec.DefaultAlignment alignment = spec.getDefaultAlignment();
        if (alignment == ColumnSpec.LEFT) {
            alignment = ColumnSpec.RIGHT;
        } else if (alignment == ColumnSpec.RIGHT) {
            alignment = ColumnSpec.LEFT;
        }
        return new ColumnSpec(alignment, spec.getSize(), spec.getResizeWeight());
    }

    private static ColumnSpec[] flipped(ColumnSpec[] original) {
        int length = original.length;
        ColumnSpec[] flipped = new ColumnSpec[length];
        for (int i = 0; i < length; ++i) {
            flipped[i] = I18NUtils.flipped(original[length - 1 - i]);
        }
        return flipped;
    }

    private static ColumnSpec[] flipped(String encodedColumnSpecs) {
        return I18NUtils.flipped(ColumnSpec.decodeSpecs(encodedColumnSpecs));
    }

    private static CellConstraints flipHorizontally(CellConstraints cc) {
        CellConstraints.Alignment flippedHAlign = cc.hAlign;
        if (flippedHAlign == CellConstraints.LEFT) {
            flippedHAlign = CellConstraints.RIGHT;
        } else if (flippedHAlign == CellConstraints.RIGHT) {
            flippedHAlign = CellConstraints.LEFT;
        }
        CellConstraints flipped = new CellConstraints(cc.gridX, cc.gridY, cc.gridWidth, cc.gridHeight, flippedHAlign, cc.vAlign);
        if (cc.insets != null) {
            flipped.insets = new Insets(cc.insets.top, cc.insets.right, cc.insets.bottom, cc.insets.left);
        }
        return flipped;
    }

    private static CellConstraints flipHorizontally(CellConstraints cc, int columnCount) {
        CellConstraints flipped = I18NUtils.flipHorizontally(cc);
        flipped.gridX = columnCount + 1 - cc.gridX - (flipped.gridWidth - 1);
        return flipped;
    }
}

