/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.open.support;

import com.jeta.open.support.ComponentFinder;
import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class CompositeComponentFinder
implements ComponentFinder {
    private LinkedList m_finders = new LinkedList();

    public CompositeComponentFinder() {
    }

    public CompositeComponentFinder(ComponentFinder finder) {
        this.add(finder);
    }

    public void add(ComponentFinder finder) {
        this.m_finders.add(finder);
    }

    public void enableComponent(String commandId, boolean bEnable) {
        Iterator iter = this.m_finders.iterator();
        while (iter.hasNext()) {
            ComponentFinder finder = (ComponentFinder)iter.next();
            Component comp = finder.getComponentByName(commandId);
            if (comp == null) continue;
            comp.setEnabled(bEnable);
        }
    }

    public Component getComponentByName(String compName) {
        Iterator iter = this.m_finders.iterator();
        while (iter.hasNext()) {
            ComponentFinder finder = (ComponentFinder)iter.next();
            Component comp = finder.getComponentByName(compName);
            if (comp == null) continue;
            return comp;
        }
        return null;
    }

    public Collection getComponentsByName(String compName) {
        LinkedList list = new LinkedList();
        Iterator iter = this.m_finders.iterator();
        while (iter.hasNext()) {
            ComponentFinder finder = (ComponentFinder)iter.next();
            list.addAll(finder.getComponentsByName(compName));
        }
        return list;
    }

    public Collection getFinders() {
        return this.m_finders;
    }

    public void reset() {
        Iterator iter = this.m_finders.iterator();
        while (iter.hasNext()) {
            ComponentFinder finder = (ComponentFinder)iter.next();
            finder.reset();
        }
    }

    public void setVisible(String commandId, boolean bVisible) {
        Iterator iter = this.m_finders.iterator();
        while (iter.hasNext()) {
            ComponentFinder finder = (ComponentFinder)iter.next();
            Component comp = finder.getComponentByName(commandId);
            if (comp == null) continue;
            comp.setVisible(bVisible);
        }
    }

    public Collection getAllNamedComponents() {
        LinkedList list = new LinkedList();
        Iterator iter = this.m_finders.iterator();
        while (iter.hasNext()) {
            ComponentFinder finder = (ComponentFinder)iter.next();
            list.addAll(finder.getAllNamedComponents());
        }
        return list;
    }
}

