/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.app;

import java.awt.Dimension;
import java.io.File;
import java.net.URL;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.pdf.lib.api.PDFDocument;
import org.gvsig.pdf.lib.api.PDFLocator;
import org.gvsig.pdf.lib.api.PDFManager;
import org.gvsig.pdf.swing.api.PDFSwingLocator;
import org.gvsig.pdf.swing.api.PDFSwingManager;
import org.gvsig.pdf.swing.api.PDFViewer;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.gvsig.tools.util.URLUtils;
import org.gvsig.webbrowser.WebBrowserPanel;

public class VCSGisHelpExtension
extends Extension {
    public void initialize() {
    }

    public void execute(String actionCommand) {
        WindowManager winmanager = ToolsSwingLocator.getWindowManager();
        I18nManager i18n = ToolsLocator.getI18nManager();
        switch (((String)StringUtils.defaultIfEmpty((CharSequence)actionCommand, (CharSequence)"")).toLowerCase()) {
            case "vcsgis-doc-post-primeros-pasos": {
                WebBrowserPanel webbrowser = ToolsUtilLocator.getWebBrowserManager().createWebBrowserPanel();
                webbrowser.asJComponent().setPreferredSize(new Dimension(900, 500));
                webbrowser.setPage("https://blog.gvsig.org/2021/06/20/vcsgis-i-usando-un-control-de-versiones-con-mi-informacion-cartografica-personal");
                winmanager.showWindow(webbrowser.asJComponent(), i18n.getTranslation("VCSGis - Primeros pasos"), WindowManager.MODE.WINDOW);
                break;
            }
            case "vcsgis-doc-userman": {
                this.showPDF(URLUtils.toFile((URL)((Object)((Object)this)).getClass().getResource("/doc/es/VCSGis Manual de usuario.pdf")), "VCSGis Manual de usuario");
                break;
            }
            case "vcsgis-doc-adminman": {
                this.showPDF(URLUtils.toFile((URL)((Object)((Object)this)).getClass().getResource("/doc/es/VCSGis Manual de administracion.pdf")), "VCSGis Manual de administraci\u00f3n");
            }
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }

    private void showPDF(File pdf, String title) {
        try {
            WindowManager winmgr = ToolsSwingLocator.getWindowManager();
            PDFSwingManager pdfSwingManager = PDFSwingLocator.getPDFSwingManager();
            PDFManager pdfManager = PDFLocator.getPDFManager();
            PDFDocument pdfdoc = pdfManager.createPDFDocument(pdf);
            PDFViewer viewer = pdfSwingManager.createPDFViewer();
            viewer.setMode(0);
            viewer.put(pdfdoc);
            winmgr.showWindow(viewer.asJComponent(), title, WindowManager.MODE.WINDOW);
        }
        catch (Exception ex) {
            logger.warn("Can't show pdf file '" + Objects.toString(pdf) + "'.", (Throwable)ex);
        }
    }
}

