/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.export.jdbc.swing.panels;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.export.jdbc.service.ExportJDBCParameters;
import org.gvsig.export.jdbc.swing.panels.SelectPkPanelLayout;
import org.gvsig.export.swing.JExportProcessPanel;
import org.gvsig.export.swing.spi.ExportPanel;
import org.gvsig.export.swing.spi.ExportPanelValidationException;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;

public class SelectPkPanel
extends SelectPkPanelLayout
implements ExportPanel {
    private static final long serialVersionUID = 2652404227373508779L;
    private final ExportJDBCParameters parameters;
    private final JExportProcessPanel processPanel;

    public SelectPkPanel(JExportProcessPanel processPanel, ExportJDBCParameters parameters) {
        this.processPanel = processPanel;
        this.parameters = parameters;
        this.initComponents();
    }

    private void initComponents() {
        this.rdoCreatePrimaryNewKey.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectPkPanel.this.onSelect();
            }
        });
        this.rdoUseExistingFieldAsPrimariKey.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectPkPanel.this.onSelect();
            }
        });
        this.rdoDoNotCreatePrimaryKey.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectPkPanel.this.onSelect();
            }
        });
        if (this.hasSourcePrimaryKey()) {
            this.rdoDoNotCreatePrimaryKey.setSelected(true);
        } else {
            this.rdoCreatePrimaryNewKey.setSelected(true);
        }
        this.translate();
    }

    private void translate() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.lblHeader.setText("<html>" + i18nManager.getTranslation("_Primary_key_header") + "</html>");
        this.lblQuestion.setText(i18nManager.getTranslation("_Desea_crear_una_clave_primaria"));
        this.rdoCreatePrimaryNewKey.setText(i18nManager.getTranslation("_Generar_una_clave_primaria_con_un_serial"));
        this.lblPrimaryKeyName.setText(i18nManager.getTranslation("_Indique_el_nombre_a_usar_para_la_clave_primaria"));
        this.rdoUseExistingFieldAsPrimariKey.setText(i18nManager.getTranslation("_Utilizar_un_campo_existente_como_clave_primaria"));
        this.lblSelectFieldAsPrimaryKey.setText(i18nManager.getTranslation("_Seleccione_el_campo_a_usar_como_clave_primaria"));
        this.rdoDoNotCreatePrimaryKey.setText(i18nManager.getTranslation("_No_hacer_nada_en_relacion_a_la_creacion_de_la_clave_primaria"));
    }

    private void onSelect() {
        if (this.rdoCreatePrimaryNewKey.isSelected()) {
            this.txtPrimaryKeyName.setEnabled(true);
            this.lstFields.setEnabled(false);
        } else if (this.rdoUseExistingFieldAsPrimariKey.isSelected()) {
            this.txtPrimaryKeyName.setEnabled(false);
            this.lstFields.setEnabled(true);
        } else if (this.rdoDoNotCreatePrimaryKey.isSelected()) {
            this.txtPrimaryKeyName.setEnabled(false);
            this.lstFields.setEnabled(false);
        }
    }

    public String getPrimaryKeyName() {
        String pkname = null;
        if (this.rdoCreatePrimaryNewKey.isSelected()) {
            pkname = this.txtPrimaryKeyName.getText();
        } else if (this.rdoUseExistingFieldAsPrimariKey.isSelected()) {
            pkname = (String)this.lstFields.getSelectedValue();
        }
        if (StringUtils.isBlank((CharSequence)pkname)) {
            return null;
        }
        return pkname.trim();
    }

    public String getIdPanel() {
        return this.getClass().getCanonicalName();
    }

    public String getTitlePanel() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("_Primary_key");
    }

    public void previousPanel() {
    }

    public void nextPanel() {
        this.parameters.setPrimaryKey(this.getPrimaryKeyName());
    }

    public boolean validatePanel() throws ExportPanelValidationException {
        return true;
    }

    private boolean hasSourcePrimaryKey() {
        FeatureType featureType = this.parameters.getSourceFeatureType();
        return !ArrayUtils.isEmpty((Object[])featureType.getPrimaryKey());
    }

    public void enterPanel() {
        this.fillListOfFields();
        if (!this.parameters.canCreatetable()) {
            this.rdoCreatePrimaryNewKey.setEnabled(false);
            this.rdoUseExistingFieldAsPrimariKey.setEnabled(false);
            this.rdoDoNotCreatePrimaryKey.setEnabled(false);
            this.rdoCreatePrimaryNewKey.setSelected(false);
            this.rdoUseExistingFieldAsPrimariKey.setSelected(false);
            this.rdoDoNotCreatePrimaryKey.setSelected(false);
        } else {
            this.rdoCreatePrimaryNewKey.setEnabled(true);
            this.rdoUseExistingFieldAsPrimariKey.setEnabled(true);
            this.rdoDoNotCreatePrimaryKey.setEnabled(true);
            if (!(this.rdoCreatePrimaryNewKey.isSelected() || this.rdoUseExistingFieldAsPrimariKey.isSelected() || this.rdoDoNotCreatePrimaryKey.isSelected())) {
                if (this.hasSourcePrimaryKey()) {
                    this.rdoDoNotCreatePrimaryKey.setSelected(true);
                } else {
                    this.rdoCreatePrimaryNewKey.setSelected(true);
                }
            }
        }
        String pkValue = this.parameters.getPrimaryKey();
        if (pkValue == null) {
            this.rdoDoNotCreatePrimaryKey.setSelected(true);
        } else {
            this.rdoCreatePrimaryNewKey.setSelected(true);
            this.txtPrimaryKeyName.setText(pkValue);
            for (int i = 0; i < this.lstFields.getModel().getSize(); ++i) {
                String element = (String)this.lstFields.getModel().getElementAt(i);
                if (!StringUtils.equals((CharSequence)element, (CharSequence)pkValue)) continue;
                this.lstFields.setSelectedIndex(i);
                this.rdoUseExistingFieldAsPrimariKey.setSelected(true);
            }
        }
    }

    public JComponent asJComponent() {
        return this;
    }

    private void fillListOfFields() {
        try {
            FeatureType sourceFeatureType = this.parameters.getSourceFeatureType();
            DefaultListModel<String> model = new DefaultListModel<String>();
            for (int i = 0; i < sourceFeatureType.size(); ++i) {
                model.addElement(sourceFeatureType.getAttributeDescriptor(i).getName());
            }
            this.lstFields.setModel(model);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

