/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.legend.urbanhorizontalsignage.app;

import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.legend.urbanhorizontalsignage.app.UrbanHorizontalSignageConfigForCopyPanel;
import org.gvsig.legend.urbanhorizontalsignage.lib.api.UrbanHorizontalSignageLocator;
import org.gvsig.legend.urbanhorizontalsignage.lib.api.UrbanHorizontalSignageManager;
import org.gvsig.legend.urbanhorizontalsignage.lib.api.linelegend.UrbanHorizontalSignageConfig;
import org.gvsig.legend.urbanhorizontalsignage.lib.api.linelegend.UrbanHorizontalSignageLegend;
import org.gvsig.legend.urbanhorizontalsignage.swing.api.ConvertLinesToPolygonsPanel;
import org.gvsig.legend.urbanhorizontalsignage.swing.api.UrbanHorizontalSignageSwingLocator;
import org.gvsig.legend.urbanhorizontalsignage.swing.api.UrbanHorizontalSignageSwingManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrbanHorizontalSignageExtension
extends Extension {
    private static final Logger LOGGER = LoggerFactory.getLogger(UrbanHorizontalSignageExtension.class);

    public void initialize() {
        IconThemeHelper.registerIcon((String)"legend", (String)"legend-overview-vectorial-urbanhorizontalsignage", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"legend", (String)"legend-overview-vectorial-picturemarkersymboltable", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layer-modify-clipboard-copy-as-polygons", (Object)((Object)this));
    }

    public void execute(String actionCommand) {
        ApplicationManager application = ApplicationLocator.getManager();
        if ("layer-modify-clipboard-copy-as-polygons".equalsIgnoreCase(actionCommand)) {
            ViewDocument viewdoc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
            if (viewdoc == null) {
                return;
            }
            MapContext mapContext = viewdoc.getMapContext();
            FLyrVect layer = mapContext.getLayers().getFirstActiveVectorLayer();
            if (layer == null) {
                return;
            }
            this.copySelecctionAsPolygons(layer);
        } else if ("tools-urbanSignage-linesToPolygons".equalsIgnoreCase(actionCommand)) {
            FeatureSelection lines;
            ViewDocument viewdoc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
            if (viewdoc == null) {
                return;
            }
            MapContext mapContext = viewdoc.getMapContext();
            FLyrVect layer = mapContext.getLayers().getFirstActiveVectorLayer();
            if (layer == null) {
                return;
            }
            if (!(layer.getLegend() instanceof UrbanHorizontalSignageLegend)) {
                return;
            }
            UrbanHorizontalSignageLegend legend = (UrbanHorizontalSignageLegend)layer.getLegend();
            UrbanHorizontalSignageConfig config = legend.getConfig();
            try {
                lines = layer.getFeatureStore().getFeatureSelection();
            }
            catch (Exception ex) {
                return;
            }
            this.convertLinesAsPolygons(config, (FeatureSet)lines);
        }
    }

    private void copySelecctionAsPolygons(FLyrVect sourceLayer) {
        UrbanHorizontalSignageConfigForCopyPanel panel = new UrbanHorizontalSignageConfigForCopyPanel();
        panel.setFeatureType(sourceLayer.getFeatureStore().getDefaultFeatureTypeQuietly());
        UrbanHorizontalSignageLegend legend = (UrbanHorizontalSignageLegend)sourceLayer.getLegend();
        panel.put(legend.getConfig());
        I18nManager i18n = ToolsLocator.getI18nManager();
        WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        Dialog theDialog = winManager.createDialog(panel.asJComponent(), i18n.getTranslation("_Copy_as_polygons"), i18n.getTranslation("_Copy_as_polygons"), 3);
        theDialog.setAutoclose(false);
        theDialog.setButtonLabel(1, i18n.getTranslation("_Accept"));
        theDialog.setButtonLabel(2, i18n.getTranslation("_Cancel"));
        theDialog.addActionListener(e -> {
            switch (theDialog.getAction()) {
                case 1: {
                    Thread task = new Thread(() -> {
                        panel.fetch(legend.getConfig());
                        this.performCopyAsPolygons(sourceLayer);
                        theDialog.asJComponent().setVisible(false);
                    }, "UHS_CopyAsPolygons");
                    task.start();
                    break;
                }
                case 2: {
                    theDialog.asJComponent().setVisible(false);
                }
            }
        });
        theDialog.show(WindowManager.MODE.DIALOG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performCopyAsPolygons(FLyrVect sourceLayer) {
        block6: {
            I18nManager i18n = ToolsLocator.getI18nManager();
            UrbanHorizontalSignageManager uhsManager = UrbanHorizontalSignageLocator.getUrbanHorizontalSignageManager();
            ApplicationManager application = ApplicationLocator.getManager();
            DataManager dataManager = DALLocator.getDataManager();
            UrbanHorizontalSignageLegend legend = (UrbanHorizontalSignageLegend)sourceLayer.getLegend();
            FeatureStore tempTargetStore = null;
            FeatureSet tempFeatureSet = null;
            try {
                FeatureSelection sourceFeatureSet = sourceLayer.getFeatureStore().getFeatureSelection();
                tempTargetStore = uhsManager.createTemporaryPolygonsFromLines(legend.getConfig(), (FeatureSet)sourceFeatureSet, false, null);
                tempFeatureSet = tempTargetStore.getFeatureSet();
                int n = application.confirmDialog("_Number_of_geometries_to_be_copied_to_the_clipboard " + tempFeatureSet.getSize() + "\n" + "_Do_you_want_to_continue", i18n.getTranslation("_Copy_selected_features_as_polygons_to_clipboard"), 0, 3);
                if (n == 0) {
                    dataManager.putFeaturesInClipboard(tempFeatureSet);
                }
                DisposeUtils.disposeQuietly((Disposable)tempTargetStore);
            }
            catch (Exception e) {
                LOGGER.warn("Can't get the selection as JSON.", (Throwable)e);
                break block6;
            }
            finally {
                DisposeUtils.disposeQuietly(tempTargetStore);
                DisposeUtils.disposeQuietly(tempFeatureSet);
            }
            DisposeUtils.disposeQuietly((Disposable)tempFeatureSet);
        }
    }

    private void convertLinesAsPolygons(UrbanHorizontalSignageConfig config, FeatureSet source) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        ApplicationManager application = ApplicationLocator.getManager();
        UrbanHorizontalSignageManager uhsManager = UrbanHorizontalSignageLocator.getUrbanHorizontalSignageManager();
        UrbanHorizontalSignageSwingManager uhsSwingManager = UrbanHorizontalSignageSwingLocator.getUrbanHorizontalSignageSwingManager();
        ConvertLinesToPolygonsPanel panel = uhsSwingManager.createConvertLinesToPolygonsPanel();
        panel.setSource(source);
        panel.put(config);
        Dialog theDialog = winManager.createDialog(panel.asJComponent(), i18n.getTranslation("_Convert_lines_to_polygons"), i18n.getTranslation("_Convert_Urban_signage_lines_to_polygons"), 3);
        theDialog.setButtonLabel(1, i18n.getTranslation("_Convert"));
        theDialog.setButtonLabel(2, i18n.getTranslation("_Close"));
        theDialog.setAutoclose(false);
        theDialog.addActionListener(e -> {
            switch (theDialog.getAction()) {
                case 1: {
                    Thread task = new Thread(() -> {
                        try {
                            theDialog.setButtonEnabled(1, false);
                            panel.setTaskStatusVisible(true);
                            uhsManager.convertLinesToPolygons(panel.getConfig(), panel.getSource(), panel.getTargetStore(), panel.getDeleteSourceAtFinish(), panel.getUseFeatureEditionValidationRules(), panel.getTaskStatus());
                            theDialog.asJComponent().setVisible(false);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Can't convert lines to polygons", (Throwable)ex);
                            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                            dialogs.messageDialog(i18n.getTranslation("_Cant_convert_lines_to_polygons") + "\n\n" + ex.getLocalizedMessage(), i18n.getTranslation("_Convert_Urban_signage_lines_to_polygons"), 2);
                        }
                    }, "UHS_ConvertLinesToPolygons");
                    task.start();
                    break;
                }
                case 2: {
                    theDialog.asJComponent().setVisible(false);
                }
            }
        });
        theDialog.show(WindowManager.MODE.WINDOW);
    }

    public boolean isEnabled() {
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument viewdoc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        if (viewdoc == null) {
            return false;
        }
        MapContext mapContext = viewdoc.getMapContext();
        FLyrVect layer = mapContext.getLayers().getFirstActiveVectorLayer();
        if (layer == null) {
            return false;
        }
        if (!layer.isAvailable()) {
            return false;
        }
        try {
            FeatureStore store = layer.getFeatureStore();
            if (store == null) {
                return false;
            }
            FeatureSelection selection = store.getFeatureSelection();
            if (selection.isEmpty()) {
                return false;
            }
            return layer.getLegend() instanceof UrbanHorizontalSignageLegend;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't get selection from layer '" + layer.getName() + "'.", (Throwable)ex);
            return false;
        }
    }

    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        return application.getActiveDocument(ViewManager.TYPENAME) != null;
    }
}

