/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial;

import org.hibernate.spatial.Log;
import org.hibernate.spatial.LogFactory;
import org.hibernate.spatial.dialect.oracle.ConnectionFinder;

public class HibernateSpatialConfiguration {
    private static final Log LOG = LogFactory.make();
    private Boolean isOgcStrict = Boolean.TRUE;
    private ConnectionFinder connectionFinder = null;

    public HibernateSpatialConfiguration() {
    }

    public HibernateSpatialConfiguration(Boolean ogcStrict, ConnectionFinder connectionFinder) {
        if (ogcStrict != null) {
            this.isOgcStrict = ogcStrict;
            LOG.info(String.format("Setting OGC_STRICT mode for Oracle Spatial dialect to %s.", ogcStrict));
        }
        if (connectionFinder != null) {
            this.connectionFinder = connectionFinder;
            LOG.info(String.format("Using ConnectionFinder implementation:  %s (only relevant for Oracle Spatial dialect).", connectionFinder.getClass().getCanonicalName()));
        }
    }

    public Boolean isOgcStrictMode() {
        return this.isOgcStrict;
    }

    public ConnectionFinder getConnectionFinder() {
        return this.connectionFinder;
    }

    public static class AvailableSettings {
        public static final String OGC_STRICT = "hibernate.spatial.ogc_strict";
        public static final String CONNECTION_FINDER = "hibernate.spatial.connection_finder";
    }
}

