/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.h2geodb;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import org.hibernate.HibernateException;
import org.hibernate.spatial.Log;
import org.hibernate.spatial.LogFactory;
import org.hibernate.spatial.dialect.AbstractJTSGeometryValueExtractor;
import org.hibernate.spatial.dialect.h2geodb.WKB;

public class GeoDBValueExtractor
extends AbstractJTSGeometryValueExtractor {
    private static Log LOG = LogFactory.make();

    @Override
    public Geometry toJTS(Object object) {
        if (object == null) {
            return null;
        }
        try {
            if (object instanceof Blob) {
                return WKB.fromWKB(this.toByteArray((Blob)object), this.getGeometryFactory());
            }
            if (object instanceof byte[]) {
                return this.geometryFromByteArray((byte[])object);
            }
            if (object instanceof Envelope) {
                return this.getGeometryFactory().toGeometry((Envelope)object);
            }
            throw new IllegalArgumentException("Can't convert database object of type " + object.getClass().getCanonicalName());
        }
        catch (Exception e) {
            LOG.warn("Could not convert database object to a JTS Geometry.");
            throw new HibernateException((Throwable)e);
        }
    }

    private Geometry geometryFromByteArray(byte[] bytes) throws ParseException {
        if (bytes[0] != 1 && bytes[0] != 0) {
            return WKB.fromEWKB(bytes, this.getGeometryFactory());
        }
        try {
            return WKB.fromWKB(bytes, this.getGeometryFactory());
        }
        catch (RuntimeException e) {
            if (e.getCause() != null && e.getCause() instanceof ParseException) {
                LOG.debug("Caught parse exception while parsing byte array as WKB. Retrying as EWKB.", e);
                return WKB.fromEWKB(bytes, this.getGeometryFactory());
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] toByteArray(Blob blob) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        InputStream in = null;
        try {
            in = blob.getBinaryStream();
            int n = 0;
            while ((n = in.read(buf)) >= 0) {
                baos.write(buf, 0, n);
            }
        }
        catch (Exception e) {
            LOG.warn("Could not convert database BLOB object to binary stream.", e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                LOG.warn("Could not close binary stream.");
            }
        }
        return baos.toByteArray();
    }
}

