/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.oracle.criterion;

import com.vividsolutions.jts.geom.Geometry;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.criterion.CriteriaQuery;
import org.hibernate.criterion.Criterion;
import org.hibernate.spatial.dialect.oracle.criterion.OracleSpatialCriterion;
import org.hibernate.spatial.dialect.oracle.criterion.RelationshipMask;
import org.hibernate.spatial.dialect.oracle.criterion.SDOParameterMap;

public class OracleSpatialRestrictions {
    public static Criterion SDOFilter(String propertyName, Geometry geom, SDOParameterMap param) {
        return new OracleSpatialCriterion(propertyName, geom, param){

            @Override
            public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
                String[] columns = criteriaQuery.getColumnsUsingProjection(criteria, this.propertyName);
                StringBuilder sql = new StringBuilder("SDO_FILTER(");
                sql.append(columns[0]).append(",").append("?");
                if (this.param != null && !this.param.isEmpty()) {
                    sql.append(",").append(this.param.toQuotedString());
                }
                sql.append(") = 'TRUE'");
                return sql.toString();
            }
        };
    }

    public static Criterion SDOFilter(String propertyName, Geometry geom, Double minResolution, Double maxResolution) {
        if (minResolution == null && maxResolution == null) {
            return OracleSpatialRestrictions.SDOFilter(propertyName, geom, null);
        }
        SDOParameterMap param = new SDOParameterMap();
        param.setMinResolution(minResolution);
        param.setMaxResolution(maxResolution);
        return OracleSpatialRestrictions.SDOFilter(propertyName, geom, param);
    }

    public static Criterion SDONN(String propertyName, Geometry geom, Double distance, Integer numResults, String unit) {
        if (distance == null && numResults == null && unit == null) {
            return OracleSpatialRestrictions.SDONN(propertyName, geom, null);
        }
        SDOParameterMap param = new SDOParameterMap();
        param.setDistance(distance);
        param.setSdoNumRes(numResults);
        param.setUnit(unit);
        return OracleSpatialRestrictions.SDONN(propertyName, geom, param);
    }

    public static Criterion SDONN(String propertyName, Geometry geom, SDOParameterMap param) {
        return new OracleSpatialCriterion(propertyName, geom, param){

            @Override
            public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
                String[] columns = criteriaQuery.getColumnsUsingProjection(criteria, this.propertyName);
                StringBuilder sql = new StringBuilder("SDO_NN(");
                sql.append(columns[0]).append(",").append("?");
                if (this.param != null && !this.param.isEmpty()) {
                    sql.append(",").append(this.param.toQuotedString());
                }
                sql.append(") = 'TRUE'");
                return sql.toString();
            }
        };
    }

    public static Criterion SDORelate(String propertyName, Geometry geom, SDOParameterMap param) {
        return new OracleSpatialCriterion(propertyName, geom, param){

            @Override
            public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
                String[] columns = criteriaQuery.getColumnsUsingProjection(criteria, this.propertyName);
                StringBuilder sql = new StringBuilder("SDO_RELATE(");
                sql.append(columns[0]).append(",").append("?");
                if (this.param != null && !this.param.isEmpty()) {
                    sql.append(",").append(this.param.toQuotedString());
                }
                sql.append(") = 'TRUE'");
                return sql.toString();
            }
        };
    }

    public static Criterion SDORelate(String propertyName, Geometry geom, RelationshipMask[] mask, Double minResolution, Double maxResolution) {
        SDOParameterMap param = new SDOParameterMap();
        param.setMask(RelationshipMask.booleanCombination(mask));
        param.setMinResolution(minResolution);
        param.setMaxResolution(maxResolution);
        return OracleSpatialRestrictions.SDORelate(propertyName, geom, param);
    }

    public static Criterion SDOWithinDistance(String propertyName, Geometry geom, SDOParameterMap param) {
        return new OracleSpatialCriterion(propertyName, geom, param){

            @Override
            public String toSqlString(Criteria criteria, CriteriaQuery criteriaQuery) throws HibernateException {
                String[] columns = criteriaQuery.getColumnsUsingProjection(criteria, this.propertyName);
                StringBuilder sql = new StringBuilder("SDO_WITHIN_DISTANCE(");
                sql.append(columns[0]).append(",").append("?");
                if (this.param != null && !this.param.isEmpty()) {
                    sql.append(",").append(this.param.toQuotedString());
                }
                sql.append(") = 'TRUE'");
                return sql.toString();
            }
        };
    }

    public static Criterion SDOWithinDistance(String propertyName, Geometry geom, Double distance, SDOParameterMap param) {
        if (param == null) {
            param = new SDOParameterMap();
        }
        param.setDistance(distance);
        return OracleSpatialRestrictions.SDOWithinDistance(propertyName, geom, param);
    }
}

