/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.sqlserver.convertors;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.spatial.dialect.sqlserver.convertors.Encoder;
import org.hibernate.spatial.dialect.sqlserver.convertors.Figure;
import org.hibernate.spatial.dialect.sqlserver.convertors.Shape;
import org.hibernate.spatial.dialect.sqlserver.convertors.SqlServerGeometry;
import org.hibernate.spatial.jts.mgeom.MGeometry;

abstract class AbstractEncoder<G extends Geometry>
implements Encoder<G> {
    AbstractEncoder() {
    }

    @Override
    public SqlServerGeometry encode(G geom) {
        SqlServerGeometry nativeGeom = new SqlServerGeometry();
        nativeGeom.setSrid(geom.getSRID());
        if (geom.isValid()) {
            nativeGeom.setIsValid();
        }
        if (this.hasMValues(geom)) {
            nativeGeom.setHasMValues();
        }
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        ArrayList<Figure> figures = new ArrayList<Figure>();
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        this.encode((Geometry)geom, -1, (List<Coordinate>)coordinates, (List<Figure>)figures, (List<Shape>)shapes);
        this.encodePoints(nativeGeom, coordinates);
        this.encodeFigures(nativeGeom, figures);
        this.encodeShapes(nativeGeom, shapes);
        return nativeGeom;
    }

    protected abstract void encode(Geometry var1, int var2, List<Coordinate> var3, List<Figure> var4, List<Shape> var5);

    protected void encodeShapes(SqlServerGeometry nativeGeom, List<Shape> shapes) {
        nativeGeom.setNumberOfShapes(shapes.size());
        for (int i = 0; i < shapes.size(); ++i) {
            nativeGeom.setShape(i, shapes.get(i));
        }
    }

    protected void encodeFigures(SqlServerGeometry nativeGeom, List<Figure> figures) {
        nativeGeom.setNumberOfFigures(figures.size());
        for (int i = 0; i < figures.size(); ++i) {
            nativeGeom.setFigure(i, figures.get(i));
        }
    }

    protected boolean hasMValues(G geom) {
        return geom instanceof MGeometry;
    }

    protected void encodePoints(SqlServerGeometry nativeGeom, List<Coordinate> coordinates) {
        nativeGeom.setNumberOfPoints(coordinates.size());
        nativeGeom.allocateMValueArray();
        for (int i = 0; i < coordinates.size(); ++i) {
            this.setCoordinate(nativeGeom, i, coordinates.get(i));
        }
    }

    protected void setCoordinate(SqlServerGeometry nativeGeom, int idx, Coordinate coordinate) {
        if (!nativeGeom.hasZValues() && !Double.isNaN(coordinate.z)) {
            nativeGeom.setHasZValues();
            nativeGeom.allocateZValueArray();
        }
        nativeGeom.setCoordinate(idx, coordinate);
    }
}

