/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.sqlserver.convertors;

import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;

public enum OpenGisType {
    POINT(1, Point.class),
    LINESTRING(2, LineString.class),
    POLYGON(3, Polygon.class),
    MULTIPOINT(4, MultiPoint.class),
    MULTILINESTRING(5, MultiLineString.class),
    MULTIPOLYGON(6, MultiPolygon.class),
    GEOMETRYCOLLECTION(7, GeometryCollection.class),
    INVALID_TYPE(0, null);

    final byte byteValue;
    final Class geomClass;

    private OpenGisType(byte v, Class geomClass) {
        this.byteValue = v;
        this.geomClass = geomClass;
    }

    boolean typeOf(Object o) {
        return this.geomClass.isAssignableFrom(o.getClass());
    }

    static OpenGisType valueOf(byte b) {
        for (OpenGisType t : OpenGisType.values()) {
            if (t.byteValue != b) continue;
            return t;
        }
        return INVALID_TYPE;
    }
}

