/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.sqlserver.convertors;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import org.hibernate.spatial.dialect.sqlserver.convertors.AbstractDecoder;
import org.hibernate.spatial.dialect.sqlserver.convertors.IndexRange;
import org.hibernate.spatial.dialect.sqlserver.convertors.OpenGisType;
import org.hibernate.spatial.dialect.sqlserver.convertors.SqlServerGeometry;
import org.hibernate.spatial.jts.mgeom.MGeometryFactory;

class PolygonDecoder
extends AbstractDecoder<Polygon> {
    public PolygonDecoder(MGeometryFactory factory) {
        super(factory);
    }

    @Override
    protected OpenGisType getOpenGisType() {
        return OpenGisType.POLYGON;
    }

    @Override
    protected Polygon createNullGeometry() {
        return this.getGeometryFactory().createPolygon(null, null);
    }

    @Override
    protected Polygon createGeometry(SqlServerGeometry nativeGeom) {
        return this.createGeometry(nativeGeom, 0);
    }

    @Override
    protected Polygon createGeometry(SqlServerGeometry nativeGeom, int shapeIndex) {
        if (nativeGeom.isEmptyShape(shapeIndex)) {
            return this.createNullGeometry();
        }
        IndexRange figureRange = nativeGeom.getFiguresForShape(shapeIndex);
        LinearRing[] holes = new LinearRing[figureRange.length() - 1];
        LinearRing shell = null;
        int i = 0;
        for (int figureIdx = figureRange.start; figureIdx < figureRange.end; ++figureIdx) {
            IndexRange pntIndexRange = nativeGeom.getPointsForFigure(figureIdx);
            if (nativeGeom.isFigureInteriorRing(figureIdx)) {
                holes[i++] = this.toLinearRing(nativeGeom, pntIndexRange);
                continue;
            }
            shell = this.toLinearRing(nativeGeom, pntIndexRange);
        }
        return this.getGeometryFactory().createPolygon(shell, holes);
    }

    private LinearRing toLinearRing(SqlServerGeometry nativeGeom, IndexRange range) {
        Coordinate[] coordinates = nativeGeom.coordinateRange(range);
        return this.getGeometryFactory().createLinearRing(coordinates);
    }
}

