/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.integration;

import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.config.spi.ConfigurationService;
import org.hibernate.service.jdbc.dialect.spi.DialectFactory;
import org.hibernate.service.spi.BasicServiceInitiator;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.spatial.HibernateSpatialConfiguration;
import org.hibernate.spatial.dialect.oracle.ConnectionFinder;
import org.hibernate.spatial.integration.SpatialDialectFactory;

public class SpatialInitiator
implements BasicServiceInitiator {
    public Class getServiceInitiated() {
        return DialectFactory.class;
    }

    public Service initiateService(Map configurationValues, ServiceRegistryImplementor registry) {
        HibernateSpatialConfiguration configuration = this.configure((ServiceRegistry)registry);
        return new SpatialDialectFactory(configuration);
    }

    private HibernateSpatialConfiguration configure(ServiceRegistry serviceRegistry) {
        ConfigurationService configService = (ConfigurationService)serviceRegistry.getService(ConfigurationService.class);
        ClassLoaderService classLoaderService = (ClassLoaderService)serviceRegistry.getService(ClassLoaderService.class);
        return new HibernateSpatialConfiguration(this.readOgcStrict(configService), this.readConnectionFinder(configService, classLoaderService));
    }

    private Boolean readOgcStrict(ConfigurationService configService) {
        String ogcStrictKey = "hibernate.spatial.ogc_strict";
        return (Boolean)configService.getSetting(ogcStrictKey, (ConfigurationService.Converter)new ConfigurationService.Converter<Boolean>(){

            public Boolean convert(Object value) {
                return Boolean.parseBoolean(value.toString());
            }
        }, null);
    }

    private ConnectionFinder readConnectionFinder(ConfigurationService configService, ClassLoaderService classLoaderService) {
        String cfKey = "hibernate.spatial.connection_finder";
        String className = (String)configService.getSetting(cfKey, (ConfigurationService.Converter)new ConfigurationService.Converter<String>(){

            public String convert(Object value) {
                if (value instanceof String) {
                    return (String)value;
                }
                return value.toString();
            }
        }, null);
        if (className == null) {
            return null;
        }
        try {
            return (ConnectionFinder)classLoaderService.classForName(className).newInstance();
        }
        catch (Exception e) {
            throw new HibernateException(" Could not instantiate ConnectionFinder: " + className, (Throwable)e);
        }
    }
}

