/*
 * Decompiled with CFR 0.152.
 */
package org.jzkit.search.util.QueryModel.CQLString;

import java.io.IOException;
import java.io.Serializable;
import org.jzkit.search.util.QueryModel.Internal.AttrPlusTermNode;
import org.jzkit.search.util.QueryModel.Internal.ComplexNode;
import org.jzkit.search.util.QueryModel.Internal.InternalModelNamespaceNode;
import org.jzkit.search.util.QueryModel.Internal.InternalModelRootNode;
import org.jzkit.search.util.QueryModel.Internal.QueryNode;
import org.jzkit.search.util.QueryModel.InvalidQueryException;
import org.jzkit.search.util.QueryModel.QueryModel;
import org.springframework.context.ApplicationContext;
import org.z3950.zing.cql.CQLAndNode;
import org.z3950.zing.cql.CQLBooleanNode;
import org.z3950.zing.cql.CQLNode;
import org.z3950.zing.cql.CQLNotNode;
import org.z3950.zing.cql.CQLOrNode;
import org.z3950.zing.cql.CQLParseException;
import org.z3950.zing.cql.CQLParser;
import org.z3950.zing.cql.CQLPrefixNode;
import org.z3950.zing.cql.CQLProxNode;
import org.z3950.zing.cql.CQLTermNode;

public class CQLString
implements QueryModel,
Serializable {
    private String the_cql_string;
    private InternalModelRootNode internal_model = null;
    private CQLNode cql_root;

    public CQLString(String the_cql_string) {
        try {
            this.the_cql_string = the_cql_string;
            CQLParser parser = new CQLParser();
            this.cql_root = parser.parse(the_cql_string);
            System.err.println("Parsed CQL");
        }
        catch (CQLParseException cqle) {
            cqle.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public CQLString(CQLNode cql_root) {
        this.cql_root = cql_root;
    }

    public InternalModelRootNode toInternalQueryModel(ApplicationContext ctx) throws InvalidQueryException {
        if (this.internal_model == null) {
            this.internal_model = new InternalModelRootNode(this.translate(this.cql_root));
        }
        return this.internal_model;
    }

    private QueryNode translate(CQLNode cql_node) {
        QueryNode result = null;
        if (cql_node instanceof CQLBooleanNode) {
            CQLBooleanNode cbn = (CQLBooleanNode)cql_node;
            if (cbn instanceof CQLAndNode) {
                result = new ComplexNode(this.translate(cbn.left), this.translate(cbn.right), 1);
            } else if (cbn instanceof CQLOrNode) {
                result = new ComplexNode(this.translate(cbn.left), this.translate(cbn.right), 2);
            } else if (cbn instanceof CQLNotNode) {
                result = new ComplexNode(this.translate(cbn.left), this.translate(cbn.right), 3);
            } else if (cbn instanceof CQLProxNode) {
                result = new ComplexNode(this.translate(cbn.left), this.translate(cbn.right), 4);
            }
        } else if (cql_node instanceof CQLTermNode) {
            System.err.println("Warning: We should properly translate the CQLTermNode");
            CQLTermNode cql_term_node = (CQLTermNode)cql_node;
            AttrPlusTermNode aptn = new AttrPlusTermNode();
            aptn.setTerm(cql_term_node.getTerm());
            aptn.setAttr("AccessPoint", cql_term_node.getQualifier());
            aptn.setAttr("Relation", cql_term_node.getRelation());
            result = aptn;
        } else if (cql_node instanceof CQLPrefixNode) {
            CQLPrefixNode pn = (CQLPrefixNode)cql_node;
            result = new InternalModelNamespaceNode(pn.prefix.name, this.translate(((CQLPrefixNode)cql_node).subtree));
        }
        return result;
    }

    public String toString() {
        return this.cql_root.toCQL();
    }
}

