/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.objects;

import java.awt.geom.Point2D;
import java.util.List;
import java.util.Map;
import org.gvsig.dwg.lib.DwgFile;
import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.IDwg2FMap;
import org.gvsig.dwg.lib.IDwg3DTestable;
import org.gvsig.dwg.lib.IDwgBlockMember;
import org.gvsig.dwg.lib.IDwgExtrusionable;
import org.gvsig.dwg.lib.util.AcadExtrusionCalculator;
import org.gvsig.dwg.lib.util.FMapUtil;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.geom.primitive.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwgArc
extends DwgObject
implements IDwgExtrusionable,
IDwg3DTestable,
IDwg2FMap,
IDwgBlockMember {
    private static Logger logger = LoggerFactory.getLogger(DwgArc.class);
    private double[] center;
    private double radius;
    private double thickness;
    private double[] extrusion;
    private double initAngle;
    private double endAngle;

    public DwgArc(int index) {
        super(index);
    }

    public double[] getCenter() {
        return this.center;
    }

    public void setCenter(double[] center) {
        this.center = center;
    }

    public double getEndAngle() {
        return this.endAngle;
    }

    public void setEndAngle(double endAngle) {
        this.endAngle = endAngle;
    }

    public double getInitAngle() {
        return this.initAngle;
    }

    public void setInitAngle(double initAngle) {
        this.initAngle = initAngle;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public double[] getExtrusion() {
        return this.extrusion;
    }

    public double getThickness() {
        return this.thickness;
    }

    public void setThickness(double thickness) {
        this.thickness = thickness;
    }

    public void setExtrusion(double[] extrusion) {
        this.extrusion = extrusion;
    }

    @Override
    public void applyExtrussion() {
        double[] arcCenter = this.getCenter();
        double[] arcExt = this.getExtrusion();
        arcCenter = AcadExtrusionCalculator.extrude2(arcCenter, arcExt);
        this.setCenter(arcCenter);
    }

    @Override
    public boolean has3DData() {
        return this.getCenter()[2] != 0.0;
    }

    @Override
    public Geometry toFMapGeometry(boolean is3DFile) throws CreateGeometryException {
        GeometryManager gMan = GeometryLocator.getGeometryManager();
        double[] center = this.getCenter();
        double radius = Math.abs(this.getRadius());
        double angSt = this.getInitAngle();
        double angEnd = this.getEndAngle();
        double angExt = FMapUtil.angleDistance(angSt, angEnd);
        Arc arc = (Arc)gMan.create(this.getGeometryType(), this.getGeometrySubType(is3DFile));
        Point point = (Point)gMan.create(1, this.getGeometrySubType(is3DFile));
        point.setCoordinates(center);
        try {
            arc.setPoints(point, radius, angSt, -angExt);
        }
        catch (IllegalArgumentException ex) {
            logger.info("Unable to create arc from points.");
            arc = null;
        }
        return arc;
    }

    @Override
    public String toString() {
        return "Arc";
    }

    @Override
    public String toFMapString(boolean is3dFile) {
        if (is3dFile) {
            return "FPolyline3D";
        }
        return "FPolyline2D";
    }

    @Override
    public double getZ() {
        return this.getCenter()[2];
    }

    @Override
    public void transform2Block(double[] bPoint, Point2D insPoint, double[] scale, double rot, List dwgObjectsWithoutBlocks, Map handleObjWithoutBlocks, DwgFile callBack) {
        double[] center = this.getCenter();
        Point2D.Double pointAux = new Point2D.Double(center[0] - bPoint[0], center[1] - bPoint[1]);
        double laX = insPoint.getX() + (((Point2D)pointAux).getX() * scale[0] * Math.cos(rot) + ((Point2D)pointAux).getY() * scale[1] * -1.0 * Math.sin(rot));
        double laY = insPoint.getY() + (((Point2D)pointAux).getX() * scale[0] * Math.sin(rot) + ((Point2D)pointAux).getY() * scale[1] * Math.cos(rot));
        double laZ = center[2] * scale[2];
        double[] transformedCenter = new double[]{laX, laY, laZ};
        double radius = this.getRadius();
        double transformedRadius = radius * scale[0];
        double initAngle = this.getInitAngle();
        double endAngle = this.getEndAngle();
        double transformedInitAngle = initAngle + rot;
        if (transformedInitAngle < 0.0) {
            transformedInitAngle += Math.PI * 2;
        } else if (transformedInitAngle > Math.PI * 2) {
            transformedInitAngle -= Math.PI * 2;
        }
        double transformedEndAngle = endAngle + rot;
        if (transformedEndAngle < 0.0) {
            transformedEndAngle += Math.PI * 2;
        } else if (transformedEndAngle > Math.PI * 2) {
            transformedEndAngle -= Math.PI * 2;
        }
        DwgArc transformedEntity = (DwgArc)this.clone();
        transformedEntity.setCenter(transformedCenter);
        transformedEntity.setRadius(transformedRadius);
        transformedEntity.setInitAngle(transformedInitAngle);
        transformedEntity.setEndAngle(transformedEndAngle);
        transformedEntity.setHandle(this.getHandle());
        dwgObjectsWithoutBlocks.add(transformedEntity);
        handleObjWithoutBlocks.put(new Integer(transformedEntity.getHandle().getOffset()), transformedEntity);
    }

    @Override
    public Object clone() {
        DwgArc obj = new DwgArc(this.index);
        this.fill(obj);
        return obj;
    }

    @Override
    protected void fill(DwgObject obj) {
        super.fill(obj);
        DwgArc myObj = (DwgArc)obj;
        myObj.setCenter(this.center);
        myObj.setEndAngle(this.endAngle);
        myObj.setExtrusion(this.extrusion);
        myObj.setInitAngle(this.initAngle);
        myObj.setRadius(this.radius);
        myObj.setThickness(this.thickness);
    }

    @Override
    public int getGeometryType() {
        return 12;
    }
}

