/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.objects;

import java.awt.geom.Point2D;
import java.util.List;
import java.util.Map;
import org.gvsig.dwg.lib.DwgFile;
import org.gvsig.dwg.lib.DwgHandleReference;
import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.IDwg2FMap;
import org.gvsig.dwg.lib.IDwg3DTestable;
import org.gvsig.dwg.lib.IDwgBlockMember;
import org.gvsig.dwg.lib.IDwgExtrusionable;
import org.gvsig.dwg.lib.util.AcadExtrusionCalculator;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Point;

public class DwgText
extends DwgObject
implements IDwgExtrusionable,
IDwg3DTestable,
IDwg2FMap,
IDwgBlockMember {
    private int dataFlag;
    private double elevation;
    private Point2D insertionPoint;
    private Point2D alignmentPoint;
    private double[] extrusion;
    private double thickness;
    private double obliqueAngle;
    private double rotationAngle;
    private double height;
    private double widthFactor;
    private String text;
    private int generation;
    private int halign;
    private int valign;
    private DwgHandleReference styleHdl;

    public DwgText(int index) {
        super(index);
    }

    public int getDataFlag() {
        return this.dataFlag;
    }

    public void setDataFlag(int dataFlag) {
        this.dataFlag = dataFlag;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public Point2D getInsertionPoint() {
        return this.insertionPoint;
    }

    public void setInsertionPoint(Point2D insertionPoint) {
        this.insertionPoint = insertionPoint;
    }

    public double getRotationAngle() {
        return this.rotationAngle;
    }

    public double getRotationAngleInDegrees() {
        int dflag = this.getDataFlag();
        if ((dflag & 8) == 0) {
            double textRot = this.getRotationAngle();
            return Math.toDegrees(textRot);
        }
        return 0.0;
    }

    public void setRotationAngle(double rotationAngle) {
        this.rotationAngle = rotationAngle;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public double getElevation() {
        return this.elevation;
    }

    public void setElevation(double elevation) {
        this.elevation = elevation;
    }

    public double getThickness() {
        return this.thickness;
    }

    public void setThickness(double thickness) {
        this.thickness = thickness;
    }

    public double[] getExtrusion() {
        return this.extrusion;
    }

    public Point2D getAlignmentPoint() {
        return this.alignmentPoint;
    }

    public void setAlignmentPoint(Point2D alignmentPoint) {
        this.alignmentPoint = alignmentPoint;
    }

    public int getGeneration() {
        return this.generation;
    }

    public void setGeneration(int generation) {
        this.generation = generation;
    }

    public int getHalign() {
        return this.halign;
    }

    public void setHalign(int halign) {
        this.halign = halign;
    }

    public double getObliqueAngle() {
        return this.obliqueAngle;
    }

    public void setObliqueAngle(double obliqueAngle) {
        this.obliqueAngle = obliqueAngle;
    }

    public int getValign() {
        return this.valign;
    }

    public void setValign(int valign) {
        this.valign = valign;
    }

    public double getWidthFactor() {
        return this.widthFactor;
    }

    public void setWidthFactor(double widthFactor) {
        this.widthFactor = widthFactor;
    }

    public void setExtrusion(double[] extrusion) {
        this.extrusion = extrusion;
    }

    @Override
    public void applyExtrussion() {
        Point2D tpoint = this.getInsertionPoint();
        double elev = this.getElevation();
        double[] textPoint = new double[]{tpoint.getX(), tpoint.getY(), elev};
        double[] textExt = this.getExtrusion();
        textPoint = AcadExtrusionCalculator.extrude2(textPoint, textExt);
        this.setInsertionPoint(new Point2D.Double(textPoint[0], textPoint[1]));
        this.setElevation(elev);
    }

    @Override
    public boolean has3DData() {
        return this.getElevation() != 0.0;
    }

    @Override
    public double getZ() {
        return this.getElevation();
    }

    @Override
    public Geometry toFMapGeometry(boolean is3DFile) throws CreateGeometryException {
        GeometryManager gMan = GeometryLocator.getGeometryManager();
        Point2D p = this.getInsertionPoint();
        double elev = 0.0;
        if ((this.getDataFlag() & 1) == 0) {
            elev = this.getElevation();
        }
        Point point = (Point)gMan.create(this.getGeometryType(), this.getGeometrySubType(is3DFile));
        point.setX(p.getX());
        point.setY(p.getY());
        if (is3DFile) {
            point.setCoordinateAt(2, elev);
        }
        return point;
    }

    @Override
    public String toFMapString(boolean is3DFile) {
        if (is3DFile) {
            return "FPoint3D";
        }
        return "FPoint2D";
    }

    @Override
    public String toString() {
        return "Text";
    }

    public void setStyleHandle(DwgHandleReference styleHdl) {
        this.styleHdl = styleHdl;
    }

    @Override
    public Object clone() {
        DwgText obj = new DwgText(this.index);
        this.fill(obj);
        return obj;
    }

    @Override
    protected void fill(DwgObject obj) {
        super.fill(obj);
        DwgText myObj = (DwgText)obj;
        myObj.setAlignmentPoint(this.alignmentPoint);
        myObj.setDataFlag(this.dataFlag);
        myObj.setElevation(this.elevation);
        myObj.setExtrusion(this.extrusion);
        myObj.setGeneration(this.generation);
        myObj.setHalign(this.halign);
        myObj.setHeight(this.height);
        myObj.setInsertionPoint(this.insertionPoint);
        myObj.setObliqueAngle(this.obliqueAngle);
        myObj.setRotationAngle(this.rotationAngle);
        myObj.setStyleHandle(this.styleHdl);
        myObj.setText(this.text);
        myObj.setThickness(this.thickness);
        myObj.setValign(this.valign);
        myObj.setWidthFactor(this.widthFactor);
    }

    @Override
    public void transform2Block(double[] bPoint, Point2D insPoint, double[] scale, double rot, List dwgObjectsWithoutBlocks, Map handle_objectsWithoutBlocks, DwgFile callBack) {
        Point2D.Double pointAux = new Point2D.Double(this.insertionPoint.getX() - bPoint[0], this.insertionPoint.getY() - bPoint[1]);
        double laX = insPoint.getX() + (((Point2D)pointAux).getX() * scale[0] * Math.cos(rot) + ((Point2D)pointAux).getY() * scale[1] * -1.0 * Math.sin(rot));
        double laY = insPoint.getY() + (((Point2D)pointAux).getX() * scale[0] * Math.sin(rot) + ((Point2D)pointAux).getY() * scale[1] * Math.cos(rot));
        Point2D.Double newInsertionPoint = new Point2D.Double(laX, laY);
        DwgText transformedEntity = (DwgText)this.clone();
        transformedEntity.setInsertionPoint(newInsertionPoint);
        if (this.alignmentPoint != null) {
            pointAux = new Point2D.Double(this.alignmentPoint.getX() - bPoint[0], this.alignmentPoint.getY() - bPoint[1]);
            laX = insPoint.getX() + (((Point2D)pointAux).getX() * scale[0] * Math.cos(rot) + ((Point2D)pointAux).getY() * scale[1] * -1.0 * Math.sin(rot));
            laY = insPoint.getY() + (((Point2D)pointAux).getX() * scale[0] * Math.sin(rot) + ((Point2D)pointAux).getY() * scale[1] * Math.cos(rot));
            Point2D.Double newAlignPoint = new Point2D.Double(laX, laY);
            transformedEntity.setAlignmentPoint(newAlignPoint);
        }
    }

    @Override
    public int getGeometryType() {
        return 1;
    }
}

