/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.dwg.lib.readers.v1314;

import java.util.ArrayList;
import org.gvsig.dwg.lib.CorruptedDwgEntityException;
import org.gvsig.dwg.lib.DwgObject;
import org.gvsig.dwg.lib.DwgUtil;
import org.gvsig.dwg.lib.objects.DwgSpline;
import org.gvsig.dwg.lib.readers.v1314.AbstractDwg1314Reader;

public class DwgSplineReader1314
extends AbstractDwg1314Reader {
    @Override
    public void readSpecificObj(int[] data, int offset, DwgObject dwgObj) throws RuntimeException, CorruptedDwgEntityException {
        int i;
        double z;
        double y;
        if (!(dwgObj instanceof DwgSpline)) {
            throw new RuntimeException("ArcReader 14 solo puede leer DwgSpline");
        }
        DwgSpline spline = (DwgSpline)dwgObj;
        int bitPos = offset;
        bitPos = this.headTailReader.readObjectHeader(data, bitPos, spline);
        ArrayList val = DwgUtil.getBitShort(data, bitPos);
        bitPos = (Integer)val.get(0);
        int scenario = (Integer)val.get(1);
        val = DwgUtil.getBitShort(data, bitPos);
        bitPos = (Integer)val.get(0);
        int degree = (Integer)val.get(1);
        spline.setDegree(degree);
        int knots = 0;
        int numCtPts = 0;
        int numFitPts = 0;
        boolean weight = false;
        switch (scenario) {
            case 2: {
                val = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)val.get(0);
                double fitTolerance = ((Integer)val.get(1)).intValue();
                spline.setFitTolerance(fitTolerance);
                val = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)val.get(0);
                double x = ((Integer)val.get(1)).intValue();
                val = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)val.get(0);
                y = ((Integer)val.get(1)).intValue();
                val = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)val.get(0);
                z = ((Integer)val.get(1)).intValue();
                spline.setBeginTanVector(new double[]{x, y, z});
                val = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)val.get(0);
                x = ((Integer)val.get(1)).intValue();
                val = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)val.get(0);
                y = ((Integer)val.get(1)).intValue();
                val = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)val.get(0);
                z = ((Integer)val.get(1)).intValue();
                spline.setEndTanVector(new double[]{x, y, z});
                val = DwgUtil.getBitShort(data, bitPos);
                bitPos = (Integer)val.get(0);
                numFitPts = (Integer)val.get(1);
                break;
            }
            case 1: {
                val = DwgUtil.testBit(data, bitPos);
                bitPos = (Integer)val.get(0);
                boolean rational = (Boolean)val.get(1);
                val = DwgUtil.testBit(data, bitPos);
                bitPos = (Integer)val.get(0);
                boolean closed = (Boolean)val.get(1);
                val = DwgUtil.testBit(data, bitPos);
                bitPos = (Integer)val.get(0);
                boolean periodic = (Boolean)val.get(1);
                val = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)val.get(0);
                double knotTolerance = (Double)val.get(1);
                spline.setKnotTolerance(knotTolerance);
                val = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)val.get(0);
                double controlTolerance = (Double)val.get(1);
                spline.setControlTolerance(controlTolerance);
                val = DwgUtil.getBitLong(data, bitPos);
                bitPos = (Integer)val.get(0);
                knots = (Integer)val.get(1);
                val = DwgUtil.getBitLong(data, bitPos);
                bitPos = (Integer)val.get(0);
                numCtPts = (Integer)val.get(1);
                val = DwgUtil.testBit(data, bitPos);
                bitPos = (Integer)val.get(0);
                weight = (Boolean)val.get(1);
                break;
            }
            default: {
                System.out.println("Unexpected spline scenario " + scenario);
            }
        }
        if (knots > 0) {
            double[] knotsArray = new double[knots];
            for (i = 0; i < knots; ++i) {
                val = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)val.get(0);
                knotsArray[i] = (Double)val.get(1);
            }
            spline.setKnotPoints(knotsArray);
        }
        if (numCtPts > 0) {
            double[][] ctrlPoint = new double[3][numCtPts];
            double[] weights = new double[numCtPts];
            for (int i2 = 0; i2 < numCtPts; ++i2) {
                val = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)val.get(0);
                double x = ((Integer)val.get(1)).intValue();
                val = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)val.get(0);
                double y2 = ((Integer)val.get(1)).intValue();
                val = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)val.get(0);
                double z2 = ((Integer)val.get(1)).intValue();
                ctrlPoint[0][i2] = x;
                ctrlPoint[1][i2] = y2;
                ctrlPoint[2][i2] = z2;
                if (!weight) continue;
                val = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)val.get(0);
                weights[i2] = ((Integer)val.get(1)).intValue();
            }
            spline.setControlPoints(ctrlPoint);
            spline.setWeights(weights);
        }
        if (numFitPts > 0) {
            double[][] fitPoint = new double[3][numCtPts];
            for (i = 0; i < numFitPts; ++i) {
                val = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)val.get(0);
                double x = ((Integer)val.get(1)).intValue();
                val = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)val.get(0);
                y = ((Integer)val.get(1)).intValue();
                val = DwgUtil.getBitDouble(data, bitPos);
                bitPos = (Integer)val.get(0);
                z = ((Integer)val.get(1)).intValue();
                fitPoint[0][i] = x;
                fitPoint[1][i] = y;
                fitPoint[2][i] = z;
            }
            spline.setFitPoints(fitPoint);
        }
        bitPos = this.headTailReader.readObjectTailer(data, bitPos, spline);
    }
}

