/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.exportto.kml.style;

import java.util.HashMap;
import java.util.Map;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.legend.IClassifiedVectorLegend;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorLegend;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.gpe.exportto.kml.style.KmlCompoundStyle;
import org.gvsig.gpe.exportto.kml.style.KmlIconStyle;
import org.gvsig.gpe.exportto.kml.style.KmlLineStyle;
import org.gvsig.gpe.exportto.kml.style.KmlPolygonStyle;
import org.gvsig.gpe.exportto.kml.style.KmlStyle;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.IFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ILineSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IPictureMarkerSymbol;
import org.gvsig.tools.dispose.DisposableIterator;

public class StyleUtils {
    public static Map<ISymbol, KmlStyle> getSymbolStyles(FLyrVect vlayer, FeatureSet fset, String[] flds) throws Exception {
        HashMap<ISymbol, KmlStyle> resp;
        block8: {
            boolean preventMarker;
            IVectorLegend leg = (IVectorLegend)vlayer.getLegend();
            resp = new HashMap<ISymbol, KmlStyle>();
            ISymbol defaultSym = leg.getDefaultSymbol();
            KmlStyle defaultStyle = StyleUtils.getStyle(defaultSym);
            if (defaultSym != null && defaultStyle != null) {
                preventMarker = !(defaultStyle instanceof KmlIconStyle);
                KmlCompoundStyle cs = new KmlCompoundStyle();
                cs.addStyle(defaultStyle);
                if (preventMarker) {
                    cs.addStyle(new KmlIconStyle());
                }
                cs.setId("defaultStyle");
                resp.put(defaultSym, cs);
            }
            if (!(leg instanceof IClassifiedVectorLegend)) break block8;
            IClassifiedVectorLegend cLeg = (IClassifiedVectorLegend)leg;
            ISymbol[] symbolsAux = cLeg.getSymbols();
            if (fset == null || (long)symbolsAux.length < fset.getSize()) {
                for (int i = 0; i < symbolsAux.length; ++i) {
                    ISymbol s = symbolsAux[i];
                    KmlStyle style = StyleUtils.getStyle(s);
                    if (s == null || style == null) continue;
                    preventMarker = !(style instanceof KmlIconStyle);
                    KmlCompoundStyle cs = new KmlCompoundStyle();
                    cs.addStyle(style);
                    if (preventMarker) {
                        cs.addStyle(new KmlIconStyle());
                    }
                    cs.setId(Integer.toString(i));
                    resp.put(s, cs);
                }
            } else {
                DisposableIterator diter = fset.fastIterator();
                int ind = 0;
                while (diter.hasNext()) {
                    Feature feat = (Feature)diter.next();
                    ISymbol s = leg.getSymbolByFeature(feat);
                    KmlStyle style = StyleUtils.getStyle(s);
                    if (s == null || style == null) continue;
                    preventMarker = !(style instanceof KmlIconStyle);
                    KmlCompoundStyle cs = new KmlCompoundStyle();
                    cs.addStyle(style);
                    if (preventMarker) {
                        cs.addStyle(new KmlIconStyle());
                    }
                    cs.setId(Integer.toString(ind));
                    resp.put(s, cs);
                    ++ind;
                }
            }
        }
        return resp;
    }

    public static KmlStyle getStyle(ISymbol s) {
        if (s == null) {
            return null;
        }
        if (s instanceof IPictureMarkerSymbol) {
            IPictureMarkerSymbol pms = (IPictureMarkerSymbol)s;
            String str = pms.getSource().toString();
            if (str != null && str.indexOf("http") == 0) {
                KmlIconStyle icoStyle = new KmlIconStyle();
                icoStyle.setColor(((IMarkerSymbol)s).getColor());
                icoStyle.setHref(str);
                float angKml = (float)StyleUtils.radToKmlDeg(((IMarkerSymbol)s).getRotation());
                icoStyle.setHeading(angKml);
                return icoStyle;
            }
            return null;
        }
        if (s instanceof ILineSymbol) {
            ILineSymbol lSym = (ILineSymbol)s;
            KmlLineStyle lStyle = new KmlLineStyle();
            lStyle.setColor(lSym.getColor());
            lStyle.setWidth((float)lSym.getLineWidth());
            return lStyle;
        }
        if (s instanceof IFillSymbol) {
            IFillSymbol fSym = (IFillSymbol)s;
            KmlCompoundStyle cStyle = new KmlCompoundStyle();
            KmlLineStyle lStyle = new KmlLineStyle();
            ILineSymbol lSym = fSym.getOutline();
            lStyle.setColor(lSym.getColor());
            lStyle.setWidth((float)lSym.getLineWidth());
            KmlPolygonStyle fStyle = new KmlPolygonStyle();
            fStyle.setColor(fSym.getFillColor());
            fStyle.setOutline(fSym.hasOutline());
            fStyle.setFill(fSym.hasFill());
            cStyle.addStyle(lStyle);
            cStyle.addStyle(fStyle);
            return cStyle;
        }
        return null;
    }

    public static double kmlDegToRad(double angleDegree) {
        double deg = 90.0 - angleDegree;
        return Math.toRadians(deg);
    }

    public static double radToKmlDeg(double rad) {
        double angleDegree = Math.toDegrees(rad);
        double deg = 90.0 - angleDegree;
        if (deg >= 360.0) {
            deg -= 360.0;
        }
        if (deg < 0.0) {
            deg += 360.0;
        }
        return deg;
    }
}

