/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wms.app.wmsclient.gui.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.tree.TreePath;
import org.apache.commons.io.IOUtils;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.persistence.serverData.ServerDataPersistence;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.gui.WizardPanel;
import org.gvsig.app.gui.wizards.WizardListener;
import org.gvsig.app.gui.wizards.WizardListenerSupport;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.downloader.swing.DownloaderConfigController;
import org.gvsig.downloader.swing.DownloaderSwingLocator;
import org.gvsig.downloader.swing.DownloaderSwingManager;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataParameters;
import org.gvsig.fmap.dal.DataServerExplorerParameters;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.exception.ConnectException;
import org.gvsig.fmap.dal.coverage.exception.RemoteServiceException;
import org.gvsig.fmap.dal.coverage.store.parameter.TileDataParameters;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ProviderNotRegisteredException;
import org.gvsig.fmap.dal.exception.ValidateDataParametersException;
import org.gvsig.fmap.mapcontext.exceptions.LoadLayerException;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.gui.beans.Messages;
import org.gvsig.raster.cache.tile.TileCacheLibrary;
import org.gvsig.raster.util.CancelTaskImpl;
import org.gvsig.raster.wms.app.wmsclient.WMSClientExtension;
import org.gvsig.raster.wms.app.wmsclient.gui.panel.WMSParamsPanel;
import org.gvsig.raster.wms.app.wmsclient.gui.wizard.ComboServerController;
import org.gvsig.raster.wms.app.wmsclient.gui.wizard.WMSWizardView;
import org.gvsig.raster.wms.io.RemoteWMSStyle;
import org.gvsig.raster.wms.io.WMSDataParameters;
import org.gvsig.raster.wms.io.WMSLayerNode;
import org.gvsig.raster.wms.io.WMSServerExplorer;
import org.gvsig.raster.wms.io.WMSServerExplorerParameters;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.utils.swing.jcomboServer.ServerData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WMSWizard
extends WizardPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(WMSWizard.class);
    private final String serversPropsFilename = "servers.properties";
    protected int page = 0;
    protected boolean connected = false;
    private ComboServerController cmbHost = null;
    protected WizardListenerSupport listenerSupport = null;
    protected WMSParamsPanel wmsParamsPanel = null;
    private boolean usingTileCache = fPrefs.getBoolean("tile_cache", false);
    private static final Preferences fPrefs = Preferences.userRoot().node("gvsig.wms-wizard");
    protected int firstPage = 0;
    private IProjection proj = null;
    private ICancellable cancel = null;
    private WMSDataParameters storeParams = null;
    private WMSServerExplorer explorer = null;
    private WMSWizardView view = null;
    private DownloaderConfigController downloaderController;
    private PluginServices plugin = null;

    public WMSWizard() {
        IWindow[] windows;
        this.page = this.firstPage = 0;
        this.initialize();
        for (IWindow window : windows = PluginServices.getMDIManager().getAllWindows()) {
            if (!(window instanceof AbstractViewPanel)) continue;
            this.proj = ((AbstractViewPanel)window).getProjection();
        }
        this.cancel = new CancelTaskImpl();
    }

    private void initialize() {
        this.view = new WMSWizardView();
        DownloaderSwingManager downloaderSwingManager = DownloaderSwingLocator.getDownloaderSwingManager();
        PluginsManager pluginsManager = PluginsLocator.getManager();
        this.plugin = pluginsManager.getPlugin(WMSClientExtension.class);
        this.setTabName("WMS");
        this.view.lblServerType.setText(PluginServices.getText((Object)this, (String)"server_type") + ":");
        this.view.lblServerTypeValue.setText("-");
        this.view.btnConnect.setText(PluginServices.getText((Object)this, (String)"conectar"));
        this.view.btnConnect.addActionListener(this);
        this.view.btnCancel.setText(PluginServices.getText((Object)this, (String)"cancel"));
        this.view.btnCancel.addActionListener(this);
        this.view.jLabel1.setText(PluginServices.getText((Object)this, (String)"name") + ":");
        this.view.btnSiguiente.setText(PluginServices.getText((Object)this, (String)"siguiente"));
        this.view.btnSiguiente.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WMSWizard.this.page == WMSWizard.this.firstPage && WMSWizard.this.getChkTileCache().isSelected()) {
                    WMSWizard.messageBoxInfo("remote_service_tiled", TileCacheLibrary.ALTERNATIVE_TILESIZE + "", this);
                }
                if (WMSWizard.this.page > WMSWizard.this.firstPage) {
                    WMSWizard.this.getWMSParamsPanel().avanzaTab();
                    WMSWizard.this.page = WMSWizard.this.getWMSParamsPanel().currentPage();
                }
                ++WMSWizard.this.page;
                WMSWizard.this.getPanelPage1().setVisible(false);
                WMSWizard.this.getWMSParamsPanel().setVisible(true);
                WMSWizard.this.activarVisualizarBotones();
            }
        });
        this.view.btnAnterior.setText(PluginServices.getText((Object)this, (String)"anterior"));
        this.view.btnAnterior.addActionListener(e -> {
            --this.page;
            if (this.page > this.firstPage) {
                this.getWMSParamsPanel().retrocedeTab();
                this.page = this.getWMSParamsPanel().currentPage() + 1;
                this.activarVisualizarBotones();
                this.view.btnCancel.setEnabled(true);
                this.view.btnConnect.setEnabled(true);
            } else if (this.page == this.firstPage) {
                this.activarVisualizarBotones();
                this.page = this.firstPage + 1;
                this.getLblTitle().setText("-");
                this.getTxtAbstract().setText("");
                this.getWMSParamsPanel().retrocedeTab();
                this.getPanelPage1().setVisible(true);
                this.getWMSParamsPanel().setVisible(false);
                this.getBtnSiguiente().setEnabled(false);
                this.connected = false;
            }
            this.getWizardListenerSupport().callStateChanged(this.getWMSParamsPanel().isCorrectlyConfigured());
        });
        this.view.chkCaching.setText(PluginServices.getText((Object)this, (String)"refresh_capabilities"));
        this.view.chkCaching.setToolTipText(PluginServices.getText((Object)this, (String)"refresh_capabilities_tooltip"));
        this.view.chkCaching.setSelected(this.getWMSParamsPanel().isUpdatingCache());
        this.view.chkCaching.addItemListener(e -> this.getWMSParamsPanel().setUpdatingCache(this.view.chkCaching.isSelected()));
        this.view.chkCaching.addActionListener(e -> fPrefs.putBoolean("refresh_capabilities", this.view.chkCaching.isSelected()));
        this.view.chkTileCache.setText(PluginServices.getText((Object)this, (String)"tile_cache"));
        this.view.chkTileCache.setToolTipText(PluginServices.getText((Object)this, (String)"tile_cache_tooltip"));
        this.view.chkTileCache.setSelected(this.usingTileCache);
        this.view.chkTileCache.addItemListener(e -> {
            this.usingTileCache = this.view.chkTileCache.isSelected();
        });
        this.view.chkTileCache.addActionListener(e -> fPrefs.putBoolean("tile_cache", this.view.chkTileCache.isSelected()));
        this.view.chkAxisOrder.setText(PluginServices.getText((Object)this, (String)"Assume_coordinates_follow_XY_axis_order"));
        this.view.chkAxisOrder.setToolTipText(PluginServices.getText((Object)this, (String)"Only_needed_for_servers_not_strictly_honouring_the_WMS_standard"));
        this.cmbHost = new ComboServerController(this.view.cmbHost);
        this.cmbHost.setModel(new DefaultComboBoxModel());
        this.cmbHost.setServerList(this.getServerDataPersistence().getArrayOfServerData());
        this.downloaderController = downloaderSwingManager.createDownloaderConfigController(() -> {
            URL host = this.getHost();
            if (host == null) {
                return null;
            }
            return host.toExternalForm();
        }, this.view.btnDownloaderAddService, this.view.btnDownloaderAdmin);
        this.setPreferredSize(new Dimension(750, 420));
        this.setLayout(new BorderLayout());
        JPanel panelPages = new JPanel();
        panelPages.setLayout(new GridBagLayout());
        panelPages.add((Component)this.getPanelPage1(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelPages.add((Component)((Object)this.getWMSParamsPanel()), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(panelPages, "Center");
        this.add(this.view.pnlSiguineteAnterior, "South");
        this.getWMSParamsPanel().setVisible(false);
        this.activarVisualizarBotones();
    }

    protected WMSParamsPanel getWMSParamsPanel() {
        if (this.wmsParamsPanel == null) {
            this.wmsParamsPanel = new WMSParamsPanel();
            this.wmsParamsPanel.setListenerSupport(this.getWizardListenerSupport());
            this.wmsParamsPanel.getJTabbedPane().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    WMSWizard.this.page = WMSWizard.this.wmsParamsPanel.currentPage() + 1;
                    WMSWizard.this.activarVisualizarBotones();
                }
            });
        }
        return this.wmsParamsPanel;
    }

    public boolean areSettingsValid() {
        return this.getWMSParamsPanel().isCorrectlyConfigured();
    }

    private boolean checkHostAndNetwork() {
        if (!this.explorer.isHostReachable()) {
            JOptionPane.showMessageDialog(null, Messages.getText((String)"host_unreachable"), Messages.getText((String)"Error"), 0);
            return false;
        }
        return true;
    }

    private void rellenarControles() {
        try {
            this.view.lblTitle.setText(this.explorer.getTitle());
            this.view.lblServerTypeValue.setText(this.explorer.getServerType());
            this.view.txtAbstract.setText(this.explorer.getAbstract());
            this.getWMSParamsPanel().setWizardData(this.explorer);
            this.connected = true;
            this.activarVisualizarBotones();
        }
        catch (Exception e) {
            if (e.getMessage() == null) {
                this.view.txtAbstract.setText(PluginServices.getText((Object)this, (String)"error"));
            } else {
                this.view.txtAbstract.setText(e.getMessage());
            }
            this.getWizardListenerSupport().callError(e);
            this.getBtnSiguiente().setEnabled(false);
            this.getBtnAnterior().setEnabled(true);
        }
        finally {
            this.getBtnCancel().setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.getBtnConnect()) {
            this.getBtnCancel().setEnabled(true);
            this.getTxtAbstract().setText("Trying to connect...");
            String host = this.view.cmbHost.getModel().getSelectedItem().toString();
            try {
                DataManager datamanager = DALLocator.getDataManager();
                WMSServerExplorerParameters explorerParams = (WMSServerExplorerParameters)datamanager.createServerExplorerParameters(WMSServerExplorer.NAME);
                explorerParams.setXyAxisOrder(this.getChkAxisOrder().isSelected());
                explorerParams.setHost(host);
                this.explorer = (WMSServerExplorer)datamanager.createServerExplorer((DataServerExplorerParameters)explorerParams);
                ((CancelTaskImpl)this.cancel).setCanceled(false);
                new ConnectThread(this.cancel, this.explorer, this).start();
            }
            catch (InitializeException e1) {
                this.getTxtAbstract().setText("Error creating WMS layer");
            }
            catch (ProviderNotRegisteredException e1) {
                this.getTxtAbstract().setText("Provider not registered. I cannot connect.");
            }
            catch (ValidateDataParametersException e1) {
                this.getTxtAbstract().setText("Parameters not valid. I cannot connect.");
            }
        }
        if (e.getSource() == this.getBtnCancel()) {
            this.getTxtAbstract().setText("Cancelled...");
            ((CancelTaskImpl)this.cancel).setCanceled(true);
            this.getBtnCancel().setEnabled(false);
            this.getBtnConnect().setEnabled(true);
        }
    }

    protected void activarVisualizarBotones() {
        if (this.page == this.firstPage) {
            this.getBtnAnterior().setEnabled(false);
            this.getBtnSiguiente().setVisible(true);
            if (this.connected) {
                this.getBtnSiguiente().setEnabled(true);
            } else {
                this.getBtnSiguiente().setEnabled(false);
            }
        } else if (this.page < this.getWMSParamsPanel().getNumTabs()) {
            this.getBtnSiguiente().setEnabled(true);
            this.getBtnSiguiente().setVisible(true);
            this.getBtnAnterior().setEnabled(true);
            this.getBtnAnterior().setVisible(true);
            if (this.getWMSParamsPanel().nextEnabledPage() == -1) {
                this.getBtnSiguiente().setEnabled(false);
            }
            this.getWizardListenerSupport().callStateChanged(this.getWMSParamsPanel().isCorrectlyConfigured());
        } else if (this.page == this.getWMSParamsPanel().getNumTabs()) {
            this.getBtnSiguiente().setVisible(true);
            this.getBtnSiguiente().setEnabled(false);
            this.getWizardListenerSupport().callStateChanged(this.getWMSParamsPanel().isCorrectlyConfigured());
        }
    }

    private ComboServerController getTxtHost() {
        return this.cmbHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private ServerDataPersistence getServerDataPersistence() {
        ServerDataPersistence servers;
        block8: {
            DynObject pluginProperties = this.plugin.getPluginProperties();
            servers = (ServerDataPersistence)pluginProperties.getDynValue("servers");
            if (servers != null && !servers.isEmpty()) break block8;
            if (servers == null) {
                servers = new ServerDataPersistence("WMS");
                pluginProperties.setDynValue("servers", (Object)servers);
            }
            Properties prop = new Properties();
            File propFile = new File(this.plugin.getPluginDirectory(), "servers.properties");
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(propFile);
                prop.load(fis);
            }
            catch (FileNotFoundException e) {
                logger.info("Properties file '" + propFile.getAbsolutePath() + "' not found", (Throwable)e);
                IOUtils.closeQuietly((InputStream)fis);
            }
            catch (IOException e2) {
                logger.info("Error reading properties file '" + propFile.getAbsolutePath() + "'.", (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fis);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)fis);
            }
            IOUtils.closeQuietly((InputStream)fis);
            for (int i = 0; i < prop.size(); ++i) {
                Object value = prop.get("server[" + i + "]");
                servers.addServerData(new ServerData(value.toString(), "WMS"));
            }
        }
        return servers;
    }

    private void saveServerListFromComboBox() {
        ServerDataPersistence persistence = this.getServerDataPersistence();
        String urlSelected = this.getTxtHost().getModel().getSelectedItem().toString();
        boolean isSelectedInModel = false;
        for (int i = 0; i < this.getTxtHost().getItemCount(); ++i) {
            String url = this.getTxtHost().getItemAt(i).toString();
            persistence.addServerData(new ServerData(url, "WMS"));
            if (!url.equals(urlSelected)) continue;
            isSelectedInModel = true;
        }
        if (!isSelectedInModel) {
            persistence.addServerData(new ServerData(urlSelected, "WMS"));
        }
    }

    private JButton getBtnConnect() {
        return this.view.btnConnect;
    }

    private JButton getBtnCancel() {
        return this.view.btnCancel;
    }

    private JLabel getLblTitle() {
        return this.view.lblTitle;
    }

    private JTextArea getTxtAbstract() {
        return this.view.txtAbstract;
    }

    private JPanel getPanelPage1() {
        return this.view.panelPage1;
    }

    private JButton getBtnSiguiente() {
        return this.view.btnSiguiente;
    }

    public static void messageBoxInfo(String msg, String fixedText, Object parentWindow) {
        String string = PluginServices.getText((Object)parentWindow, (String)"accept");
        Object[] options = new Object[]{string};
        JOptionPane.showOptionDialog((Component)PluginServices.getMainFrame(), "<html>" + PluginServices.getText((Object)parentWindow, (String)msg).replaceAll("\n", "<br>") + " " + fixedText + "</html>", PluginServices.getText((Object)parentWindow, (String)"confirmacion"), 0, 1, null, options, string);
    }

    private JButton getBtnAnterior() {
        return this.view.btnAnterior;
    }

    private WizardListenerSupport getWizardListenerSupport() {
        if (this.listenerSupport == null) {
            this.listenerSupport = new WizardListenerSupport();
        }
        return this.listenerSupport;
    }

    public void addWizardListener(WizardListener listener) {
        this.getWizardListenerSupport().addWizardListener(listener);
        this.getWizardListenerSupport().callStateChanged(false);
    }

    public void removeWizardListener(WizardListener listener) {
        this.getWizardListenerSupport().removeWizardListener(listener);
    }

    public String getSRS() {
        return this.getWMSParamsPanel().getSRS();
    }

    public String getFormat() {
        return this.getWMSParamsPanel().getFormat();
    }

    public String getInfoFormat() {
        return this.getWMSParamsPanel().getInfoFormat();
    }

    public TreePath[] getSelectedLayers() {
        return this.getWMSParamsPanel().getSelectedLayers();
    }

    public URL getHost() {
        try {
            if (this.view.cmbHost == null || this.view.cmbHost.getModel().getSelectedItem() == null) {
                return new URL(this.explorer.getHost());
            }
            return new URL(this.view.cmbHost.getModel().getSelectedItem().toString());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public String getLayerName() {
        return this.getWMSParamsPanel().getLayerName();
    }

    public void initWizard() {
    }

    public void execute() {
        try {
            FLayer layer = this.getLayer();
            if (layer == null) {
                return;
            }
            this.getMapCtrl().getMapContext().getLayers().addLayer(layer);
        }
        catch (InitializeException e) {
            LoggerFactory.getLogger(this.getClass()).info(PluginServices.getText((Object)this, (String)"The layer cannot be added"), (Throwable)e);
        }
    }

    protected String getLayersQuery() {
        return this.getWMSParamsPanel().getLayersQuery();
    }

    public FLayer getAllLayers() throws LoadLayerException {
        return this.getWMSParamsPanel().getAllLayers();
    }

    public synchronized FLayer getLayer() throws InitializeException {
        return this.getWMSParamsPanel().getLayer(this.getChkTileCache().isSelected());
    }

    protected boolean nodeSelected(TreePath[] selection, WMSLayerNode node) {
        for (TreePath selection1 : selection) {
            Object[] components;
            for (Object component : components = selection1.getPath()) {
                if (!(component instanceof WMSLayerNode) || ((WMSLayerNode)component).getTitle().compareTo(node.getTitle()) != 0) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isQueryable() {
        return this.explorer.isQueryable();
    }

    protected Dimension getFixedSize() {
        return this.getWMSParamsPanel().getFixedSize();
    }

    protected Vector<RemoteWMSStyle> getStyles() {
        return this.getWMSParamsPanel().getStyles();
    }

    protected Vector getDimensions() {
        return this.getWMSParamsPanel().getDimensions();
    }

    protected boolean getTransparency() {
        return this.getWMSParamsPanel().getTransparency();
    }

    public String getQueryableLayerQuery() {
        return this.getWMSParamsPanel().getQueryableLayerQuery();
    }

    private JCheckBox getChkTileCache() {
        return this.view.chkTileCache;
    }

    private JCheckBox getChkAxisOrder() {
        return this.view.chkAxisOrder;
    }

    public DataStoreParameters[] getParameters() {
        return null;
    }

    public void close() {
    }

    public class ConnectThread
    extends Thread {
        private ICancellable cancel = null;
        private WMSServerExplorer explorer = null;
        private WMSWizard wizard = null;

        public ConnectThread(ICancellable cancel, WMSServerExplorer explorer, WMSWizard wizard) {
            this.cancel = cancel;
            this.explorer = explorer;
            this.wizard = wizard;
        }

        @Override
        public void run() {
            DataParameters p;
            if (!WMSWizard.this.checkHostAndNetwork()) {
                return;
            }
            WMSWizard.this.getBtnConnect().setEnabled(false);
            try {
                this.explorer.connect(this.cancel, WMSWizard.this.getWMSParamsPanel().isUpdatingCache());
                WMSWizard.this.saveServerListFromComboBox();
            }
            catch (ConnectException e) {
                String msg = e.getMessage() + " : " + this.getIOExceptionMessage((Exception)((Object)e));
                if (msg != null) {
                    LoggerFactory.getLogger(this.getClass()).info(msg, (Throwable)e);
                    JOptionPane.showMessageDialog((Component)((Object)WMSWizard.this.getWMSParamsPanel()), msg, Messages.getText((String)"Error"), 0);
                } else {
                    LoggerFactory.getLogger(this.getClass()).info("RemoteServiceException", (Throwable)e);
                }
                return;
            }
            finally {
                ((CancelTaskImpl)this.cancel).setCanceled(false);
            }
            DataStoreParameters parameters = this.explorer.getStoredParameters();
            if (parameters instanceof WMSDataParameters) {
                WMSWizard.this.storeParams = (WMSDataParameters)parameters;
            }
            if (parameters instanceof TileDataParameters && (p = ((TileDataParameters)parameters).getDataParameters()) instanceof WMSDataParameters) {
                WMSWizard.this.storeParams = (WMSDataParameters)p;
            }
            this.wizard.rellenarControles();
        }

        private String getIOExceptionMessage(Exception e) {
            Throwable ex = e;
            int MAX_DEEP = 10;
            for (int deep = 0; deep < 10; ++deep) {
                Throwable t = null;
                if (ex instanceof IOException) {
                    return ex.getMessage();
                }
                if (ex instanceof RemoteServiceException) {
                    t = ex.getCause();
                }
                if (t == null) {
                    return null;
                }
                ex = t;
            }
            return null;
        }
    }
}

