/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wms.app.wmsclient.infobypoint;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserControl {
    private static Logger logger = LoggerFactory.getLogger((String)BrowserControl.class.getName());
    private static final String WIN_ID = "Windows";
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    public static final String OPERA = "Opera";
    public static final String NETSCAPE = "Netscape";
    public static final String MOZILLA = "Mozilla";
    public static final String GALEON = "Galeon";
    public static final String EPIPHANY = "Epiphany";
    public static final String FIREFOX = "Firefox";
    public static final String CHROME = "google-chrome";
    public static final String KONQUEROR = "Konqueror";
    private String browserCommand = "Firefox";
    private List<String> supportedBrowsers;

    private boolean throwBrowser(String browser, String url) {
        String url1 = url.replace("'", "'");
        String url2 = "'" + url.replace("'", "'") + "'";
        int exitCode = -1;
        String cmd = null;
        Process p = null;
        try {
            cmd = browser.toLowerCase() + " " + url1;
            logger.info("Trying..." + cmd);
            p = this.exec(cmd);
            exitCode = p.waitFor();
        }
        catch (IOException e) {
            exitCode = -1;
        }
        catch (InterruptedException e) {
            logger.info("Error bringing up browser, cmd='" + cmd + "'");
        }
        try {
            if (exitCode != 0) {
                cmd = browser.toLowerCase() + " " + url2;
                logger.info("Trying..." + cmd);
                p = this.exec(cmd);
                exitCode = p.waitFor();
            }
        }
        catch (IOException e) {
            exitCode = -1;
        }
        catch (InterruptedException x) {
            logger.info("Error bringing up browser, cmd='" + cmd + "'");
        }
        return exitCode == 0;
    }

    public void displayURL(String url) {
        boolean windows = BrowserControl.isWindowsPlatform();
        String cmd = null;
        try {
            if (windows) {
                cmd = "rundll32 url.dll,FileProtocolHandler " + url;
                Runtime.getRuntime().exec(cmd);
            } else {
                if (this.throwBrowser(this.browserCommand, url)) {
                    return;
                }
                boolean throwed = false;
                for (int i = 0; i < this.getSupportedBrowsers().size() && !throwed; ++i) {
                    throwed = this.throwBrowser(this.getSupportedBrowsers().get(i), url);
                }
            }
        }
        catch (IOException x) {
            logger.warn("Could not invoke browser, command=" + cmd);
            logger.info("Caught: " + x);
        }
    }

    private Process exec(String cmd) throws IOException {
        logger.info(cmd);
        return Runtime.getRuntime().exec(cmd);
    }

    public static boolean isWindowsPlatform() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith(WIN_ID);
    }

    public List<String> getSupportedBrowsers() {
        if (this.supportedBrowsers == null) {
            this.supportedBrowsers = new ArrayList<String>();
            this.supportedBrowsers.add(CHROME);
            this.supportedBrowsers.add(FIREFOX);
            this.supportedBrowsers.add(KONQUEROR);
            this.supportedBrowsers.add(EPIPHANY);
            this.supportedBrowsers.add(MOZILLA);
            this.supportedBrowsers.add(NETSCAPE);
            this.supportedBrowsers.add(OPERA);
        }
        return this.supportedBrowsers;
    }
}

