/*
 * Decompiled with CFR 0.152.
 */
package thing;

import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import thing.Settings;
import thing.ThinletDTD;
import thing.ThinletWorkarounds;
import thinlet.Thinlet;
import utils.AWTUtils;

public class PropertyManager {
    private static final Logger log = Logger.getLogger("thing");
    private Thinlet thinlet;
    private PropertyMap map = new PropertyMap();

    private static final boolean debug() {
        return log.isLoggable(Level.FINE);
    }

    public PropertyManager(Thinlet thinlet) {
        this.thinlet = thinlet;
    }

    public Object getValue(Object component, ThinletDTD.Property property) {
        String key = property.getName();
        switch (property.getType()) {
            case 0: {
                return this.thinlet.getString(component, key);
            }
            case 2: {
                if (property == ThinletDTD.getProperty("dialog", "modal")) {
                    Object value = this.map.getValue(component, property);
                    return value != null ? value : Boolean.FALSE;
                }
                if (property == ThinletDTD.getProperty("dialog", "closable")) {
                    return property.getDefaultValue();
                }
                try {
                    return new Boolean(this.thinlet.getBoolean(component, key));
                }
                catch (Throwable e) {
                    log.warning("getValue() can't access to boolean property '" + key + "'.");
                    return Boolean.FALSE;
                }
            }
            case 1: {
                return new Integer(this.thinlet.getInteger(component, key));
            }
            case 3: {
                return this.thinlet.getChoice(component, key);
            }
            case 4: {
                return ThinletWorkarounds.getColor(component, key);
            }
            case 5: {
                return this.thinlet.getIcon(component, key);
            }
            case 6: {
                Font font = ThinletWorkarounds.getFont(component, key);
                return font != null ? AWTUtils.getFontString(font, this.thinlet.getFont()) : "";
            }
            case 7: {
                AWTKeyStroke keystroke = ThinletWorkarounds.getKeystroke(component, key);
                return keystroke != null ? AWTUtils.getAWTKeyStrokeDescription(keystroke) : null;
            }
            case 10: {
                StringBuffer buf = new StringBuffer();
                Enumeration enumx = ThinletWorkarounds.getPropertyKeys(component);
                while (enumx.hasMoreElements()) {
                    String propkey = (String)enumx.nextElement();
                    String value = this.thinlet.getProperty(component, (Object)propkey).toString();
                    buf.append(propkey).append('=').append(value);
                    if (!enumx.hasMoreElements()) continue;
                    buf.append(';');
                }
                return buf.toString();
            }
            case 8: 
            case 11: {
                return this.map.getValueString(component, property);
            }
            case 9: {
                return "";
            }
        }
        throw new IllegalArgumentException("unknown property type: " + property.getType());
    }

    public Object getValue(Object component, String propName) {
        return this.getValue(component, PropertyManager.getProperty(component, propName));
    }

    public String getValueString(Object component, ThinletDTD.Property property) {
        if (property.getType() == 5) {
            return this.map.getValueString(component, property);
        }
        Object obj = this.getValue(component, property);
        return PropertyManager.value2string(obj);
    }

    public String getValueString(Object component, String propName) {
        return this.getValueString(component, PropertyManager.getProperty(component, propName));
    }

    public void setValue(Object component, String propName, String value) {
        this.setValue(component, PropertyManager.getProperty(component, propName), value);
    }

    public void setValue(Object component, ThinletDTD.Property property, String value) {
        String key = property.getName();
        switch (property.getType()) {
            case 0: {
                this.thinlet.setString(component, key, value);
                break;
            }
            case 2: {
                boolean b = false;
                if ("true".equals(value)) {
                    b = true;
                } else if ("false".equals(value)) {
                    b = false;
                } else {
                    throw new IllegalArgumentException("value not allowed for boolean property " + key + ": " + value);
                }
                if (property == ThinletDTD.getProperty("dialog", "modal")) {
                    this.map.put(component, property, new Boolean(b), value);
                    b = false;
                }
                if (property == ThinletDTD.getProperty("dialog", "closable")) break;
                this.thinlet.setBoolean(component, key, b);
                break;
            }
            case 1: {
                this.thinlet.setInteger(component, key, Integer.parseInt(value));
                break;
            }
            case 3: {
                this.thinlet.setChoice(component, key, value);
                break;
            }
            case 4: {
                this.thinlet.setColor(component, key, ThinletWorkarounds.string2color(value));
                break;
            }
            case 5: {
                Image icon = this.loadIcon(value);
                this.thinlet.setIcon(component, key, icon);
                this.map.put(component, property, icon, value);
                break;
            }
            case 6: {
                this.thinlet.setFont(component, key, ThinletWorkarounds.string2font(this.thinlet, value));
                break;
            }
            case 7: {
                this.thinlet.setKeystroke(component, key, value);
                break;
            }
            case 10: {
                StringTokenizer st = new StringTokenizer(value, ";");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    int equals = token.indexOf(61);
                    if (equals == -1) {
                        throw new IllegalArgumentException("property " + token + ": no '=' char");
                    }
                    this.thinlet.putProperty(component, (Object)token.substring(0, equals), (Object)token.substring(equals + 1));
                }
                break;
            }
            case 8: 
            case 11: {
                this.map.put(component, property, value, value);
                break;
            }
            case 9: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown property type: " + property.getType());
            }
        }
    }

    private Image loadIcon(String path) {
        Image image;
        block10: {
            image = null;
            try {
                image = Toolkit.getDefaultToolkit().getImage(new URL(path));
            }
            catch (MalformedURLException e) {
                String iconDir = Settings.getIconDir();
                File file = new File(iconDir, path);
                if (file.exists()) {
                    try {
                        FileInputStream is = new FileInputStream(file);
                        byte[] data = new byte[is.available()];
                        is.read(data, 0, data.length);
                        image = this.thinlet.getToolkit().createImage(data);
                        is.close();
                    }
                    catch (FileNotFoundException ignore) {
                        if (PropertyManager.debug()) {
                            log.fine("icon file not found: " + file);
                        }
                        break block10;
                    }
                    catch (IOException ioex) {
                        log.log(Level.SEVERE, "IOException during load of " + file, ioex);
                    }
                }
                if (!PropertyManager.debug()) break block10;
                log.fine("icon file not found: " + file);
            }
        }
        if (image != null) {
            MediaTracker mediatracker = new MediaTracker((Component)this.thinlet);
            mediatracker.addImage(image, 1);
            try {
                mediatracker.waitForID(1, 5000L);
            }
            catch (InterruptedException ie) {
                log.warning("loading of image " + path + " has been interrupted!");
            }
        }
        return image;
    }

    public void removeComponent(Object component) {
        this.map.removeAll(component);
    }

    public static String getDefaultValueString(ThinletDTD.Property property) {
        Object obj = property.getDefaultValue();
        return PropertyManager.value2string(obj);
    }

    public static ThinletDTD.Property getProperty(Object component, String propName) {
        String classname = Thinlet.getClass((Object)component);
        ThinletDTD.Property property = ThinletDTD.getProperty(classname, propName);
        return property;
    }

    private static String value2string(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof Boolean) {
            return ((Boolean)obj).toString();
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).toString();
        }
        if (obj instanceof Color) {
            return AWTUtils.getColorString((Color)obj);
        }
        if (obj instanceof Image) {
            return "";
        }
        if (obj instanceof Font) {
            return AWTUtils.getFontString((Font)obj);
        }
        throw new IllegalArgumentException("unexpected property type class: " + obj.getClass().getName());
    }

    private static class PropertyMap {
        private HashMap map = new HashMap();

        public void put(Object component, ThinletDTD.Property property, Object value, String valueString) {
            this.map.put(new Key(component, property), new Value(value, valueString));
        }

        public Object getValue(Object component, ThinletDTD.Property property) {
            Value value = (Value)this.map.get(new Key(component, property));
            return value != null ? value.value : null;
        }

        public String getValueString(Object component, ThinletDTD.Property property) {
            Value value = (Value)this.map.get(new Key(component, property));
            return value != null ? value.valueString : null;
        }

        public void remove(Object component, ThinletDTD.Property property) {
            this.map.remove(new Key(component, property));
        }

        public void removeAll(Object component) {
            Iterator it = this.map.keySet().iterator();
            while (it.hasNext()) {
                Key key = (Key)it.next();
                if (key.component != component) continue;
                it.remove();
            }
        }

        private static class Value {
            Object value;
            String valueString;

            public Value(Object value, String valueString) {
                this.value = value;
                this.valueString = valueString;
            }
        }

        private static class Key {
            Object component;
            ThinletDTD.Property property;

            public Key(Object component, ThinletDTD.Property property) {
                this.component = component;
                this.property = property;
            }

            public boolean equals(Object other) {
                Key otherkey = (Key)other;
                return this.component == otherkey.component && this.property == otherkey.property;
            }

            public int hashCode() {
                return this.component.hashCode() + 3 * this.property.hashCode() + 7;
            }
        }
    }
}

